/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.txn.LockType;
import java.util.ArrayList;
import java.util.List;

public class CountEstimator {
    private static final int MAX_RETRIES_AFTER_SPLIT = 100;
    private final DatabaseImpl dbImpl;
    private List<TrackingInfo> beginStack;
    private List<TrackingInfo> endStack;
    private final List<List<TrackingInfo>> avgEntriesStacks = new ArrayList<List<TrackingInfo>>();
    private int levelCount;
    private int rootLevel;
    private float[] avgEntries;

    public static long count(DatabaseImpl dbImpl, CursorImpl beginCursor, boolean beginInclusive, CursorImpl endCursor, boolean endInclusive) {
        if (beginCursor.isOnSamePosition(endCursor)) {
            return 1L;
        }
        CountEstimator estimator = new CountEstimator(dbImpl);
        return estimator.count(beginCursor, endCursor) + (long)(beginInclusive ? 1 : 0) + (long)(endInclusive ? 1 : 0);
    }

    private CountEstimator(DatabaseImpl dbImpl) {
        this.dbImpl = dbImpl;
    }

    private long count(CursorImpl beginCursor, CursorImpl endCursor) {
        int numRetries = 0;
        while (true) {
            if (numRetries > 100) {
                throw EnvironmentFailureException.unexpectedState();
            }
            this.beginStack = beginCursor.getAncestorPath();
            if (this.beginStack != null) {
                this.endStack = endCursor.getAncestorPath();
                if (this.endStack != null && this.findCommonAncestor()) {
                    this.getAvgEntries(beginCursor, endCursor);
                    return this.countTotal();
                }
            }
            ++numRetries;
        }
    }

    private boolean findCommonAncestor() {
        this.levelCount = this.beginStack.size();
        if (this.levelCount != this.endStack.size()) {
            return false;
        }
        this.rootLevel = -1;
        for (int level = this.levelCount - 1; level >= 0; --level) {
            if (this.beginStack.get((int)level).nodeId != this.endStack.get((int)level).nodeId) continue;
            this.rootLevel = level;
            break;
        }
        return this.rootLevel >= 0;
    }

    private void getAvgEntries(CursorImpl beginCursor, CursorImpl endCursor) {
        this.avgEntriesStacks.clear();
        if (!this.addAvgEntriesSample(this.beginStack)) {
            this.sampleNextBIN(beginCursor, true);
        }
        if (!this.addAvgEntriesSample(this.endStack)) {
            this.sampleNextBIN(endCursor, false);
        }
        this.computeAvgEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sampleNextBIN(CursorImpl beginOrEndCursor, boolean moveForward) {
        try (CursorImpl cursor = beginOrEndCursor.cloneCursor(true);){
            List<TrackingInfo> stack;
            cursor.latchBIN();
            if (moveForward) {
                cursor.setOnLastSlot();
            } else {
                cursor.setOnFirstSlot();
            }
            OperationStatus status = cursor.getNext(null, null, LockType.NONE, false, moveForward, true, null);
            if (status == OperationStatus.SUCCESS && (stack = cursor.getAncestorPath()) != null) {
                this.addAvgEntriesSample(stack);
            }
        }
    }

    private void computeAvgEntries() {
        this.avgEntries = new float[this.levelCount];
        this.avgEntries[this.levelCount - 1] = 1.0f;
        if (this.avgEntriesStacks.size() == 0) {
            return;
        }
        for (int level = this.levelCount - 1; level > 0; --level) {
            long totalEntries = 0L;
            for (List<TrackingInfo> stack : this.avgEntriesStacks) {
                totalEntries += (long)stack.get((int)level).entries;
            }
            float avg = (float)totalEntries / (float)this.avgEntriesStacks.size();
            this.avgEntries[level - 1] = avg * this.avgEntries[level];
        }
    }

    private boolean addAvgEntriesSample(List<TrackingInfo> stack) {
        if (this.isFirstBIN(stack) || this.isLastBIN(stack)) {
            return false;
        }
        this.avgEntriesStacks.add(stack);
        return true;
    }

    private boolean isFirstBIN(List<TrackingInfo> stack) {
        for (int i = 0; i < stack.size() - 1; ++i) {
            TrackingInfo info = stack.get(i);
            if (info.index == 0) continue;
            return false;
        }
        return true;
    }

    private boolean isLastBIN(List<TrackingInfo> stack) {
        for (int i = 0; i < stack.size() - 1; ++i) {
            TrackingInfo info = stack.get(i);
            if (info.index == info.entries - 1) continue;
            return false;
        }
        return true;
    }

    private long countTotal() {
        long total = 0L;
        int rootIndex2 = this.endStack.get((int)this.rootLevel).index;
        int rootIndex1 = this.beginStack.get((int)this.rootLevel).index + 1;
        if (rootIndex2 > rootIndex1) {
            total += (long)Math.round((float)(rootIndex2 - rootIndex1) * this.avgEntries[this.rootLevel]);
        }
        for (int level = this.rootLevel + 1; level < this.levelCount; ++level) {
            int lastIndex = this.beginStack.get((int)level).entries - 1;
            int leftIndex = this.beginStack.get((int)level).index;
            if (lastIndex > leftIndex) {
                total += (long)Math.round((float)(lastIndex - leftIndex) * this.avgEntries[level]);
            }
            int rightIndex = this.endStack.get((int)level).index;
            boolean firstIndex = false;
            if (rightIndex <= 0) continue;
            total += (long)Math.round((float)(rightIndex - 0) * this.avgEntries[level]);
        }
        return total;
    }

    static KeyRatios getKeyRatios(List<TrackingInfo> infoByLevel, boolean exact) {
        double equal;
        double factor = 1.0;
        double less = 0.0;
        double greater = 0.0;
        for (TrackingInfo info : infoByLevel) {
            if (info.index == 0) {
                greater += factor * (double)(info.entries - 1) / (double)info.entries;
            } else if (info.index == info.entries) {
                less += factor;
            } else {
                less += factor * (double)info.index / (double)info.entries;
                greater += factor * (double)(info.entries - info.index - 1) / (double)info.entries;
            }
            factor /= (double)info.entries;
        }
        if (exact) {
            equal = factor;
        } else {
            if (less != 1.0) {
                greater += factor;
            }
            equal = 0.0;
        }
        return new KeyRatios(less, equal, greater);
    }

    static class KeyRatios {
        final double less;
        final double equal;
        final double greater;

        KeyRatios(double less, double equal, double greater) {
            this.less = less;
            this.equal = equal;
            this.greater = greater;
        }

        public String toString() {
            return "less: " + this.less + " equal: " + this.equal + " greater: " + this.greater;
        }
    }
}

