/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.utilint.ActiveTxnArrayStat;
import com.sleepycat.je.utilint.AtomicLongStat;
import com.sleepycat.je.utilint.BooleanStat;
import com.sleepycat.je.utilint.FloatStat;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.IntegralLongAvgStat;
import com.sleepycat.je.utilint.LongArrayStat;
import com.sleepycat.je.utilint.LongMaxStat;
import com.sleepycat.je.utilint.LongMinStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StringStat;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class StatGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String groupName;
    private final String groupDescription;
    private final Map<StatDefinition, Stat<?>> stats;

    public StatGroup(String groupName, String groupDescription) {
        this(groupName, groupDescription, new HashMap());
    }

    private StatGroup(String groupName, String groupDescription, Map<StatDefinition, Stat<?>> values) {
        this.groupName = groupName;
        this.groupDescription = groupDescription;
        this.stats = values;
    }

    public Map<StatDefinition, Stat<?>> getStats() {
        return Collections.unmodifiableMap(this.stats);
    }

    void register(Stat<?> oneStat) {
        Stat<?> prev = this.stats.put(oneStat.getDefinition(), oneStat);
        assert (prev == null) : "prev = " + prev + " oneStat=" + oneStat.getDefinition();
    }

    public void addAll(StatGroup other) {
        for (Map.Entry<StatDefinition, Stat<?>> entry : other.stats.entrySet()) {
            StatDefinition definition = entry.getKey();
            Stat<?> localStat = this.stats.get(definition);
            if (localStat == null) {
                this.stats.put(definition, entry.getValue());
                continue;
            }
            Stat<?> additionalValue = entry.getValue();
            localStat.add(additionalValue);
        }
    }

    public StatGroup computeInterval(StatGroup baseGroup) {
        HashMap intervalValues = new HashMap();
        for (Map.Entry<StatDefinition, Stat<?>> entry : this.stats.entrySet()) {
            StatDefinition definition = entry.getKey();
            Stat<?> statValue = entry.getValue();
            Stat<?> baseStat = baseGroup.stats.get(definition);
            if (baseStat == null) {
                intervalValues.put(definition, statValue.copy());
                continue;
            }
            intervalValues.put(definition, statValue.computeInterval(baseStat));
        }
        return new StatGroup(this.groupName, this.groupDescription, intervalValues);
    }

    public void clear() {
        for (Stat<?> s : this.stats.values()) {
            s.clear();
        }
    }

    public void negate() {
        for (Stat<?> s : this.stats.values()) {
            s.negate();
        }
    }

    public String getName() {
        return this.groupName;
    }

    public String getDescription() {
        return this.groupDescription;
    }

    public StatGroup cloneGroup(boolean clear) {
        HashMap copyValues = new HashMap();
        for (Stat<?> s : this.stats.values()) {
            if (clear) {
                copyValues.put(s.getDefinition(), s.copyAndClear());
                continue;
            }
            copyValues.put(s.getDefinition(), s.copy());
        }
        return new StatGroup(this.groupName, this.groupDescription, copyValues);
    }

    public int getInt(StatDefinition definition) {
        IntStat s = (IntStat)this.stats.get(definition);
        if (s == null) {
            return 0;
        }
        return s.get();
    }

    public LongStat getLongStat(StatDefinition definition) {
        return (LongStat)this.stats.get(definition);
    }

    public long getLong(StatDefinition definition) {
        long retval = 0L;
        Stat<?> s = this.stats.get(definition);
        if (s == null) {
            retval = 0L;
        } else if (s instanceof LongStat) {
            retval = ((LongStat)s).get();
        } else if (s instanceof AtomicLongStat) {
            retval = ((AtomicLongStat)s).get();
        } else if (s instanceof IntegralLongAvgStat) {
            retval = ((IntegralLongAvgStat)s).get().compute();
        } else assert (false) : "Internal error calling getLong() with unknown stat type.";
        return retval;
    }

    public IntegralLongAvgStat getIntegralLongAvgStat(StatDefinition definition) {
        return (IntegralLongAvgStat)this.stats.get(definition);
    }

    public LongMinStat getLongMinStat(StatDefinition definition) {
        return (LongMinStat)this.stats.get(definition);
    }

    public LongMaxStat getLongMaxStat(StatDefinition definition) {
        return (LongMaxStat)this.stats.get(definition);
    }

    public AtomicLongStat getAtomicLongStat(StatDefinition definition) {
        return (AtomicLongStat)this.stats.get(definition);
    }

    public Long getAtomicLong(StatDefinition definition) {
        AtomicLongStat s = (AtomicLongStat)this.stats.get(definition);
        if (s == null) {
            return 0L;
        }
        return s.get();
    }

    public TransactionStats.Active[] getActiveTxnArray(StatDefinition definition) {
        ActiveTxnArrayStat s = (ActiveTxnArrayStat)this.stats.get(definition);
        if (s == null) {
            return null;
        }
        return s.get();
    }

    public long[] getLongArray(StatDefinition definition) {
        LongArrayStat s = (LongArrayStat)this.stats.get(definition);
        if (s == null) {
            return null;
        }
        return s.get();
    }

    public float getFloat(StatDefinition definition) {
        FloatStat s = (FloatStat)this.stats.get(definition);
        if (s == null) {
            return 0.0f;
        }
        return s.get().floatValue();
    }

    public boolean getBoolean(StatDefinition definition) {
        BooleanStat s = (BooleanStat)this.stats.get(definition);
        if (s == null) {
            return false;
        }
        return s.get();
    }

    public String getString(StatDefinition definition) {
        StringStat s = (StringStat)this.stats.get(definition);
        if (s == null) {
            return null;
        }
        return s.get();
    }

    public void addToTipMap(Map<String, String> tips) {
        tips.put(this.getName(), this.getDescription());
        for (StatDefinition d : this.stats.keySet()) {
            tips.put(d.getName(), d.getDescription());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupName).append(": ");
        sb.append(this.groupDescription).append("\n");
        TreeMap sortedStats = new TreeMap(this.stats);
        for (Stat s : sortedStats.values()) {
            sb.append("\t").append(s).append("\n");
        }
        return sb.toString();
    }

    public String toStringVerbose() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupName).append(": ");
        sb.append(this.groupDescription).append("\n");
        TreeMap sortedStats = new TreeMap(this.stats);
        for (Stat s : sortedStats.values()) {
            sb.append("\t").append(s.toStringVerbose()).append("\n");
        }
        return sb.toString();
    }

    public String toStringConcise() {
        boolean headerPrinted = false;
        StringBuilder sb = new StringBuilder();
        TreeMap sortedStats = new TreeMap(this.stats);
        for (Stat s : sortedStats.values()) {
            if (s.isNotSet()) continue;
            if (!headerPrinted) {
                sb.append(this.groupName + "\n");
                headerPrinted = true;
            }
            sb.append("\t").append(s).append("\n");
        }
        return sb.toString();
    }

    public String getCSVHeader() {
        StringBuilder sb = new StringBuilder();
        for (StatDefinition def : this.stats.keySet()) {
            sb.append(this.groupName + "_" + def.getName() + ",");
        }
        return sb.toString();
    }

    public String getCSVData() {
        StringBuilder sb = new StringBuilder();
        for (Stat<?> s : this.stats.values()) {
            sb.append(s.getFormattedValue() + ",");
        }
        return sb.toString();
    }
}

