/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.RecordVersion;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.ThroughputStatGroup;
import java.util.HashSet;
import java.util.logging.Level;

public class SecondaryCursor
extends Cursor {
    private final SecondaryDatabase secondaryDb;
    private ThroughputStatGroup thrput;

    SecondaryCursor(SecondaryDatabase dbHandle, Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        super((Database)dbHandle, txn, cursorConfig);
        this.secondaryDb = dbHandle;
        this.thrput = dbHandle.getEnvironment().getEnvironmentImpl().getThroughputStatGroup();
    }

    SecondaryCursor(SecondaryDatabase dbHandle, Locker locker, CursorConfig cursorConfig) throws DatabaseException {
        super((Database)dbHandle, locker, cursorConfig);
        this.secondaryDb = dbHandle;
    }

    private SecondaryCursor(SecondaryCursor cursor, boolean samePosition) throws DatabaseException {
        super(cursor, samePosition);
        this.secondaryDb = cursor.secondaryDb;
        this.thrput = cursor.thrput;
    }

    @Override
    boolean isSecondaryCursor() {
        return true;
    }

    @Override
    public SecondaryDatabase getDatabase() {
        return this.secondaryDb;
    }

    public Database getPrimaryDatabase() {
        return this.secondaryDb.getPrimaryDatabase();
    }

    @Override
    public SecondaryCursor dup(boolean samePosition) throws DatabaseException {
        this.checkState(false);
        return new SecondaryCursor(this, samePosition);
    }

    public SecondaryCursor dupSecondary(boolean samePosition) throws DatabaseException {
        return this.dup(samePosition);
    }

    @Override
    public OperationStatus delete() throws LockConflictException, DatabaseException, UnsupportedOperationException, IllegalStateException {
        LockMode lockMode;
        DatabaseEntry pKey;
        DatabaseEntry key;
        OperationStatus status;
        this.checkState(true);
        this.trace(Level.FINEST, "SecondaryCursor.delete: ", null);
        if (this.thrput != null) {
            this.thrput.increment(21);
        }
        if ((status = this.getCurrentInternal(key = new DatabaseEntry(), pKey = new DatabaseEntry(), lockMode = this.getLockPrimaryOnly(LockMode.RMW, null) ? LockMode.READ_UNCOMMITTED_ALL : LockMode.RMW)) == OperationStatus.SUCCESS) {
            Locker locker = this.cursorImpl.getLocker();
            Database primaryDb = this.secondaryDb.getPrimary(pKey);
            if (primaryDb == null) {
                this.deleteNoNotify(this.getDatabaseImpl().getRepContext());
            } else {
                status = primaryDb.deleteInternal(locker, pKey);
                if (status != OperationStatus.SUCCESS && lockMode == LockMode.RMW) {
                    throw this.secondaryDb.secondaryRefersToMissingPrimaryKey(locker, key, pKey);
                }
            }
        }
        return status;
    }

    @Override
    public OperationStatus put(DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putCurrent(DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getCurrent(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getCurrent: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(22);
        }
        return this.getCurrentInternal(key, pKey, data, lockMode);
    }

    @Override
    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getFirst(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getFirst: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(23);
        }
        return this.position(key, pKey, data, lockMode, true, this.getLockPrimaryOnly(lockMode, data));
    }

    @Override
    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getLast(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getLast: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(24);
        }
        return this.position(key, pKey, data, lockMode, false, this.getLockPrimaryOnly(lockMode, data));
    }

    @Override
    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getNext(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getNext: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(25);
        }
        boolean lockPrimaryOnly = this.getLockPrimaryOnly(lockMode, data);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, pKey, data, lockMode, true, lockPrimaryOnly);
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.NEXT, lockPrimaryOnly);
    }

    @Override
    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getNextDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getNextDup: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(26);
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.NEXT_DUP, this.getLockPrimaryOnly(lockMode, data));
    }

    @Override
    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getNextNoDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getNextNoDup: ", null, null, lockMode);
        if (this.thrput != null) {
            this.thrput.increment(27);
        }
        boolean lockPrimaryOnly = this.getLockPrimaryOnly(lockMode, data);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, pKey, data, lockMode, true, lockPrimaryOnly);
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.NEXT_NODUP, lockPrimaryOnly);
    }

    @Override
    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getPrev(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getPrev: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(28);
        }
        boolean lockPrimaryOnly = this.getLockPrimaryOnly(lockMode, data);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, pKey, data, lockMode, false, lockPrimaryOnly);
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.PREV, lockPrimaryOnly);
    }

    @Override
    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getPrevDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getPrevDup: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(29);
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.PREV_DUP, this.getLockPrimaryOnly(lockMode, data));
    }

    @Override
    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getPrevNoDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getPrevNoDup: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(30);
        }
        boolean lockPrimaryOnly = this.getLockPrimaryOnly(lockMode, data);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, pKey, data, lockMode, false, lockPrimaryOnly);
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.PREV_NODUP, lockPrimaryOnly);
    }

    @Override
    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getSearchKey(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "SecondaryCursor.getSearchKey: ", key, null, lockMode);
        return this.search(key, pKey, data, lockMode, CursorImpl.SearchMode.SET);
    }

    @Override
    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getSearchKeyRange(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "SecondaryCursor.getSearchKeyRange: ", key, data, lockMode);
        return this.search(key, pKey, data, lockMode, CursorImpl.SearchMode.SET_RANGE);
    }

    @Override
    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "SecondaryCursor.getSearchBoth: ", key, data, lockMode);
        return this.search(key, pKey, data, lockMode, CursorImpl.SearchMode.BOTH);
    }

    @Override
    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "SecondaryCursor.getSearchBothRange: ", key, data, lockMode);
        return this.search(key, pKey, data, lockMode, CursorImpl.SearchMode.BOTH_RANGE);
    }

    private OperationStatus getCurrentInternal(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        boolean lockPrimaryOnly = this.getLockPrimaryOnly(lockMode, data);
        LockMode searchLockMode = lockPrimaryOnly ? LockMode.READ_UNCOMMITTED_ALL : lockMode;
        OperationStatus status = this.getCurrentInternal(key, pKey, searchLockMode);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        return this.readPrimaryAfterGet(key, pKey, data, lockMode, this.isReadUncommittedMode(searchLockMode), lockPrimaryOnly);
    }

    OperationStatus search(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode) throws DatabaseException {
        boolean lockPrimaryOnly = this.getLockPrimaryOnly(lockMode, data);
        LockMode searchLockMode = lockPrimaryOnly ? LockMode.READ_UNCOMMITTED_ALL : lockMode;
        OperationStatus status = this.search(key, pKey, searchLockMode, searchMode);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        status = this.readPrimaryAfterGet(key, pKey, data, lockMode, this.isReadUncommittedMode(searchLockMode), lockPrimaryOnly);
        if (status == OperationStatus.SUCCESS) {
            return status;
        }
        switch (searchMode) {
            case BOTH: {
                return OperationStatus.NOTFOUND;
            }
            case SET: 
            case BOTH_RANGE: {
                return this.retrieveNext(key, pKey, data, lockMode, GetMode.NEXT_DUP, lockPrimaryOnly);
            }
            case SET_RANGE: {
                return this.retrieveNext(key, pKey, data, lockMode, GetMode.NEXT, lockPrimaryOnly);
            }
        }
        throw EnvironmentFailureException.unexpectedState();
    }

    private OperationStatus position(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, boolean first, boolean lockPrimaryOnly) throws DatabaseException {
        LockMode searchLockMode = lockPrimaryOnly ? LockMode.READ_UNCOMMITTED_ALL : lockMode;
        OperationStatus status = this.position(key, pKey, searchLockMode, first);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        status = this.readPrimaryAfterGet(key, pKey, data, lockMode, this.isReadUncommittedMode(searchLockMode), lockPrimaryOnly);
        if (status == OperationStatus.SUCCESS) {
            return status;
        }
        return this.retrieveNext(key, pKey, data, lockMode, first ? GetMode.NEXT : GetMode.PREV, lockPrimaryOnly);
    }

    private OperationStatus retrieveNext(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, GetMode getMode, boolean lockPrimaryOnly) {
        OperationStatus status;
        LockMode searchLockMode;
        LockMode lockMode2 = searchLockMode = lockPrimaryOnly ? LockMode.READ_UNCOMMITTED_ALL : lockMode;
        do {
            if ((status = this.retrieveNext(key, pKey, searchLockMode, getMode)) == OperationStatus.SUCCESS) continue;
            return status;
        } while ((status = this.readPrimaryAfterGet(key, pKey, data, lockMode, this.isReadUncommittedMode(searchLockMode), lockPrimaryOnly)) != OperationStatus.SUCCESS);
        return status;
    }

    private boolean getLockPrimaryOnly(LockMode lockMode, DatabaseEntry data) {
        boolean dataRequested = data != null && (!data.getPartial() || data.getPartialLength() != 0);
        return dataRequested && !this.isSerializableIsolation(lockMode) && !this.isReadUncommittedMode(lockMode);
    }

    private OperationStatus readPrimaryAfterGet(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, boolean secDirtyRead, boolean lockPrimaryOnly) {
        Database primaryDb = this.secondaryDb.getPrimary(pKey);
        if (primaryDb == null) {
            return OperationStatus.KEYEMPTY;
        }
        Pair<OperationStatus, RecordVersion> result = this.readPrimaryAfterGet(primaryDb, key, pKey, data, lockMode, secDirtyRead, lockPrimaryOnly);
        this.cursorImpl.setSecondaryCurrentVersion(result.second());
        return result.first();
    }

    @Override
    boolean checkForPrimaryUpdate(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data) {
        SecondaryConfig conf = this.secondaryDb.getPrivateSecondaryConfig();
        boolean possibleIntegrityError = false;
        if (!conf.getImmutableSecondaryKey()) {
            if (conf.getKeyCreator() != null) {
                DatabaseEntry secKey = new DatabaseEntry();
                if (!conf.getKeyCreator().createSecondaryKey(this.secondaryDb, pKey, data, secKey) || !secKey.equals(key)) {
                    possibleIntegrityError = true;
                }
            } else if (conf.getMultiKeyCreator() != null) {
                HashSet<DatabaseEntry> results = new HashSet<DatabaseEntry>();
                conf.getMultiKeyCreator().createSecondaryKeys(this.secondaryDb, pKey, data, results);
                if (!results.contains(key)) {
                    possibleIntegrityError = true;
                }
            }
        }
        return possibleIntegrityError;
    }

    private void checkArgsNoValRequired(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data) {
        DatabaseUtil.checkForNullDbt(key, "key", false);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
    }
}

