/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Arbiter;
import com.sleepycat.je.evictor.EvictorStatDefinition;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.AtomicLongStat;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.FloatStat;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StoppableThreadFactory;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Evictor
implements EnvConfigObserver {
    static final int MAX_BATCHES_PER_RUN = 100;
    private static final boolean traceUINs = false;
    private static final boolean traceBINs = false;
    private static final Level traceLevel = Level.INFO;
    private static final boolean collectEvictionDebugStats = false;
    private final int numLRULists;
    private final boolean useDirtyLRUSet;
    private final boolean allowBinDeltas;
    private final boolean mutateBins;
    private int dbCacheClearCount;
    private boolean runEvictorThreads;
    private int terminateMillis;
    private final ThreadPoolExecutor evictionPool;
    private AtomicBoolean shutdownRequested;
    private final boolean isShared;
    private final EnvironmentImpl firstEnvImpl;
    private final List<EnvInfo> envInfos;
    private int specialEvictionIndex = 0;
    private final Arbiter arbiter;
    private final LRUList[] mixedLRUSet;
    private final LRUList[] dirtyLRUSet;
    private int nextMixedLRUList = 0;
    private int nextDirtyLRUList = 0;
    private boolean isEnabled = false;
    private ReentrancyGuard reentrancyGuard;
    private Logger logger;
    final StatGroup stats;
    final AtomicLongStat nThreadUnavailable;
    final LongStat nEvictionRuns;
    final LongStat nNodesTargeted;
    final LongStat nNodesEvicted;
    final LongStat nRootNodesEvicted;
    final LongStat nLNsEvicted;
    final LongStat nNodesStripped;
    final LongStat nNodesMutated;
    final LongStat nNodesPutBack;
    final LongStat nNodesSkipped;
    final LongStat nNodesMovedToDirtyLRU;
    final AtomicLongStat[] numBytesEvicted;
    final AtomicLongStat nLNFetch;
    final AtomicLongStat nLNFetchMiss;
    final AtomicLongStat nUpperINFetch;
    final AtomicLongStat nUpperINFetchMiss;
    final AtomicLongStat nBINFetch;
    final AtomicLongStat nBINFetchMiss;
    final AtomicLongStat nBINDeltaFetchMiss;
    final FloatStat binFetchMissRatio;
    final AtomicLongStat nFullBINMiss;
    final AtomicLongStat nBinDeltaBlindOps;
    final AtomicLong nINSparseTarget;
    final AtomicLong nINNoTarget;
    final AtomicLong nINCompactKey;
    final IntStat sharedCacheEnvs;
    int numNoEvictionEvents = 0;
    TestHook<Object> preEvictINHook;
    TestHook<IN> evictProfile;

    public Evictor(EnvironmentImpl envImpl) throws DatabaseException {
        this.isShared = envImpl.getSharedCache();
        this.firstEnvImpl = envImpl;
        this.stats = new StatGroup("Cache", "Current size, allocations, and eviction activity.");
        this.nEvictionRuns = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_EVICTION_RUNS);
        this.nNodesTargeted = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_TARGETED);
        this.nNodesEvicted = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_EVICTED);
        this.nRootNodesEvicted = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_ROOT_NODES_EVICTED);
        this.nLNsEvicted = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_LNS_EVICTED);
        this.nNodesStripped = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_STRIPPED);
        this.nNodesMutated = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_MUTATED);
        this.nNodesPutBack = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_PUT_BACK);
        this.nNodesSkipped = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_SKIPPED);
        this.nNodesMovedToDirtyLRU = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_MOVED_TO_DIRTY_LRU);
        this.nLNFetch = new AtomicLongStat(this.stats, EvictorStatDefinition.LN_FETCH);
        this.nBINFetch = new AtomicLongStat(this.stats, EvictorStatDefinition.BIN_FETCH);
        this.nUpperINFetch = new AtomicLongStat(this.stats, EvictorStatDefinition.UPPER_IN_FETCH);
        this.nLNFetchMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.LN_FETCH_MISS);
        this.nBINFetchMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.BIN_FETCH_MISS);
        this.nBINDeltaFetchMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.BIN_DELTA_FETCH_MISS);
        this.nUpperINFetchMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.UPPER_IN_FETCH_MISS);
        this.nFullBINMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.FULL_BIN_MISS);
        this.nBinDeltaBlindOps = new AtomicLongStat(this.stats, EvictorStatDefinition.BIN_DELTA_BLIND_OPS);
        this.binFetchMissRatio = new FloatStat(this.stats, EvictorStatDefinition.BIN_FETCH_MISS_RATIO);
        this.nThreadUnavailable = new AtomicLongStat(this.stats, EvictorStatDefinition.THREAD_UNAVAILABLE);
        this.nINSparseTarget = new AtomicLong(0L);
        this.nINNoTarget = new AtomicLong(0L);
        this.nINCompactKey = new AtomicLong(0L);
        this.sharedCacheEnvs = new IntStat(this.stats, EvictorStatDefinition.EVICTOR_SHARED_CACHE_ENVS);
        EnumSet<EvictionSource> allSources = EnumSet.allOf(EvictionSource.class);
        int numSources = allSources.size();
        this.numBytesEvicted = new AtomicLongStat[numSources];
        for (EvictionSource source : allSources) {
            int index = source.ordinal();
            this.numBytesEvicted[index] = new AtomicLongStat(this.stats, source.getNumBytesEvictedStatDef());
        }
        this.arbiter = new Arbiter(this.firstEnvImpl);
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.reentrancyGuard = new ReentrancyGuard(this.firstEnvImpl, this.logger);
        this.shutdownRequested = new AtomicBoolean(false);
        DbConfigManager configManager = this.firstEnvImpl.getConfigManager();
        int corePoolSize = configManager.getInt(EnvironmentParams.EVICTOR_CORE_THREADS);
        int maxPoolSize = configManager.getInt(EnvironmentParams.EVICTOR_MAX_THREADS);
        long keepAliveTime = configManager.getDuration(EnvironmentParams.EVICTOR_KEEP_ALIVE);
        this.terminateMillis = configManager.getDuration(EnvironmentParams.EVICTOR_TERMINATE_TIMEOUT);
        this.dbCacheClearCount = configManager.getInt(EnvironmentParams.ENV_DB_CACHE_CLEAR_COUNT);
        this.numLRULists = configManager.getInt(EnvironmentParams.EVICTOR_N_LRU_LISTS);
        this.useDirtyLRUSet = configManager.getBoolean(EnvironmentParams.EVICTOR_USE_DIRTY_LRU);
        this.mixedLRUSet = new LRUList[this.numLRULists];
        this.dirtyLRUSet = new LRUList[this.numLRULists];
        for (int i = 0; i < this.numLRULists; ++i) {
            this.mixedLRUSet[i] = new LRUList(i);
            this.dirtyLRUSet[i] = new LRUList(this.numLRULists + i);
        }
        this.envInfos = this.isShared ? new ArrayList<EnvInfo>() : null;
        RejectEvictHandler rejectHandler = new RejectEvictHandler(this.nThreadUnavailable);
        this.evictionPool = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), new StoppableThreadFactory(this.firstEnvImpl, "JEEvictor", this.logger), rejectHandler);
        this.runEvictorThreads = configManager.getBoolean(EnvironmentParams.ENV_RUN_EVICTOR);
        this.allowBinDeltas = configManager.getBoolean(EnvironmentParams.EVICTOR_ALLOW_BIN_DELTAS);
        this.mutateBins = configManager.getBoolean(EnvironmentParams.EVICTOR_MUTATE_BINS);
        this.firstEnvImpl.addConfigObserver(this);
    }

    @Override
    public void envConfigUpdate(DbConfigManager configManager, EnvironmentMutableConfig ignore) throws DatabaseException {
        int corePoolSize = configManager.getInt(EnvironmentParams.EVICTOR_CORE_THREADS);
        int maxPoolSize = configManager.getInt(EnvironmentParams.EVICTOR_MAX_THREADS);
        long keepAliveTime = configManager.getDuration(EnvironmentParams.EVICTOR_KEEP_ALIVE);
        this.terminateMillis = configManager.getDuration(EnvironmentParams.EVICTOR_TERMINATE_TIMEOUT);
        this.dbCacheClearCount = configManager.getInt(EnvironmentParams.ENV_DB_CACHE_CLEAR_COUNT);
        this.evictionPool.setCorePoolSize(corePoolSize);
        this.evictionPool.setMaximumPoolSize(maxPoolSize);
        this.evictionPool.setKeepAliveTime(keepAliveTime, TimeUnit.MILLISECONDS);
        this.runEvictorThreads = configManager.getBoolean(EnvironmentParams.ENV_RUN_EVICTOR);
    }

    public boolean useDirtyLRUSet() {
        return this.useDirtyLRUSet;
    }

    public boolean getMutateToBINDeltas() {
        return this.mutateBins;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean v) {
        this.isEnabled = v;
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.evictionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdownRequested.set(true);
        this.evictionPool.shutdown();
        boolean shutdownFinished = false;
        try {
            shutdownFinished = this.evictionPool.awaitTermination(this.terminateMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (!shutdownFinished) {
                this.evictionPool.shutdownNow();
            }
        }
    }

    public void requestShutdownPool() {
        this.shutdownRequested.set(true);
        this.evictionPool.shutdown();
    }

    public synchronized void addEnvironment(EnvironmentImpl env) {
        if (this.isShared) {
            int numEnvs = this.envInfos.size();
            for (int i = 0; i < numEnvs; ++i) {
                EnvInfo info = this.envInfos.get(i);
                if (info.env != env) continue;
                return;
            }
        } else {
            throw EnvironmentFailureException.unexpectedState();
        }
        EnvInfo info = new EnvInfo();
        info.env = env;
        info.ins = env.getInMemoryINs();
        this.envInfos.add(info);
    }

    public synchronized void removeEnvironment(EnvironmentImpl env) {
        if (this.isShared) {
            int numEnvs = this.envInfos.size();
            for (int i = 0; i < numEnvs; ++i) {
                EnvInfo info = this.envInfos.get(i);
                if (info.env != env) continue;
                try {
                    for (int j = 0; j < this.numLRULists; ++j) {
                        this.mixedLRUSet[j].removeINsForEnv(env);
                        this.dirtyLRUSet[j].removeINsForEnv(env);
                    }
                }
                catch (AssertionError e) {
                    System.out.println("YYYYYYYYYY " + e);
                    ((Throwable)((Object)e)).printStackTrace(System.out);
                    throw e;
                }
                this.envInfos.remove(i);
                return;
            }
        } else {
            throw EnvironmentFailureException.unexpectedState();
        }
    }

    public synchronized boolean checkEnv(EnvironmentImpl env) {
        if (this.isShared) {
            int numEnvs = this.envInfos.size();
            for (int i = 0; i < numEnvs; ++i) {
                EnvInfo info = this.envInfos.get(i);
                if (env != info.env) continue;
                return true;
            }
            return false;
        }
        throw EnvironmentFailureException.unexpectedState();
    }

    public void addBack(IN node) {
        if (this.isEnabled && node.getEnv().getInMemoryINs().isEnabled()) {
            assert (node.getInListResident());
            node.setInDirtyLRU(false);
            this.mixedLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].addBack(node);
        }
    }

    public void addFront(IN node) {
        if (this.isEnabled && node.getEnv().getInMemoryINs().isEnabled()) {
            assert (node.getInListResident());
            node.setInDirtyLRU(false);
            this.mixedLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].addFront(node);
        }
    }

    private void dirtyAddBack(IN node) {
        assert (node.isLatchExclusiveOwner());
        assert (node.getInListResident());
        assert (this.useDirtyLRUSet);
        node.setInDirtyLRU(true);
        this.dirtyLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].addBack(node);
    }

    private void dirtyAddFront(IN node) {
        assert (node.isLatchExclusiveOwner());
        assert (node.getInListResident());
        assert (this.useDirtyLRUSet);
        node.setInDirtyLRU(true);
        this.dirtyLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].addFront(node);
    }

    public void moveBack(IN node) {
        assert (node.isLatchOwner());
        if (node.isInDirtyLRU()) {
            this.dirtyLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].moveBack(node);
        } else {
            this.mixedLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].moveBack(node);
        }
    }

    public void moveFront(IN node) {
        assert (node.isLatchOwner());
        if (node.isInDirtyLRU()) {
            this.dirtyLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].moveFront(node);
        } else {
            this.mixedLRUSet[(int)(node.getNodeId() % (long)this.numLRULists)].moveFront(node);
        }
    }

    public void remove(IN node) {
        assert (node.isLatchOwner());
        int listId = (int)(node.getNodeId() % (long)this.numLRULists);
        if (node.isInDirtyLRU()) {
            this.dirtyLRUSet[listId].remove(node);
        } else {
            this.mixedLRUSet[listId].remove(node);
        }
    }

    public void moveToMixedLRU(IN node) {
        if (this.useDirtyLRUSet) {
            int listId;
            assert (node.isLatchExclusiveOwner());
            if (node.isInDirtyLRU() && this.dirtyLRUSet[listId = (int)(node.getNodeId() % (long)this.numLRULists)].remove(node)) {
                assert (node.getInListResident());
                node.setInDirtyLRU(false);
                this.mixedLRUSet[listId].addBack(node);
            }
        }
    }

    public boolean contains(IN node) {
        assert (node.isLatchOwner());
        int listId = (int)(node.getNodeId() % (long)this.numLRULists);
        if (node.isInDirtyLRU()) {
            return this.dirtyLRUSet[listId].contains(node);
        }
        return this.mixedLRUSet[listId].contains(node);
    }

    long getMixedLRUSize() {
        long size = 0L;
        for (int i = 0; i < this.numLRULists; ++i) {
            size += (long)this.mixedLRUSet[i].getSize();
        }
        return size;
    }

    long getDirtyLRUSize() {
        long size = 0L;
        for (int i = 0; i < this.numLRULists; ++i) {
            size += (long)this.dirtyLRUSet[i].getSize();
        }
        return size;
    }

    void getMixedLRUStats(EnvironmentImpl env, LRUDebugStats stats) {
        stats.reset();
        for (int i = 0; i < this.numLRULists; ++i) {
            this.mixedLRUSet[i].getStats(env, stats);
        }
    }

    void getDirtyLRUStats(EnvironmentImpl env, LRUDebugStats stats) {
        stats.reset();
        for (int i = 0; i < this.numLRULists; ++i) {
            this.dirtyLRUSet[i].getStats(env, stats);
        }
    }

    public void doCriticalEviction(boolean backgroundIO) {
        if (this.arbiter.isOverBudget()) {
            this.alert();
            if (this.arbiter.needCriticalEviction()) {
                this.doEvict(EvictionSource.CRITICAL, backgroundIO);
            }
        }
    }

    public void doDaemonEviction(boolean backgroundIO) {
        if (this.arbiter.isOverBudget()) {
            this.alert();
            if (this.arbiter.needCriticalEviction()) {
                this.doEvict(EvictionSource.DAEMON, backgroundIO);
            }
        }
    }

    public void doManualEvict() throws DatabaseException {
        this.doEvict(EvictionSource.MANUAL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvictOneIN(IN target, EvictionSource source) {
        if (!this.reentrancyGuard.enter()) {
            return;
        }
        try {
            assert (target.isBIN());
            assert (target.isLatchOwner());
            this.remove(target);
            target.releaseLatch();
            long evictedBytes = this.processTarget(null, target, null, -1, false, source, null);
            this.numBytesEvicted[source.ordinal()].add(evictedBytes);
        }
        finally {
            this.reentrancyGuard.leave();
        }
    }

    public void alert() {
        if (!this.runEvictorThreads) {
            return;
        }
        this.evictionPool.execute(new BackgroundEvictTask(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doEvict(EvictionSource source, boolean backgroundIO) throws DatabaseException {
        if (!this.isEnabled) {
            return;
        }
        if (!this.reentrancyGuard.enter()) {
            return;
        }
        this.nEvictionRuns.increment();
        try {
            long maxEvictBytes;
            int nBatches;
            boolean progress = true;
            long bytesEvicted = 0L;
            EvictionDebugStats evictionStats = null;
            for (nBatches = 0; progress && nBatches < 100 && !this.shutdownRequested.get() && (maxEvictBytes = this.arbiter.getEvictionPledge()) != 0L; ++nBatches) {
                bytesEvicted = this.evictBatch(source, backgroundIO, maxEvictBytes, evictionStats);
                this.numBytesEvicted[source.ordinal()].add(bytesEvicted);
                if (bytesEvicted == 0L) {
                    if (this.arbiter.stillNeedsEviction() && this.numNoEvictionEvents == 0 && this.logger.isLoggable(Level.FINE)) {
                        ++this.numNoEvictionEvents;
                        LoggerUtils.fine(this.logger, this.firstEnvImpl, "Eviction pass failed to evict any bytes");
                    } else {
                        ++this.numNoEvictionEvents;
                    }
                    progress = false;
                    continue;
                }
                this.numNoEvictionEvents = 0;
            }
            if (evictionStats != null) {
                System.out.println(evictionStats.toString());
            }
            if (source == EvictionSource.EVICTORTHREAD && this.logger.isLoggable(Level.FINEST)) {
                LoggerUtils.finest(this.logger, this.firstEnvImpl, "Thread evicted " + bytesEvicted + " bytes in " + nBatches + " batches");
            }
        }
        finally {
            this.reentrancyGuard.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long evictBatch(EvictionSource source, boolean bgIO, long maxEvictBytes, EvictionDebugStats evictionStats) throws DatabaseException {
        long totalEvictedBytes = 0L;
        boolean inMixedLRUSet = true;
        int numNodesScannedThisBatch = 0;
        long maxNodesScannedThisBatch = this.getMixedLRUSize();
        maxNodesScannedThisBatch += (long)this.numLRULists;
        assert (TestHookExecute.doHookSetupIfSet(this.evictProfile));
        Evictor evictor = this;
        synchronized (evictor) {
            if (this.isShared) {
                int numEnvs = this.envInfos.size();
                if (numEnvs > 0) {
                    if (this.specialEvictionIndex >= numEnvs) {
                        this.specialEvictionIndex = 0;
                    }
                    EnvInfo info = this.envInfos.get(this.specialEvictionIndex);
                    ++this.specialEvictionIndex;
                    totalEvictedBytes = info.env.specialEviction();
                }
            } else {
                totalEvictedBytes = this.firstEnvImpl.specialEviction();
            }
        }
        DbCache dbCache = new DbCache(this.isShared, this.dbCacheClearCount);
        MemoryBudget memBudget = this.firstEnvImpl.getMemoryBudget();
        try {
            while (totalEvictedBytes < maxEvictBytes && (long)numNodesScannedThisBatch < maxNodesScannedThisBatch && this.arbiter.stillNeedsEviction()) {
                if (!this.isShared && !memBudget.isTreeUsageAboveMinimum()) {
                    break;
                }
                IN target = this.getNextTarget(inMixedLRUSet);
                ++numNodesScannedThisBatch;
                if (target != null) {
                    this.nNodesTargeted.increment();
                    if (evictionStats != null) {
                        evictionStats.incNumSelected();
                    }
                    assert (TestHookExecute.doHookIfSet(this.evictProfile, target));
                    DatabaseImpl targetDb = target.getDatabase();
                    EnvironmentImpl dbEnv = targetDb.getEnv();
                    DatabaseImpl refreshedDb = dbCache.getDb(dbEnv, targetDb.getId());
                    if (refreshedDb != null && !refreshedDb.isDeleted() && refreshedDb == targetDb) {
                        long evictedBytes = 0L;
                        if (target.isDbRoot()) {
                            RootEvictor rootEvictor = new RootEvictor();
                            rootEvictor.target = target;
                            rootEvictor.backgroundIO = bgIO;
                            rootEvictor.source = source;
                            rootEvictor.stats = evictionStats;
                            targetDb.getTree().withRootLatchedExclusive(rootEvictor);
                            if (rootEvictor.flushed) {
                                dbEnv.getDbTree().modifyDbRoot(targetDb);
                            }
                            evictedBytes = rootEvictor.evictedBytes;
                        } else {
                            evictedBytes = this.processTarget(null, target, null, -1, bgIO, source, evictionStats);
                        }
                        totalEvictedBytes += evictedBytes;
                    } else if (targetDb.isDeleteFinished() && target.getInListResident()) {
                        String inInfo = " IN type=" + target.getLogType() + " id=" + target.getNodeId() + " not expected on INList";
                        String errMsg = refreshedDb == null ? inInfo : "Database " + refreshedDb.getDebugName() + " id=" + refreshedDb.getId() + " rootLsn=" + DbLsn.getNoFormatString(refreshedDb.getTree().getRootLsn()) + ' ' + inInfo;
                        throw EnvironmentFailureException.unexpectedState(errMsg);
                    }
                }
                if ((long)numNodesScannedThisBatch < maxNodesScannedThisBatch || totalEvictedBytes >= maxEvictBytes || !inMixedLRUSet) continue;
                numNodesScannedThisBatch = 0;
                maxNodesScannedThisBatch = this.getDirtyLRUSize();
                maxNodesScannedThisBatch += (long)this.numLRULists;
                inMixedLRUSet = false;
                if (evictionStats == null) continue;
                evictionStats.inMixedLRU = false;
            }
        }
        finally {
            dbCache.releaseDbs(this.firstEnvImpl);
        }
        return totalEvictedBytes;
    }

    private IN getNextTarget(boolean inMixedLRUSet) {
        int listId;
        IN target;
        if (inMixedLRUSet) {
            int listId2;
            IN target2;
            if ((target2 = this.mixedLRUSet[listId2 = Math.abs(this.nextMixedLRUList++) % this.numLRULists].removeFront()) != null) {
                // empty if block
            }
            return target2;
        }
        if ((target = this.dirtyLRUSet[listId = Math.abs(this.nextDirtyLRUList++) % this.numLRULists].removeFront()) != null) {
            // empty if block
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long processTarget(RootEvictor rootEvictor, IN target, IN parent, int index, boolean bgIO, EvictionSource source, EvictionDebugStats stats) throws DatabaseException {
        boolean targetIsLatched = false;
        boolean parentIsLatched = false;
        long evictedBytes = 0L;
        if (stats != null) {
            stats.withParent = parent != null || rootEvictor != null;
        }
        try {
            boolean isEvictable;
            DatabaseId dbId2;
            if (parent != null) {
                assert (parent.isLatchExclusiveOwner());
                parentIsLatched = true;
                if (target != parent.getTarget(index)) {
                    this.skip(target, stats);
                    long l = 0L;
                    return l;
                }
                target.latch(CacheMode.UNCHANGED);
            } else if (rootEvictor != null) {
                target = rootEvictor.target;
            } else {
                target.latch(CacheMode.UNCHANGED);
            }
            targetIsLatched = true;
            DatabaseImpl db = target.getDatabase();
            EnvironmentImpl dbEnv = db.getEnv();
            if (!target.getInListResident() || this.contains(target)) {
                this.skip(target, stats);
                long l = 0L;
                return l;
            }
            if (target.getDirty() && dbEnv.isReadOnly()) {
                this.skip(target, stats);
                long l = 0L;
                return l;
            }
            if (target.isUpperIN() && target.hasCachedChildrenFlag()) {
                assert (target.hasResidentChildren());
                this.skip(target, stats);
                long l = 0L;
                return l;
            }
            if (target.isRoot() && ((dbId2 = db.getId()).equals(DbTree.ID_DB_ID) || dbId2.equals(DbTree.NAME_DB_ID))) {
                this.skip(target, stats);
                long l = 0L;
                return l;
            }
            if (dbEnv.getSharedCache()) {
                if (dbEnv.isClosed() || dbEnv.isInvalid()) {
                    this.skip(target, stats);
                    long dbId2 = 0L;
                    return dbId2;
                }
                if (!dbEnv.getMemoryBudget().isTreeUsageAboveMinimum()) {
                    this.putBack(target, stats, 1);
                    long dbId2 = 0L;
                    return dbId2;
                }
            }
            if (target.isPinned()) {
                this.putBack(target, stats, 2);
                long dbId2 = 0L;
                return dbId2;
            }
            if (target.isBIN() && target.getGeneration() == Long.MAX_VALUE) {
                target.setGeneration(0L);
                this.putBack(target, stats, 3);
                long dbId2 = 0L;
                return dbId2;
            }
            for (int i = 0; i < target.getNEntries(); ++i) {
                if (target.getLsn(i) != -1L || target.isResident(i)) continue;
                this.putBack(target, stats, 4);
                long l = 0L;
                return l;
            }
            evictedBytes = target.partialEviction();
            boolean bl = isEvictable = (evictedBytes & 0x4000000000000000L) == 0L;
            if ((evictedBytes &= 0xBFFFFFFFFFFFFFFFL) > 0L && (target.isUpperIN() || source != EvictionSource.CACHEMODE)) {
                this.strippedPutBack(target, stats);
                long l = evictedBytes;
                return l;
            }
            if (!isEvictable) {
                this.putBack(target, stats, 5);
                long l = evictedBytes;
                return l;
            }
            if (target.isBIN() && source != EvictionSource.CACHEMODE && this.getMutateToBINDeltas() && ((BIN)target).canMutateToBINDelta()) {
                BIN bin = (BIN)target;
                assert ((evictedBytes += bin.mutateToBINDelta()) > 0L);
                this.binDeltaPutBack(target, stats);
                long l = evictedBytes;
                return l;
            }
            if ((target.isUpperIN() || source != EvictionSource.CACHEMODE) && this.useDirtyLRUSet() && target.getDirty() && !target.isInDirtyLRU()) {
                this.moveToDirtyLRU(target, stats);
                long l = evictedBytes;
                return l;
            }
            if (rootEvictor != null) {
                evictedBytes += this.evictRoot(rootEvictor, bgIO, source, stats);
            } else if (parent != null) {
                evictedBytes += this.evict(target, parent, index, bgIO, source, stats);
            } else {
                assert (TestHookExecute.doHookIfSet(this.preEvictINHook));
                targetIsLatched = false;
                evictedBytes += this.findParentAndRetry(target, bgIO, source, stats);
            }
            long l = evictedBytes;
            return l;
        }
        finally {
            if (targetIsLatched) {
                target.releaseLatch();
            }
            if (parentIsLatched) {
                parent.releaseLatch();
            }
        }
    }

    private void skip(IN target, EvictionDebugStats stats) {
        this.nNodesSkipped.increment();
    }

    private void putBack(IN target, EvictionDebugStats stats, int caller) {
        if (target.isInDirtyLRU()) {
            this.dirtyAddBack(target);
        } else {
            this.addBack(target);
        }
        if (stats != null) {
            stats.incNumPutBack();
        }
        this.nNodesPutBack.increment();
    }

    private void strippedPutBack(IN target, EvictionDebugStats stats) {
        if (target.isInDirtyLRU()) {
            this.dirtyAddBack(target);
        } else {
            this.addBack(target);
        }
        if (stats != null) {
            stats.incNumStripped();
        }
        this.nNodesStripped.increment();
    }

    private void binDeltaPutBack(IN target, EvictionDebugStats stats) {
        if (target.isInDirtyLRU()) {
            this.dirtyAddBack(target);
        } else {
            this.addBack(target);
        }
        if (stats != null) {
            stats.incNumMutated();
        }
        this.nNodesMutated.increment();
    }

    private void moveToDirtyLRU(IN target, EvictionDebugStats stats) {
        if (stats != null) {
            stats.incNumMoved(target.isBIN());
        }
        this.dirtyAddFront(target);
        this.nNodesMovedToDirtyLRU.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findParentAndRetry(IN target, boolean backgroundIO, EvictionSource source, EvictionDebugStats stats) {
        Tree tree = target.getDatabase().getTree();
        SearchResult result = tree.getParentINForChildIN(target, false, false, CacheMode.UNCHANGED);
        if (result.exactParentFound) {
            return this.processTarget(null, target, result.parent, result.index, backgroundIO, source, stats);
        }
        assert (result.parent == null);
        target.latch(CacheMode.UNCHANGED);
        try {
            if (target.getInListResident()) {
                this.firstEnvImpl.getInMemoryINs().remove(target);
                throw EnvironmentFailureException.unexpectedState("Node " + target.getNodeId() + " has been detached from the in-memory tree, " + "but it is still in the INList");
            }
        }
        finally {
            target.releaseLatch();
        }
        return 0L;
    }

    private long evict(IN target, IN parent, int index, boolean backgroundIO, EvictionSource source, EvictionDebugStats stats) {
        DatabaseImpl db = target.getDatabase();
        EnvironmentImpl dbEnv = db.getEnv();
        long targetLsn = -1L;
        boolean newTargetLsn = false;
        if (target.getDirty()) {
            boolean logProvisional = this.coordinateWithCheckpoint(target, parent);
            targetLsn = target.log(dbEnv.getLogManager(), this.allowBinDeltas, true, logProvisional, backgroundIO, parent);
            newTargetLsn = true;
        } else {
            targetLsn = parent.getLsn(index);
        }
        assert (targetLsn != -1L);
        if (targetLsn != -1L) {
            long evictedBytes = target.getBudgetedMemorySize();
            parent.detachNode(index, newTargetLsn, targetLsn);
            this.nNodesEvicted.increment();
            if (stats != null) {
                stats.incNumEvicted(target.isBIN());
            }
            return evictedBytes;
        }
        this.addBack(target);
        return 0L;
    }

    private long evictRoot(RootEvictor rootEvictor, boolean backgroundIO, EvictionSource source, EvictionDebugStats stats) {
        ChildReference rootRef = rootEvictor.rootRef;
        IN target = (IN)rootRef.getTarget();
        DatabaseImpl db = target.getDatabase();
        EnvironmentImpl dbEnv = db.getEnv();
        INList inList = dbEnv.getInMemoryINs();
        boolean logProvisional = this.coordinateWithCheckpoint(target, null);
        if (target.getDirty()) {
            long newLsn = target.log(dbEnv.getLogManager(), false, false, logProvisional, backgroundIO, null);
            rootRef.setLsn(newLsn);
            rootEvictor.flushed = true;
        }
        inList.remove(target);
        long evictBytes = target.getBudgetedMemorySize();
        rootRef.clearTarget();
        this.nNodesEvicted.increment();
        this.nRootNodesEvicted.increment();
        if (stats != null) {
            stats.incNumEvicted(false);
        }
        return evictBytes;
    }

    private boolean coordinateWithCheckpoint(IN target, IN parent) {
        EnvironmentImpl dbEnv = target.getDatabase().getEnv();
        Checkpointer ckpter = dbEnv.getCheckpointer();
        if (ckpter == null) {
            return false;
        }
        return ckpter.coordinateEvictionWithCheckpoint(target, parent);
    }

    public boolean isCacheFull() {
        return this.arbiter.isCacheFull();
    }

    public boolean wasCacheEverFull() {
        return this.arbiter.wasCacheEverFull();
    }

    public void setRunnableHook(TestHook<Boolean> hook) {
        this.arbiter.setRunnableHook(hook);
    }

    public void setPreEvictINHook(TestHook<Object> hook) {
        this.preEvictINHook = hook;
    }

    public void setEvictProfileHook(TestHook<IN> hook) {
        this.evictProfile = hook;
    }

    public StatGroup getStatsGroup() {
        return this.stats;
    }

    public StatGroup loadStats(StatsConfig config) {
        if (this.isShared) {
            this.sharedCacheEnvs.set(this.envInfos.size());
        }
        float binFetchMisses = this.nBINFetchMiss.get().longValue();
        float binFetches = this.nBINFetch.get().longValue();
        this.binFetchMissRatio.set(Float.valueOf(binFetches > 0.0f ? binFetchMisses / binFetches : 0.0f));
        StatGroup copy = this.stats.cloneGroup(config.getClear());
        new LongStat(copy, EvictorStatDefinition.CACHED_IN_SPARSE_TARGET, this.nINSparseTarget.get());
        new LongStat(copy, EvictorStatDefinition.CACHED_IN_NO_TARGET, this.nINNoTarget.get());
        new LongStat(copy, EvictorStatDefinition.CACHED_IN_COMPACT_KEY, this.nINCompactKey.get());
        copy.addAll(this.getINListStats(config));
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatGroup getINListStats(StatsConfig config) {
        if (this.isShared) {
            StatGroup totalINListStats = new StatGroup("temp", "temp");
            if (config.getFast()) {
                return totalINListStats;
            }
            ArrayList<EnvInfo> copy = null;
            Evictor evictor = this;
            synchronized (evictor) {
                copy = new ArrayList<EnvInfo>(this.envInfos);
            }
            for (EnvInfo ei : copy) {
                totalINListStats.addAll(ei.env.getInMemoryINs().loadStats());
            }
            return totalINListStats;
        }
        return this.firstEnvImpl.getInMemoryINs().loadStats();
    }

    public void incNumLNsEvicted(long inc) {
        this.nLNsEvicted.add(inc);
    }

    public void incLNFetchStats(boolean isMiss) {
        this.nLNFetch.increment();
        if (isMiss) {
            this.nLNFetchMiss.increment();
        }
    }

    public void incUINFetchStats(boolean isMiss) {
        this.nUpperINFetch.increment();
        if (isMiss) {
            this.nUpperINFetchMiss.increment();
        }
    }

    public void incBINFetchStats(boolean isMiss, boolean isDelta) {
        this.nBINFetch.increment();
        if (isMiss) {
            this.nBINFetchMiss.increment();
            if (isDelta) {
                this.nBINDeltaFetchMiss.increment();
            }
        }
    }

    public void incFullBINMissStats() {
        this.nFullBINMiss.increment();
    }

    public void incBinDeltaBlindOps() {
        this.nBinDeltaBlindOps.increment();
    }

    public AtomicLong getNINSparseTarget() {
        return this.nINSparseTarget;
    }

    public AtomicLong getNINNoTarget() {
        return this.nINNoTarget;
    }

    public AtomicLong getNINCompactKey() {
        return this.nINCompactKey;
    }

    static class DbCache {
        boolean shared = false;
        int nOperations = 0;
        int dbCacheClearCount = 0;
        final Map<EnvironmentImpl, Map<DatabaseId, DatabaseImpl>> envMap;
        final Map<DatabaseId, DatabaseImpl> dbMap;

        DbCache(boolean shared, int dbCacheClearCount) {
            this.shared = shared;
            this.dbCacheClearCount = dbCacheClearCount;
            if (shared) {
                this.envMap = new HashMap<EnvironmentImpl, Map<DatabaseId, DatabaseImpl>>();
                this.dbMap = null;
            } else {
                this.dbMap = new HashMap<DatabaseId, DatabaseImpl>();
                this.envMap = null;
            }
        }

        DatabaseImpl getDb(EnvironmentImpl env, DatabaseId dbId) {
            Map<DatabaseId, DatabaseImpl> map;
            if (this.shared) {
                map = this.envMap.get(env);
                if (map == null) {
                    map = new HashMap<DatabaseId, DatabaseImpl>();
                    this.envMap.put(env, map);
                }
            } else {
                map = this.dbMap;
            }
            ++this.nOperations;
            if (this.nOperations % this.dbCacheClearCount == 0) {
                this.releaseDbs(env);
            }
            return env.getDbTree().getDb(dbId, -1L, map);
        }

        void releaseDbs(EnvironmentImpl env) {
            if (this.shared) {
                for (Map.Entry<EnvironmentImpl, Map<DatabaseId, DatabaseImpl>> entry : this.envMap.entrySet()) {
                    EnvironmentImpl sharingEnv = entry.getKey();
                    Map<DatabaseId, DatabaseImpl> map = entry.getValue();
                    sharingEnv.getDbTree().releaseDbs(map);
                    map.clear();
                }
            } else {
                env.getDbTree().releaseDbs(this.dbMap);
                this.dbMap.clear();
            }
        }
    }

    static class RejectEvictHandler
    implements RejectedExecutionHandler {
        private final AtomicLongStat threadUnavailableStat;

        RejectEvictHandler(AtomicLongStat threadUnavailableStat) {
            this.threadUnavailableStat = threadUnavailableStat;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            this.threadUnavailableStat.increment();
        }
    }

    static class BackgroundEvictTask
    implements Runnable {
        private final Evictor evictor;
        private final boolean backgroundIO;

        BackgroundEvictTask(Evictor evictor) {
            this.evictor = evictor;
            this.backgroundIO = true;
        }

        @Override
        public void run() {
            this.evictor.doEvict(EvictionSource.EVICTORTHREAD, this.backgroundIO);
        }
    }

    static class ReentrancyGuard {
        private final ConcurrentHashMap<Thread, Thread> activeThreads;
        private final EnvironmentImpl envImpl;
        private final Logger logger;

        ReentrancyGuard(EnvironmentImpl envImpl, Logger logger) {
            this.envImpl = envImpl;
            this.logger = logger;
            this.activeThreads = new ConcurrentHashMap();
        }

        boolean enter() {
            Thread thisThread = Thread.currentThread();
            if (this.activeThreads.containsKey(thisThread)) {
                LoggerUtils.severe(this.logger, this.envImpl, "reentrant call to eviction from " + LoggerUtils.getStackTrace());
                assert (false) : "reentrant call to eviction from " + LoggerUtils.getStackTrace();
                return false;
            }
            this.activeThreads.put(thisThread, thisThread);
            return true;
        }

        void leave() {
            assert (this.activeThreads.contains(Thread.currentThread()));
            this.activeThreads.remove(Thread.currentThread());
        }
    }

    class RootEvictor
    implements WithRootLatched {
        IN target;
        boolean backgroundIO;
        EvictionSource source;
        EvictionDebugStats stats = null;
        ChildReference rootRef;
        boolean flushed = false;
        long evictedBytes = 0L;

        RootEvictor() {
        }

        @Override
        public IN doWork(ChildReference root) throws DatabaseException {
            IN rootIN = (IN)root.getTarget();
            if (rootIN == null) {
                return null;
            }
            this.rootRef = root;
            rootIN.latch(CacheMode.UNCHANGED);
            if (rootIN == this.target && rootIN.isRoot()) {
                this.evictedBytes = Evictor.this.processTarget(this, null, null, -1, this.backgroundIO, this.source, this.stats);
            } else {
                rootIN.releaseLatch();
            }
            return null;
        }
    }

    private static class EnvInfo {
        EnvironmentImpl env;
        INList ins;

        private EnvInfo() {
        }
    }

    static class LRUList {
        private static final boolean doExpensiveCheck = false;
        private final int id;
        private int size = 0;
        private IN front = null;
        private IN back = null;

        LRUList(int id) {
            this.id = id;
        }

        synchronized void addBack(IN node) {
            if (node.getNextLRUNode() != null || node.getPrevLRUNode() != null) {
                throw EnvironmentFailureException.unexpectedState(node.getEnv(), Thread.currentThread().getId() + "-" + Thread.currentThread().getName() + "-" + node.getEnv().getName() + "Attempting to add node " + node.getNodeId() + " in the LRU, but node is already in the LRU.");
            }
            assert (!node.isDIN() && !node.isDBIN());
            node.setNextLRUNode(node);
            if (this.back != null) {
                node.setPrevLRUNode(this.back);
                this.back.setNextLRUNode(node);
            } else {
                assert (this.front == null);
                node.setPrevLRUNode(node);
            }
            this.back = node;
            if (this.front == null) {
                this.front = this.back;
            }
            ++this.size;
        }

        synchronized void addFront(IN node) {
            if (node.getNextLRUNode() != null || node.getPrevLRUNode() != null) {
                throw EnvironmentFailureException.unexpectedState(node.getEnv(), Thread.currentThread().getId() + "-" + Thread.currentThread().getName() + "-" + node.getEnv().getName() + "Attempting to add node " + node.getNodeId() + " in the LRU, but node is already in the LRU.");
            }
            assert (!node.isDIN() && !node.isDBIN());
            node.setPrevLRUNode(node);
            if (this.front != null) {
                node.setNextLRUNode(this.front);
                this.front.setPrevLRUNode(node);
            } else {
                assert (this.back == null);
                node.setNextLRUNode(node);
            }
            this.front = node;
            if (this.back == null) {
                this.back = this.front;
            }
            ++this.size;
        }

        synchronized void moveBack(IN node) {
            if (node.getNextLRUNode() == null) {
                assert (node.getPrevLRUNode() == null);
                return;
            }
            if (node.getNextLRUNode() == node) {
                assert (this.back == node);
                assert (node.getPrevLRUNode().getNextLRUNode() == node);
            } else {
                assert (this.front != this.back);
                assert (this.size > 1);
                if (node.getPrevLRUNode() == node) {
                    assert (this.front == node);
                    assert (node.getNextLRUNode().getPrevLRUNode() == node);
                    this.front = node.getNextLRUNode();
                    this.front.setPrevLRUNode(this.front);
                } else {
                    assert (this.front != node && this.back != node);
                    assert (node.getPrevLRUNode().getNextLRUNode() == node);
                    assert (node.getNextLRUNode().getPrevLRUNode() == node);
                    node.getPrevLRUNode().setNextLRUNode(node.getNextLRUNode());
                    node.getNextLRUNode().setPrevLRUNode(node.getPrevLRUNode());
                }
                node.setNextLRUNode(node);
                node.setPrevLRUNode(this.back);
                this.back.setNextLRUNode(node);
                this.back = node;
            }
        }

        synchronized void moveFront(IN node) {
            if (node.getNextLRUNode() == null) {
                assert (node.getPrevLRUNode() == null);
                return;
            }
            if (node.getPrevLRUNode() == node) {
                assert (this.front == node);
                assert (node.getNextLRUNode().getPrevLRUNode() == node);
            } else {
                assert (this.front != this.back);
                assert (this.size > 1);
                if (node.getNextLRUNode() == node) {
                    assert (this.back == node);
                    assert (node.getPrevLRUNode().getNextLRUNode() == node);
                    this.back = node.getPrevLRUNode();
                    this.back.setNextLRUNode(this.back);
                } else {
                    assert (this.front != node && this.back != node);
                    assert (node.getPrevLRUNode().getNextLRUNode() == node);
                    assert (node.getNextLRUNode().getPrevLRUNode() == node);
                    node.getPrevLRUNode().setNextLRUNode(node.getNextLRUNode());
                    node.getNextLRUNode().setPrevLRUNode(node.getPrevLRUNode());
                }
                node.setPrevLRUNode(node);
                node.setNextLRUNode(this.front);
                this.front.setPrevLRUNode(node);
                this.front = node;
            }
        }

        synchronized IN removeFront() {
            if (this.front == null) {
                assert (this.back == null);
                return null;
            }
            IN res = this.front;
            if (this.front == this.back) {
                assert (this.front.getNextLRUNode() == this.front);
                assert (this.front.getPrevLRUNode() == this.front);
                assert (this.size == 1);
                this.front = null;
                this.back = null;
            } else {
                assert (this.size > 1);
                this.front = this.front.getNextLRUNode();
                this.front.setPrevLRUNode(this.front);
            }
            res.setNextLRUNode(null);
            res.setPrevLRUNode(null);
            --this.size;
            return res;
        }

        synchronized boolean remove(IN node) {
            if (node.getNextLRUNode() == null) {
                assert (node.getPrevLRUNode() == null);
                return false;
            }
            assert (node.getPrevLRUNode() != null);
            if (this.front == this.back) {
                assert (this.size == 1);
                assert (this.front == node);
                assert (this.front.getNextLRUNode() == this.front);
                assert (this.front.getPrevLRUNode() == this.front);
                this.front = null;
                this.back = null;
            } else if (node.getPrevLRUNode() == node) {
                assert (this.front == node);
                assert (node.getNextLRUNode().getPrevLRUNode() == node);
                this.front = node.getNextLRUNode();
                this.front.setPrevLRUNode(this.front);
            } else if (node.getNextLRUNode() == node) {
                assert (this.back == node);
                assert (node.getPrevLRUNode().getNextLRUNode() == node);
                this.back = node.getPrevLRUNode();
                this.back.setNextLRUNode(this.back);
            } else {
                assert (this.size > 2);
                assert (this.front != this.back);
                assert (this.front != node && this.back != node);
                assert (node.getPrevLRUNode().getNextLRUNode() == node);
                assert (node.getNextLRUNode().getPrevLRUNode() == node);
                node.getPrevLRUNode().setNextLRUNode(node.getNextLRUNode());
                node.getNextLRUNode().setPrevLRUNode(node.getPrevLRUNode());
            }
            node.setNextLRUNode(null);
            node.setPrevLRUNode(null);
            --this.size;
            return true;
        }

        synchronized void removeINsForEnv(EnvironmentImpl env) {
            if (this.front == null) {
                assert (this.back == null);
                return;
            }
            IN node = this.front;
            while (true) {
                IN nextNode = node.getNextLRUNode();
                IN prevNode = node.getPrevLRUNode();
                if (node.getDatabase().getEnv() == env) {
                    node.setNextLRUNode(null);
                    node.setPrevLRUNode(null);
                    if (this.front == this.back) {
                        assert (this.size == 1);
                        assert (this.front == node);
                        assert (nextNode == this.front);
                        assert (prevNode == this.front);
                        this.front = null;
                        this.back = null;
                        --this.size;
                        break;
                    }
                    if (prevNode == node) {
                        assert (this.size > 1);
                        assert (this.front == node);
                        assert (nextNode.getPrevLRUNode() == node);
                        this.front = nextNode;
                        this.front.setPrevLRUNode(this.front);
                        node = this.front;
                        --this.size;
                        continue;
                    }
                    if (nextNode == node) {
                        assert (this.size > 1);
                        assert (this.back == node);
                        assert (prevNode.getNextLRUNode() == node);
                        this.back = prevNode;
                        this.back.setNextLRUNode(this.back);
                        --this.size;
                        break;
                    }
                    assert (this.size > 2);
                    assert (this.front != this.back);
                    assert (this.front != node && this.back != node);
                    assert (prevNode.getNextLRUNode() == node);
                    assert (nextNode.getPrevLRUNode() == node);
                    prevNode.setNextLRUNode(nextNode);
                    nextNode.setPrevLRUNode(prevNode);
                    node = nextNode;
                    --this.size;
                    continue;
                }
                if (nextNode == node) break;
                node = nextNode;
            }
        }

        synchronized boolean contains(IN node) {
            return node.getNextLRUNode() != null;
        }

        private boolean contains2(IN node) {
            if (this.front == null) {
                assert (this.back == null);
                return false;
            }
            IN curr = this.front;
            while (true) {
                if (curr == node) {
                    return true;
                }
                if (curr.getNextLRUNode() == curr) break;
                curr = curr.getNextLRUNode();
            }
            return false;
        }

        int getSize() {
            return this.size;
        }

        synchronized void getStats(EnvironmentImpl env, LRUDebugStats stats) {
            if (this.front == null) {
                assert (this.back == null);
                return;
            }
            IN curr = this.front;
            while (true) {
                if (env == null || curr.getEnv() == env) {
                    ++stats.size;
                    if (curr.getDirty()) {
                        ++stats.dirtySize;
                    }
                    if (curr.isBIN()) {
                        ++stats.numBINs;
                        if (curr.getDirty()) {
                            ++stats.numDirtyBINs;
                        }
                        if (!curr.hasResidentChildren()) {
                            ++stats.numStrippedBINs;
                            if (curr.getDirty()) {
                                ++stats.numDirtyStrippedBINs;
                            }
                        }
                    }
                }
                if (curr.getNextLRUNode() == curr) break;
                curr = curr.getNextLRUNode();
            }
        }
    }

    static class LRUDebugStats {
        int size;
        int dirtySize;
        int numBINs;
        int numDirtyBINs;
        int numStrippedBINs;
        int numDirtyStrippedBINs;

        LRUDebugStats() {
        }

        void reset() {
            this.size = 0;
            this.dirtySize = 0;
            this.numBINs = 0;
            this.numDirtyBINs = 0;
            this.numStrippedBINs = 0;
            this.numDirtyStrippedBINs = 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Clean/Dirty INs = ");
            sb.append(this.size - this.dirtySize);
            sb.append("/");
            sb.append(this.dirtySize);
            sb.append(" BINs = ");
            sb.append(this.numBINs - this.numDirtyBINs);
            sb.append("/");
            sb.append(this.numDirtyBINs);
            sb.append(" Stripped BINs = ");
            sb.append(this.numStrippedBINs - this.numDirtyStrippedBINs);
            sb.append("/");
            sb.append(this.numDirtyStrippedBINs);
            return sb.toString();
        }
    }

    static class EvictionDebugStats {
        boolean inMixedLRU;
        boolean withParent;
        long mixedSize;
        long dirtySize;
        int numSelectedMixed;
        int numSelectedDirty;
        int numPutBackMixed;
        int numPutBackDirty;
        int numBINsStripped1Mixed;
        int numBINsStripped2Mixed;
        int numBINsStripped1Dirty;
        int numBINsStripped2Dirty;
        int numBINsMutatedMixed;
        int numBINsMutatedDirty;
        int numUINsMoved1;
        int numUINsMoved2;
        int numBINsMoved1;
        int numBINsMoved2;
        int numUINsEvictedMixed;
        int numUINsEvictedDirty;
        int numBINsEvictedMixed;
        int numBINsEvictedDirty;

        EvictionDebugStats() {
        }

        void reset() {
            this.inMixedLRU = true;
            this.withParent = false;
            this.mixedSize = 0L;
            this.dirtySize = 0L;
            this.numSelectedMixed = 0;
            this.numSelectedDirty = 0;
            this.numPutBackMixed = 0;
            this.numPutBackDirty = 0;
            this.numBINsStripped1Mixed = 0;
            this.numBINsStripped2Mixed = 0;
            this.numBINsStripped1Dirty = 0;
            this.numBINsStripped2Dirty = 0;
            this.numBINsMutatedMixed = 0;
            this.numBINsMutatedDirty = 0;
            this.numUINsMoved1 = 0;
            this.numUINsMoved2 = 0;
            this.numBINsMoved1 = 0;
            this.numBINsMoved2 = 0;
            this.numUINsEvictedMixed = 0;
            this.numUINsEvictedDirty = 0;
            this.numBINsEvictedMixed = 0;
            this.numBINsEvictedDirty = 0;
        }

        void incNumSelected() {
            if (this.inMixedLRU) {
                ++this.numSelectedMixed;
            } else {
                ++this.numSelectedDirty;
            }
        }

        void incNumPutBack() {
            if (this.inMixedLRU) {
                ++this.numPutBackMixed;
            } else {
                ++this.numPutBackDirty;
            }
        }

        void incNumStripped() {
            if (this.inMixedLRU) {
                if (this.withParent) {
                    ++this.numBINsStripped2Mixed;
                } else {
                    ++this.numBINsStripped1Mixed;
                }
            } else if (this.withParent) {
                ++this.numBINsStripped2Dirty;
            } else {
                ++this.numBINsStripped1Dirty;
            }
        }

        void incNumMutated() {
            if (this.inMixedLRU) {
                ++this.numBINsMutatedMixed;
            } else {
                ++this.numBINsMutatedDirty;
            }
        }

        void incNumMoved(boolean isBIN) {
            if (this.withParent) {
                if (isBIN) {
                    ++this.numBINsMoved2;
                } else {
                    ++this.numUINsMoved2;
                }
            } else if (isBIN) {
                ++this.numBINsMoved1;
            } else {
                ++this.numUINsMoved1;
            }
        }

        void incNumEvicted(boolean isBIN) {
            if (this.inMixedLRU) {
                if (isBIN) {
                    ++this.numBINsEvictedMixed;
                } else {
                    ++this.numUINsEvictedMixed;
                }
            } else if (isBIN) {
                ++this.numBINsEvictedDirty;
            } else {
                ++this.numUINsEvictedDirty;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Eviction stats MIXED: size = ");
            sb.append(this.mixedSize);
            sb.append("\n");
            sb.append("selected = ");
            sb.append(this.numSelectedMixed);
            sb.append(" | ");
            sb.append("put back = ");
            sb.append(this.numPutBackMixed);
            sb.append(" | ");
            sb.append("stripped = ");
            sb.append(this.numBINsStripped1Mixed);
            sb.append("/");
            sb.append(this.numBINsStripped2Mixed);
            sb.append(" | ");
            sb.append("mutated = ");
            sb.append(this.numBINsMutatedMixed);
            sb.append(" | ");
            sb.append("moved = ");
            sb.append(this.numBINsMoved1);
            sb.append("/");
            sb.append(this.numBINsMoved2);
            sb.append(" - ");
            sb.append(this.numUINsMoved1);
            sb.append("/");
            sb.append(this.numUINsMoved2);
            sb.append(" | ");
            sb.append("evicted = ");
            sb.append(this.numBINsEvictedMixed);
            sb.append(" - ");
            sb.append(this.numUINsEvictedMixed);
            sb.append("\n");
            sb.append("Eviction stats DIRTY: size = ");
            sb.append(this.dirtySize);
            sb.append("\n");
            sb.append("selected = ");
            sb.append(this.numSelectedDirty);
            sb.append(" | ");
            sb.append("put back = ");
            sb.append(this.numPutBackDirty);
            sb.append(" | ");
            sb.append("stripped = ");
            sb.append(this.numBINsStripped1Dirty);
            sb.append("/");
            sb.append(this.numBINsStripped2Dirty);
            sb.append(" | ");
            sb.append("mutated = ");
            sb.append(this.numBINsMutatedDirty);
            sb.append(" | ");
            sb.append("evicted = ");
            sb.append(this.numBINsEvictedDirty);
            sb.append(" - ");
            sb.append(this.numUINsEvictedDirty);
            sb.append("\n");
            return sb.toString();
        }
    }

    public static enum EvictionSource {
        EVICTORTHREAD,
        MANUAL,
        CRITICAL,
        CACHEMODE,
        DAEMON;


        public StatDefinition getNumBytesEvictedStatDef() {
            return new StatDefinition("nBytesEvicted" + this.toString(), "Number of bytes evicted, per eviction source. It serves as an indicator of what part of the system is doing eviction work.");
        }
    }
}

