/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.RecoveryProgress;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.RecoveryUtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.CheckpointFileReader;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.INFileReader;
import com.sleepycat.je.log.LNFileReader;
import com.sleepycat.je.log.LastFileReader;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.Trace;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.NameLNLogEntry;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.LevelRecorder;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.recovery.RollbackTracker;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.PreparedTxn;
import com.sleepycat.je.txn.RollbackEnd;
import com.sleepycat.je.txn.RollbackStart;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnChain;
import com.sleepycat.je.txn.UndoReader;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecoveryManager {
    private static final String TRACE_LN_REDO = "LNRedo:";
    private static final String TRACE_LN_UNDO = "LNUndo";
    private static final String TRACE_IN_REPLACE = "INRecover:";
    private static final String TRACE_ROOT_REPLACE = "RootRecover:";
    private static final String TRACE_ROOT_DELETE = "RootDelete:";
    private final EnvironmentImpl envImpl;
    private final int readBufferSize;
    private final RecoveryInfo info;
    private final Map<Long, Long> committedTxnIds;
    private final Set<Long> abortedTxnIds;
    private Map<Long, PreparedTxn> preparedTxns;
    private Set<Long> resurrectedLsns;
    private final Set<DatabaseId> inListBuildDbIds;
    private final Set<DatabaseId> tempDbIds;
    private final Set<DatabaseId> expectDeletedMapLNs;
    private final RollbackTracker rollbackTracker;
    private final RecoveryUtilizationTracker tracker;
    private final StartupTracker startupTracker;
    private final Logger logger;
    private final Set<DatabaseId> logVersion8UpgradeDbs;
    private final AtomicBoolean logVersion8UpgradeDeltas;

    public RecoveryManager(EnvironmentImpl env) throws DatabaseException {
        this.envImpl = env;
        DbConfigManager cm = env.getConfigManager();
        this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        this.committedTxnIds = new HashMap<Long, Long>();
        this.abortedTxnIds = new HashSet<Long>();
        this.preparedTxns = new HashMap<Long, PreparedTxn>();
        this.resurrectedLsns = new HashSet<Long>();
        this.inListBuildDbIds = new HashSet<DatabaseId>();
        this.tempDbIds = new HashSet<DatabaseId>();
        this.expectDeletedMapLNs = new HashSet<DatabaseId>();
        this.tracker = new RecoveryUtilizationTracker(env);
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.rollbackTracker = new RollbackTracker(this.envImpl);
        this.info = new RecoveryInfo();
        this.logVersion8UpgradeDbs = new HashSet<DatabaseId>();
        this.logVersion8UpgradeDeltas = new AtomicBoolean(false);
        this.startupTracker = this.envImpl.getStartupTracker();
        this.startupTracker.setRecoveryInfo(this.info);
    }

    public RecoveryInfo recover(boolean readOnly) throws DatabaseException {
        this.startupTracker.start(StartupTracker.Phase.TOTAL_RECOVERY);
        try {
            boolean forceCheckpoint;
            FileManager fileManager = this.envImpl.getFileManager();
            DbConfigManager configManager = this.envImpl.getConfigManager();
            if (configManager.getBoolean(EnvironmentParams.ENV_RECOVERY_FORCE_NEW_FILE)) {
                fileManager.forceNewLogFile();
                forceCheckpoint = true;
            } else {
                forceCheckpoint = configManager.getBoolean(EnvironmentParams.ENV_RECOVERY_FORCE_CHECKPOINT);
            }
            if (fileManager.filesExist()) {
                fileManager.getAllFileNumbers();
                this.findEndOfLog(readOnly);
                String endOfLogMsg = "Recovery underway, found end of log";
                Trace.traceLazily(this.envImpl, endOfLogMsg);
                this.findLastCheckpoint();
                this.envImpl.getLogManager().setLastLsnAtRecovery(fileManager.getLastUsedLsn());
                this.envImpl.readMapTreeFromLog(this.info.useRootLsn);
                this.buildTree();
            } else {
                LoggerUtils.logMsg(this.logger, this.envImpl, Level.CONFIG, "Recovery w/no files.");
                this.envImpl.getInMemoryINs().enable();
                this.envImpl.getEvictor().setEnabled(true);
                if (!readOnly) {
                    this.envImpl.logMapTreeRoot();
                }
                if (this.envImpl.getSharedCache()) {
                    this.envImpl.getEvictor().addEnvironment(this.envImpl);
                }
                forceCheckpoint = true;
            }
            int ptSize = this.preparedTxns.size();
            if (ptSize > 0) {
                boolean singular = ptSize == 1;
                LoggerUtils.logMsg(this.logger, this.envImpl, Level.INFO, "There " + (singular ? "is " : "are ") + ptSize + " prepared but unfinished " + (singular ? "txn." : "txns."));
                this.preparedTxns = null;
            }
            if (DbInternal.getCreateUP(this.envImpl.getConfigManager().getEnvironmentConfig())) {
                this.startupTracker.start(StartupTracker.Phase.POPULATE_UP);
                this.startupTracker.setProgress(RecoveryProgress.POPULATE_UTILIZATION_PROFILE);
                this.envImpl.getUtilizationProfile().populateCache(this.startupTracker.getCounter(StartupTracker.Phase.POPULATE_UP));
                this.startupTracker.stop(StartupTracker.Phase.POPULATE_UP);
            }
            this.tracker.transferToUtilizationTracker(this.envImpl.getUtilizationTracker());
            if (this.info.checkpointEnd != null) {
                this.envImpl.getCleaner().setLogSummary(this.info.checkpointEnd.getCleanerLogSummary());
            }
            this.removeTempDbs();
            this.deleteMapLNs();
            this.envImpl.preRecoveryCheckpointInit(this.info);
            if (!readOnly && (this.envImpl.getLogManager().getLastLsnAtRecovery() != this.info.checkpointEndLsn || forceCheckpoint)) {
                CheckpointConfig config = new CheckpointConfig();
                config.setForce(true);
                config.setMinimizeRecoveryTime(true);
                this.startupTracker.setProgress(RecoveryProgress.CKPT);
                this.startupTracker.start(StartupTracker.Phase.CKPT);
                this.envImpl.invokeCheckpoint(config, "recovery");
                this.startupTracker.setStats(StartupTracker.Phase.CKPT, this.envImpl.getCheckpointer().loadStats(StatsConfig.DEFAULT));
                this.startupTracker.stop(StartupTracker.Phase.CKPT);
            } else {
                this.envImpl.getCheckpointer().initIntervals(this.info.checkpointStartLsn, this.info.checkpointEndLsn, System.currentTimeMillis());
            }
        }
        catch (IOException e) {
            LoggerUtils.traceAndLogException(this.envImpl, "RecoveryManager", "recover", "Couldn't recover", e);
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_READ, (Throwable)e);
        }
        finally {
            this.startupTracker.stop(StartupTracker.Phase.TOTAL_RECOVERY);
        }
        return this.info;
    }

    private void findEndOfLog(boolean readOnly) throws IOException, DatabaseException {
        this.startupTracker.start(StartupTracker.Phase.FIND_END_OF_LOG);
        this.startupTracker.setProgress(RecoveryProgress.FIND_END_OF_LOG);
        StartupTracker.Counter counter = this.startupTracker.getCounter(StartupTracker.Phase.FIND_END_OF_LOG);
        LastFileReader reader = new LastFileReader(this.envImpl, this.readBufferSize);
        while (reader.readNextEntry()) {
            counter.incNumRead();
            counter.incNumProcessed();
            LogEntryType type = reader.getEntryType();
            if (LogEntryType.LOG_CKPT_END.equals(type)) {
                this.info.checkpointEndLsn = reader.getLastLsn();
                this.info.partialCheckpointStartLsn = -1L;
                continue;
            }
            if (LogEntryType.LOG_CKPT_START.equals(type)) {
                if (this.info.partialCheckpointStartLsn != -1L) continue;
                this.info.partialCheckpointStartLsn = reader.getLastLsn();
                continue;
            }
            if (!LogEntryType.LOG_DBTREE.equals(type)) continue;
            this.info.useRootLsn = reader.getLastLsn();
        }
        assert (reader.getLastValidLsn() != reader.getEndOfLog()) : "lastUsed=" + DbLsn.getNoFormatString(reader.getLastValidLsn()) + " end=" + DbLsn.getNoFormatString(reader.getEndOfLog());
        if (!readOnly) {
            reader.setEndOfFile();
        }
        this.info.lastUsedLsn = reader.getLastValidLsn();
        this.info.nextAvailableLsn = reader.getEndOfLog();
        counter.setRepeatIteratorReads(reader.getNRepeatIteratorReads());
        this.envImpl.getFileManager().setLastPosition(this.info.nextAvailableLsn, this.info.lastUsedLsn, reader.getPrevOffset());
        this.startupTracker.stop(StartupTracker.Phase.FIND_END_OF_LOG);
    }

    private void findLastCheckpoint() throws IOException, DatabaseException {
        this.startupTracker.start(StartupTracker.Phase.FIND_LAST_CKPT);
        this.startupTracker.setProgress(RecoveryProgress.FIND_LAST_CKPT);
        StartupTracker.Counter counter = this.startupTracker.getCounter(StartupTracker.Phase.FIND_LAST_CKPT);
        if (this.info.checkpointEndLsn == -1L) {
            CheckpointFileReader searcher = new CheckpointFileReader(this.envImpl, this.readBufferSize, false, this.info.lastUsedLsn, -1L, this.info.nextAvailableLsn);
            while (searcher.readNextEntry()) {
                counter.incNumRead();
                counter.incNumProcessed();
                if (searcher.isCheckpointEnd()) {
                    this.info.checkpointEndLsn = searcher.getLastLsn();
                    break;
                }
                if (searcher.isCheckpointStart()) {
                    this.info.partialCheckpointStartLsn = searcher.getLastLsn();
                    continue;
                }
                if (!searcher.isDbTree() || this.info.useRootLsn != -1L) continue;
                this.info.useRootLsn = searcher.getLastLsn();
            }
            counter.setRepeatIteratorReads(searcher.getNRepeatIteratorReads());
        }
        if (this.info.checkpointEndLsn == -1L) {
            this.info.checkpointStartLsn = -1L;
            this.info.firstActiveLsn = -1L;
        } else {
            CheckpointEnd checkpointEnd;
            this.info.checkpointEnd = checkpointEnd = (CheckpointEnd)this.envImpl.getLogManager().getEntry(this.info.checkpointEndLsn);
            this.info.checkpointStartLsn = checkpointEnd.getCheckpointStartLsn();
            this.info.firstActiveLsn = checkpointEnd.getFirstActiveLsn();
            if (checkpointEnd.getRootLsn() != -1L && this.info.useRootLsn == -1L) {
                this.info.useRootLsn = checkpointEnd.getRootLsn();
            }
            this.envImpl.getCheckpointer().setCheckpointId(checkpointEnd.getId());
        }
        this.rollbackTracker.setCheckpointStart(this.info.checkpointStartLsn);
        this.startupTracker.stop(StartupTracker.Phase.FIND_LAST_CKPT);
        if (this.info.useRootLsn == -1L) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "This environment's log file has no root. Since the root is the first entry written into a log at environment creation, this should only happen if the initial creation of the environment was never checkpointed or synced. Please move aside the existing log files to allow the creation of a new environment");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTree() throws DatabaseException {
        this.startupTracker.start(StartupTracker.Phase.BUILD_TREE);
        try {
            this.buildINs(true, StartupTracker.Phase.READ_MAP_INS, StartupTracker.Phase.REDO_MAP_INS, RecoveryProgress.READ_DBMAP_INFO, RecoveryProgress.REDO_DBMAP_INFO);
            this.startupTracker.start(StartupTracker.Phase.UNDO_MAP_LNS);
            this.startupTracker.setProgress(RecoveryProgress.UNDO_DBMAP_RECORDS);
            HashSet<LogEntryType> mapLNSet = new HashSet<LogEntryType>();
            mapLNSet.add(LogEntryType.LOG_MAPLN_TRANSACTIONAL);
            mapLNSet.add(LogEntryType.LOG_TXN_COMMIT);
            mapLNSet.add(LogEntryType.LOG_TXN_ABORT);
            mapLNSet.add(LogEntryType.LOG_TXN_PREPARE);
            mapLNSet.add(LogEntryType.LOG_ROLLBACK_START);
            mapLNSet.add(LogEntryType.LOG_ROLLBACK_END);
            this.undoLNs(mapLNSet, true, this.startupTracker.getCounter(StartupTracker.Phase.UNDO_MAP_LNS));
            this.startupTracker.stop(StartupTracker.Phase.UNDO_MAP_LNS);
            this.startupTracker.start(StartupTracker.Phase.REDO_MAP_LNS);
            this.startupTracker.setProgress(RecoveryProgress.REDO_DBMAP_RECORDS);
            mapLNSet.add(LogEntryType.LOG_MAPLN);
            this.redoLNs(mapLNSet, this.startupTracker.getCounter(StartupTracker.Phase.REDO_MAP_LNS));
            this.startupTracker.stop(StartupTracker.Phase.REDO_MAP_LNS);
            this.checkLogVersion8UpgradeViolations();
            this.buildINs(false, StartupTracker.Phase.READ_INS, StartupTracker.Phase.REDO_INS, RecoveryProgress.READ_DATA_INFO, RecoveryProgress.REDO_DATA_INFO);
            this.buildINList();
            if (this.envImpl.getSharedCache()) {
                this.envImpl.getEvictor().addEnvironment(this.envImpl);
            }
            this.envImpl.invokeEvictor();
            this.startupTracker.start(StartupTracker.Phase.UNDO_LNS);
            this.startupTracker.setProgress(RecoveryProgress.UNDO_DATA_RECORDS);
            HashSet<LogEntryType> lnSet = new HashSet<LogEntryType>();
            for (LogEntryType entryType : LogEntryType.getAllTypes()) {
                if (!entryType.isUserLNType() || !entryType.isTransactional()) continue;
                lnSet.add(entryType);
            }
            lnSet.add(LogEntryType.LOG_NAMELN_TRANSACTIONAL);
            this.undoLNs(lnSet, false, this.startupTracker.getCounter(StartupTracker.Phase.UNDO_LNS));
            this.startupTracker.stop(StartupTracker.Phase.UNDO_LNS);
            this.startupTracker.start(StartupTracker.Phase.REDO_LNS);
            this.startupTracker.setProgress(RecoveryProgress.REDO_DATA_RECORDS);
            for (LogEntryType entryType : LogEntryType.getAllTypes()) {
                if (!entryType.isUserLNType() || entryType.isTransactional()) continue;
                lnSet.add(entryType);
            }
            lnSet.add(LogEntryType.LOG_NAMELN);
            lnSet.add(LogEntryType.LOG_FILESUMMARYLN);
            this.redoLNs(lnSet, this.startupTracker.getCounter(StartupTracker.Phase.REDO_LNS));
            this.startupTracker.stop(StartupTracker.Phase.REDO_LNS);
            this.rollbackTracker.recoveryEndFsyncInvisible();
        }
        finally {
            this.startupTracker.stop(StartupTracker.Phase.BUILD_TREE);
        }
    }

    private void buildINs(boolean mappingTree, StartupTracker.Phase phaseA, StartupTracker.Phase phaseB, RecoveryProgress progressA, RecoveryProgress progressB) throws DatabaseException {
        HashSet<LogEntryType> targetEntries = new HashSet<LogEntryType>();
        targetEntries.add(LogEntryType.LOG_IN);
        targetEntries.add(LogEntryType.LOG_BIN);
        targetEntries.add(LogEntryType.LOG_BIN_DELTA);
        targetEntries.add(LogEntryType.LOG_OLD_BIN_DELTA);
        this.startupTracker.start(phaseA);
        this.startupTracker.setProgress(progressA);
        LevelRecorder recorder = new LevelRecorder();
        if (mappingTree) {
            this.readINsAndTrackIds(this.info.checkpointStartLsn, recorder, this.startupTracker.getCounter(phaseA));
        } else {
            this.readINs(this.info.checkpointStartLsn, false, targetEntries, recorder, this.startupTracker.getCounter(phaseA));
        }
        this.startupTracker.stop(phaseA);
        Set<DatabaseId> redoSet = recorder.getDbsWithDifferentLevels();
        if (redoSet.size() > 0) {
            this.startupTracker.start(phaseB);
            this.startupTracker.setProgress(progressB);
            this.repeatReadINs(this.info.checkpointStartLsn, targetEntries, redoSet, this.startupTracker.getCounter(phaseB));
            this.startupTracker.stop(phaseB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readINsAndTrackIds(long rollForwardLsn, LevelRecorder recorder, StartupTracker.Counter counter) throws DatabaseException {
        INFileReader reader = new INFileReader(this.envImpl, this.readBufferSize, rollForwardLsn, this.info.nextAvailableLsn, true, false, this.info.partialCheckpointStartLsn, this.info.checkpointEndLsn, this.tracker, this.logVersion8UpgradeDbs, this.logVersion8UpgradeDeltas);
        reader.addTargetType(LogEntryType.LOG_IN);
        reader.addTargetType(LogEntryType.LOG_BIN);
        reader.addTargetType(LogEntryType.LOG_BIN_DELTA);
        reader.addTargetType(LogEntryType.LOG_OLD_BIN_DELTA);
        reader.setAlwaysValidateChecksum(true);
        try {
            DbTree dbMapTree = this.envImpl.getDbTree();
            while (reader.readNextEntry()) {
                counter.incNumRead();
                DatabaseId dbId = reader.getDatabaseId();
                if (!dbId.equals(DbTree.ID_DB_ID)) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                try {
                    this.replayOneIN(reader, db, reader.isBINDelta(), recorder);
                    counter.incNumProcessed();
                }
                finally {
                    dbMapTree.releaseDb(db);
                }
            }
            counter.setRepeatIteratorReads(reader.getNRepeatIteratorReads());
            this.info.useMinReplicatedNodeId = reader.getMinReplicatedNodeId();
            this.info.useMaxNodeId = reader.getMaxNodeId();
            this.info.useMinReplicatedDbId = reader.getMinReplicatedDbId();
            this.info.useMaxDbId = reader.getMaxDbId();
            this.info.useMinReplicatedTxnId = reader.getMinReplicatedTxnId();
            this.info.useMaxTxnId = reader.getMaxTxnId();
            if (this.info.checkpointEnd != null) {
                CheckpointEnd ckptEnd = this.info.checkpointEnd;
                if (this.info.useMinReplicatedNodeId > ckptEnd.getLastReplicatedNodeId()) {
                    this.info.useMinReplicatedNodeId = ckptEnd.getLastReplicatedNodeId();
                }
                if (this.info.useMaxNodeId < ckptEnd.getLastLocalNodeId()) {
                    this.info.useMaxNodeId = ckptEnd.getLastLocalNodeId();
                }
                if (this.info.useMinReplicatedDbId > ckptEnd.getLastReplicatedDbId()) {
                    this.info.useMinReplicatedDbId = ckptEnd.getLastReplicatedDbId();
                }
                if (this.info.useMaxDbId < ckptEnd.getLastLocalDbId()) {
                    this.info.useMaxDbId = ckptEnd.getLastLocalDbId();
                }
                if (this.info.useMinReplicatedTxnId > ckptEnd.getLastReplicatedTxnId()) {
                    this.info.useMinReplicatedTxnId = ckptEnd.getLastReplicatedTxnId();
                }
                if (this.info.useMaxTxnId < ckptEnd.getLastLocalTxnId()) {
                    this.info.useMaxTxnId = ckptEnd.getLastLocalTxnId();
                }
            }
            this.envImpl.getNodeSequence().setLastNodeId(this.info.useMinReplicatedNodeId, this.info.useMaxNodeId);
            this.envImpl.getDbTree().setLastDbId(this.info.useMinReplicatedDbId, this.info.useMaxDbId);
            this.envImpl.getTxnManager().setLastTxnId(this.info.useMinReplicatedTxnId, this.info.useMaxTxnId);
            this.info.vlsnProxy = reader.getVLSNProxy();
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readMapIns", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readINs(long rollForwardLsn, boolean mapDbOnly, Set<LogEntryType> targetLogEntryTypes, LevelRecorder recorder, StartupTracker.Counter counter) throws DatabaseException {
        INFileReader reader = new INFileReader(this.envImpl, this.readBufferSize, rollForwardLsn, this.info.nextAvailableLsn, false, mapDbOnly, this.info.partialCheckpointStartLsn, this.info.checkpointEndLsn, this.tracker);
        for (LogEntryType t : targetLogEntryTypes) {
            reader.addTargetType(t);
        }
        try {
            DbTree dbMapTree = this.envImpl.getDbTree();
            while (reader.readNextEntry()) {
                DatabaseId dbId = reader.getDatabaseId();
                boolean isMapDb = dbId.equals(DbTree.ID_DB_ID);
                boolean isTarget = false;
                counter.incNumRead();
                if (mapDbOnly && isMapDb) {
                    isTarget = true;
                } else if (!mapDbOnly && !isMapDb) {
                    isTarget = true;
                }
                if (!isTarget) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                try {
                    if (db == null) {
                        counter.incNumDeleted();
                        continue;
                    }
                    this.replayOneIN(reader, db, reader.isBINDelta(), recorder);
                    counter.incNumProcessed();
                    this.inListBuildDbIds.add(dbId);
                }
                finally {
                    dbMapTree.releaseDb(db);
                }
            }
            counter.setRepeatIteratorReads(reader.getNRepeatIteratorReads());
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readNonMapIns", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repeatReadINs(long rollForwardLsn, Set<LogEntryType> targetLogEntryTypes, Set<DatabaseId> targetDbs, StartupTracker.Counter counter) throws DatabaseException {
        INFileReader reader = new INFileReader(this.envImpl, this.readBufferSize, rollForwardLsn, this.info.nextAvailableLsn, false, false, this.info.partialCheckpointStartLsn, this.info.checkpointEndLsn, this.tracker);
        for (LogEntryType t : targetLogEntryTypes) {
            reader.addTargetType(t);
        }
        try {
            DbTree dbMapTree = this.envImpl.getDbTree();
            while (reader.readNextEntry()) {
                counter.incNumRead();
                DatabaseId dbId = reader.getDatabaseId();
                if (!targetDbs.contains(dbId)) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                try {
                    if (db == null) {
                        counter.incNumDeleted();
                        continue;
                    }
                    counter.incNumProcessed();
                    this.replayOneIN(reader, db, true, null);
                }
                finally {
                    dbMapTree.releaseDb(db);
                }
            }
            counter.setRepeatIteratorReads(reader.getNRepeatIteratorReads());
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readNonMapIns", e);
        }
    }

    private void replayOneIN(INFileReader reader, DatabaseImpl db, boolean requireExactMatch, LevelRecorder recorder) throws DatabaseException {
        long logLsn = reader.getLastLsn();
        IN in = reader.getIN(db);
        in.postRecoveryInit(db, logLsn);
        in.latch();
        if (recorder != null) {
            recorder.record(db.getId(), in.getLevel());
        }
        this.recoverIN(db, in, logLsn, requireExactMatch);
    }

    private void undoLNs(Set<LogEntryType> logTypes, boolean firstUndoPass, StartupTracker.Counter counter) throws DatabaseException {
        long firstActiveLsn = this.info.firstActiveLsn;
        long lastUsedLsn = this.info.lastUsedLsn;
        long endOfFileLsn = this.info.nextAvailableLsn;
        LNFileReader reader = new LNFileReader(this.envImpl, this.readBufferSize, lastUsedLsn, false, endOfFileLsn, firstActiveLsn, null, this.info.checkpointEndLsn);
        for (LogEntryType lt : logTypes) {
            reader.addTargetType(lt);
        }
        DbTree dbMapTree = this.envImpl.getDbTree();
        this.rollbackTracker.setFirstPass(firstUndoPass);
        RollbackTracker.Scanner rollbackScanner = this.rollbackTracker.getScanner();
        try {
            while (reader.readNextEntry()) {
                counter.incNumRead();
                if (reader.isLN()) {
                    Long txnId = reader.getTxnId();
                    if (txnId == null) continue;
                    if (rollbackScanner.positionAndCheck(reader.getLastLsn(), txnId)) {
                        rollbackScanner.rollback(txnId, reader, this.tracker);
                        continue;
                    }
                    if (this.committedTxnIds.containsKey(txnId)) continue;
                    if (this.preparedTxns.get(txnId) != null) {
                        this.resurrectedLsns.add(reader.getLastLsn());
                        continue;
                    }
                    if (this.isReplicatedUncommittedLN(reader, txnId)) {
                        this.createReplayTxn(txnId);
                        this.resurrectedLsns.add(reader.getLastLsn());
                        continue;
                    }
                    this.undoUncommittedLN(reader, dbMapTree);
                    counter.incNumProcessed();
                    continue;
                }
                if (reader.isPrepare()) {
                    this.handlePrepare(reader);
                    counter.incNumAux();
                    continue;
                }
                if (reader.isAbort()) {
                    this.abortedTxnIds.add(reader.getTxnAbortId());
                    counter.incNumAux();
                    continue;
                }
                if (reader.isCommit()) {
                    this.rollbackTracker.checkCommit(reader.getLastLsn(), reader.getTxnCommitId());
                    this.committedTxnIds.put(reader.getTxnCommitId(), reader.getLastLsn());
                    counter.incNumAux();
                    continue;
                }
                if (reader.isRollbackStart()) {
                    this.rollbackTracker.register((RollbackStart)reader.getMainItem(), reader.getLastLsn());
                    counter.incNumAux();
                    continue;
                }
                if (reader.isRollbackEnd()) {
                    this.rollbackTracker.register((RollbackEnd)reader.getMainItem(), reader.getLastLsn());
                    counter.incNumAux();
                    continue;
                }
                throw EnvironmentFailureException.unexpectedState(this.envImpl, "LNreader should not have picked up type " + reader.dumpCurrentHeader());
            }
            counter.setRepeatIteratorReads(reader.getNRepeatIteratorReads());
            this.rollbackTracker.singlePassSetInvisible();
        }
        catch (RuntimeException e) {
            this.traceAndThrowException(reader.getLastLsn(), "undoLNs", e);
        }
    }

    private boolean isReplicatedUncommittedLN(LNFileReader reader, Long txnId) {
        if (!this.envImpl.isReplicated()) {
            return false;
        }
        if (this.abortedTxnIds.contains(txnId)) {
            return false;
        }
        return reader.entryIsReplicated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoUncommittedLN(LNFileReader reader, DbTree dbMapTree) throws DatabaseException {
        this.envImpl.invokeEvictor();
        DatabaseId dbId = reader.getDatabaseId();
        DatabaseImpl db = dbMapTree.getDb(dbId);
        if (db == null) {
            return;
        }
        LNLogEntry<?> lnEntry = reader.getLNLogEntry();
        lnEntry.postFetchInit(db);
        LN ln = lnEntry.getLN();
        TreeLocation location = new TreeLocation();
        long logLsn = reader.getLastLsn();
        try {
            MapLN mapLN;
            ln.postFetchInit(db, logLsn);
            this.recoveryUndo(db, location, lnEntry, logLsn);
            this.undoUtilizationInfo(lnEntry, db, logLsn, reader.getLastEntrySize());
            this.inListBuildDbIds.add(dbId);
            if (ln instanceof MapLN && (mapLN = (MapLN)ln).getDatabase().isTemporary()) {
                this.tempDbIds.add(mapLN.getDatabase().getId());
            }
        }
        finally {
            dbMapTree.releaseDb(db);
        }
    }

    private void createReplayTxn(long txnId) throws DatabaseException {
        if (this.info.replayTxns.get(txnId) == null) {
            this.info.replayTxns.put(txnId, this.envImpl.createReplayTxn(txnId));
        }
    }

    private void handlePrepare(LNFileReader reader) throws DatabaseException {
        long prepareId = reader.getTxnPrepareId();
        Long prepareIdL = prepareId;
        if (!this.committedTxnIds.containsKey(prepareIdL) && !this.abortedTxnIds.contains(prepareIdL)) {
            TransactionConfig txnConf = new TransactionConfig();
            PreparedTxn preparedTxn = PreparedTxn.createPreparedTxn(this.envImpl, txnConf, prepareId);
            preparedTxn.setLockTimeout(0L);
            this.preparedTxns.put(prepareIdL, preparedTxn);
            preparedTxn.setPrepared(true);
            this.envImpl.getTxnManager().registerXATxn(reader.getTxnPrepareXid(), preparedTxn, true);
            LoggerUtils.logMsg(this.logger, this.envImpl, Level.INFO, "Found unfinished prepare record: id: " + reader.getTxnPrepareId() + " Xid: " + reader.getTxnPrepareXid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redoLNs(Set<LogEntryType> lnTypes, StartupTracker.Counter counter) throws DatabaseException {
        long endOfFileLsn = this.info.nextAvailableLsn;
        long firstActiveLsn = this.info.firstActiveLsn;
        LNFileReader reader = new LNFileReader(this.envImpl, this.readBufferSize, firstActiveLsn, true, -1L, endOfFileLsn, null, this.info.checkpointEndLsn);
        for (LogEntryType lt : lnTypes) {
            reader.addTargetType(lt);
        }
        DbTree dbMapTree = this.envImpl.getDbTree();
        TreeLocation location = new TreeLocation();
        try {
            while (reader.readNextEntry()) {
                counter.incNumRead();
                RedoEligible eligible = this.eligibleForRedo(reader);
                if (!eligible.isEligible) continue;
                this.envImpl.invokeEvictor();
                DatabaseId dbId = reader.getDatabaseId();
                DatabaseImpl db = dbMapTree.getDb(dbId);
                if (db == null) {
                    counter.incNumDeleted();
                    continue;
                }
                try {
                    LNLogEntry<?> lnEntry = reader.getLNLogEntry();
                    lnEntry.postFetchInit(db);
                    LN ln = lnEntry.getLN();
                    long logLsn = reader.getLastLsn();
                    long treeLsn = -1L;
                    counter.incNumProcessed();
                    treeLsn = this.redoOneLN(reader, lnEntry, logLsn, dbId, db, eligible, location);
                    this.redoUtilizationInfo(logLsn, treeLsn, location.childLoggedSize, eligible.commitLsn, eligible.isCommitted(), reader.getAbortLsn(), reader.getAbortKnownDeleted(), reader.getLastEntrySize(), lnEntry, db);
                }
                finally {
                    dbMapTree.releaseDb(db);
                }
            }
            counter.setRepeatIteratorReads(reader.getNRepeatIteratorReads());
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "redoLns", e);
        }
    }

    private RedoEligible eligibleForRedo(LNFileReader reader) {
        if (!reader.isLN()) {
            return RedoEligible.NOT;
        }
        if (reader.isInvisible()) {
            return RedoEligible.NOT;
        }
        boolean afterCheckpointStart = this.info.checkpointStartLsn == -1L ? true : DbLsn.compareTo(reader.getLastLsn(), this.info.checkpointStartLsn) >= 0;
        Long txnId = reader.getTxnId();
        Txn preparedTxn = this.preparedTxns.get(txnId);
        Txn replayTxn = this.info.replayTxns.get(txnId);
        if (preparedTxn != null) {
            return new RedoEligible(preparedTxn);
        }
        if (replayTxn != null) {
            return new RedoEligible(replayTxn);
        }
        if (afterCheckpointStart) {
            if (txnId == null) {
                return RedoEligible.ELIGIBLE_NON_TXNAL;
            }
            Long commitLongLsn = this.committedTxnIds.get(txnId);
            if (commitLongLsn != null) {
                return new RedoEligible(commitLongLsn);
            }
        }
        return RedoEligible.NOT;
    }

    private void relock(Txn txn, long logLsn, DatabaseImpl db, long abortLsn, boolean abortKnownDeleted) throws DatabaseException {
        txn.addLogInfo(logLsn);
        LockResult result = txn.nonBlockingLock(logLsn, LockType.WRITE, false, db);
        if (result.getLockGrant() == LockGrantType.DENIED) {
            throw EnvironmentFailureException.unexpectedState("Resurrected lock denied txn=" + txn.getId() + " logLsn=" + DbLsn.getNoFormatString(logLsn) + " abortLsn=" + DbLsn.getNoFormatString(abortLsn));
        }
        result.setAbortLsn(abortLsn, abortKnownDeleted);
        WriteLockInfo wli = result.getWriteLockInfo();
        if (wli == null) {
            throw EnvironmentFailureException.unexpectedState("Resurrected lock has no write info txn=" + txn.getId() + " logLsn=" + DbLsn.getNoFormatString(logLsn) + " abortLsn=" + DbLsn.getNoFormatString(abortLsn));
        }
        wli.setAbortInfo(db, 0);
    }

    private long redoOneLN(LNFileReader reader, LNLogEntry lnEntry, long logLsn, DatabaseId dbId, DatabaseImpl db, RedoEligible eligible, TreeLocation location) throws DatabaseException {
        NameLNLogEntry nameLNEntry;
        LN ln = lnEntry.getLN();
        ln.postFetchInit(db, logLsn);
        if (eligible.resurrectTxn != null) {
            this.relock(eligible.resurrectTxn, logLsn, db, reader.getAbortLsn(), reader.getAbortKnownDeleted());
        }
        long treeLsn = this.redo(db, location, lnEntry, logLsn, reader.getLastEntrySize(), eligible);
        this.inListBuildDbIds.add(dbId);
        MapLN mapLN = null;
        if (ln instanceof MapLN && (mapLN = (MapLN)ln).getDatabase().isTemporary()) {
            this.tempDbIds.add(mapLN.getDatabase().getId());
        }
        if (mapLN != null && mapLN.isDeleted()) {
            mapLN.getDatabase().countObsoleteDb(this.tracker, logLsn);
        }
        if (eligible.resurrectTxn == null && (nameLNEntry = reader.getNameLNLogEntry()) != null) {
            switch (nameLNEntry.getOperationType()) {
                case REMOVE: {
                    assert (nameLNEntry.isDeleted());
                    NameLN nameLN = (NameLN)nameLNEntry.getLN();
                    this.expectDeletedMapLNs.add(nameLN.getId());
                    break;
                }
                case TRUNCATE: {
                    DatabaseId truncateId = nameLNEntry.getTruncateOldDbId();
                    assert (truncateId != null);
                    this.expectDeletedMapLNs.add(truncateId);
                }
            }
        }
        if (mapLN != null && mapLN.isDeleted()) {
            this.expectDeletedMapLNs.remove(mapLN.getDatabase().getId());
        }
        return treeLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildINList() throws DatabaseException {
        this.envImpl.getInMemoryINs().enable();
        this.envImpl.getEvictor().setEnabled(true);
        this.envImpl.getDbTree().rebuildINListMapDb();
        for (DatabaseId dbId : this.inListBuildDbIds) {
            if (dbId.equals(DbTree.ID_DB_ID)) continue;
            DatabaseImpl db = this.envImpl.getDbTree().getDb(dbId);
            try {
                if (db == null || db.isTemporary()) continue;
                db.getTree().rebuildINList();
            }
            finally {
                this.envImpl.getDbTree().releaseDb(db);
            }
        }
    }

    private void recoverIN(DatabaseImpl db, IN inFromLog, long logLsn, boolean requireExactMatch) throws DatabaseException {
        ArrayList<TrackingInfo> trackingList = null;
        try {
            if (inFromLog.isRoot()) {
                this.recoverRootIN(db, inFromLog, logLsn);
            } else {
                trackingList = new ArrayList<TrackingInfo>();
                this.recoverChildIN(db, inFromLog, logLsn, trackingList, requireExactMatch);
            }
        }
        catch (EnvironmentFailureException e) {
            throw e;
        }
        catch (Exception e) {
            String trace = this.printTrackList(trackingList);
            LoggerUtils.traceAndLogException(db.getEnv(), "RecoveryManager", "recoverIN", " lsnFromLog: " + DbLsn.getNoFormatString(logLsn) + " " + trace, e);
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "lsnFromLog=" + DbLsn.getNoFormatString(logLsn), e);
        }
        finally {
            if (LatchSupport.TRACK_LATCHES) {
                LatchSupport.expectBtreeLatchesHeld(0, "LSN = " + DbLsn.toString(logLsn) + " inFromLog = " + inFromLog.getNodeId());
            }
        }
    }

    private String printTrackList(List<TrackingInfo> trackingList) {
        if (trackingList != null) {
            StringBuilder sb = new StringBuilder();
            Iterator<TrackingInfo> iter = trackingList.iterator();
            sb.append("Trace list:");
            sb.append('\n');
            while (iter.hasNext()) {
                sb.append(iter.next());
                sb.append('\n');
            }
            return sb.toString();
        }
        return null;
    }

    private void recoverRootIN(DatabaseImpl db, IN inFromLog, long lsn) throws DatabaseException {
        boolean success = true;
        Tree tree = db.getTree();
        RootUpdater rootUpdater = new RootUpdater(tree, inFromLog, lsn);
        try {
            tree.withRootLatchedExclusive(rootUpdater);
            if (rootUpdater.updateDone()) {
                db.setDirtyUtilization();
            }
        }
        catch (Exception e) {
            success = false;
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "lsnFromLog=" + DbLsn.getNoFormatString(lsn), e);
        }
        finally {
            if (rootUpdater.getInFromLogIsLatched()) {
                inFromLog.releaseLatch();
            }
            RecoveryManager.trace(this.logger, db, TRACE_ROOT_REPLACE, success, inFromLog, lsn, null, true, rootUpdater.getReplaced(), rootUpdater.getInserted(), rootUpdater.getOriginalLsn(), -1L, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverChildIN(DatabaseImpl db, IN inFromLog, long logLsn, List<TrackingInfo> trackingList, boolean requireExactMatch) throws DatabaseException {
        boolean inserted = false;
        boolean replaced = false;
        long originalLsn = -1L;
        boolean finished = false;
        SearchResult result = new SearchResult();
        try {
            long targetNodeId = inFromLog.getNodeId();
            byte[] targetKey = inFromLog.getIdentifierKey();
            int exclusiveLevel = inFromLog.getLevel() + 1;
            inFromLog.releaseLatch();
            result = db.getTree().getParentINForChildIN(targetNodeId, targetKey, -1, exclusiveLevel, requireExactMatch, true, CacheMode.UNCHANGED, trackingList);
            if (result.parent == null) {
                finished = true;
                return;
            }
            if (result.index >= 0 && result.parent.getLsn(result.index) != logLsn && result.exactParentFound && DbLsn.compareTo(originalLsn = result.parent.getLsn(result.index), logLsn) < 0) {
                result.parent.updateNode(result.index, inFromLog, logLsn, 0);
                replaced = true;
            }
            finished = true;
        }
        finally {
            if (result.parent != null) {
                result.parent.releaseLatch();
            }
            RecoveryManager.trace(this.logger, db, TRACE_IN_REPLACE, finished, inFromLog, logLsn, result.parent, result.exactParentFound, replaced, inserted, originalLsn, -1L, result.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long redo(DatabaseImpl db, TreeLocation location, LNLogEntry lnEntry, long logLsn, int logEntrySize, RedoEligible eligible) throws DatabaseException {
        boolean found = false;
        boolean foundNotKD = false;
        boolean replaced = false;
        boolean inserted = false;
        boolean success = false;
        DbConfigManager configManager = db.getEnv().getConfigManager();
        LN lnFromLog = lnEntry.getLN();
        byte[] treeKey = lnEntry.getKey();
        long treeLsn = -1L;
        long abortLsn = lnEntry.getAbortLsn();
        boolean abortKD = lnEntry.getAbortKnownDeleted();
        LogEntryType logType = lnEntry.getLogType();
        boolean blindInsertions = !(!configManager.getBoolean(EnvironmentParams.BIN_DELTA_BLIND_OPS) || !eligible.isCommitted() || !db.isLNImmediatelyObsolete() && (abortLsn != -1L && !abortKD || !logType.equals(LogEntryType.LOG_INS_LN_TRANSACTIONAL) && !logType.equals(LogEntryType.LOG_INS_LN)));
        try {
            location.reset();
            found = db.getTree().getParentBINForChildLN(location, treeKey, true, blindInsertions, CacheMode.DEFAULT);
            if (!found && location.bin == null) {
                success = true;
                long l = -1L;
                return l;
            }
            BIN bin = location.bin;
            int index = location.index;
            boolean bl = foundNotKD = found && !bin.isEntryKnownDeleted(index);
            if (foundNotKD) {
                if (DbLsn.compareTo(logLsn, location.childLsn) > 0) {
                    replaced = true;
                    bin.updateNode(index, null, logLsn, logEntrySize);
                    bin.clearKnownDeleted(index);
                    bin.clearPendingDeleted(index);
                }
                if (DbLsn.compareTo(logLsn, location.childLsn) >= 0 && lnFromLog.isDeleted()) {
                    if (eligible.resurrectTxn != null) {
                        bin.setPendingDeleted(index);
                    } else {
                        bin.setKnownDeleted(index);
                    }
                    bin.queueSlotDeletion();
                }
                treeLsn = location.childLsn;
            } else if (found) {
                if (!lnFromLog.isDeleted()) {
                    assert (bin.isEntryKnownDeleted(index));
                    bin.updateEntry(index, null, logLsn, logEntrySize, treeKey);
                    bin.clearKnownDeleted(index);
                    bin.clearPendingDeleted(index);
                    inserted = true;
                }
            } else if (bin.isBINDelta()) {
                assert (blindInsertions);
                index = bin.insertEntry1(null, treeKey, logLsn, true);
                assert (bin.isBINDelta());
                assert ((index & 0x20000) != 0);
                inserted = true;
                bin.setLastLoggedSize(index &= 0xFFFDFFFF, logEntrySize);
                location.index = index;
                if (lnFromLog.isDeleted()) {
                    assert (eligible.resurrectTxn == null);
                    bin.setKnownDeleted(index);
                }
            } else if (!lnFromLog.isDeleted()) {
                inserted = true;
                assert (!bin.isBINDelta());
                index = bin.insertEntry1(null, treeKey, logLsn, false);
                assert ((index & 0x20000) != 0);
                bin.setLastLoggedSize(index &= 0xFFFDFFFF, logEntrySize);
                location.index = index;
            }
            if (!inserted) {
                lnFromLog.releaseMemoryBudget();
            }
            success = true;
            long l = treeLsn;
            return l;
        }
        finally {
            if (location.bin != null) {
                location.bin.releaseLatch();
            }
            RecoveryManager.trace(this.logger, db, TRACE_LN_REDO, success, lnFromLog, logLsn, location.bin, foundNotKD, replaced, inserted, location.childLsn, -1L, location.index);
        }
    }

    private void recoveryUndo(DatabaseImpl db, TreeLocation location, LNLogEntry lnEntry, long logLsn) {
        RecoveryManager.undo(this.logger, Level.FINE, db, location, lnEntry, logLsn, lnEntry.getAbortLsn(), lnEntry.getAbortKnownDeleted(), false, false);
    }

    public static void abortUndo(Logger logger, Level traceLevel, DatabaseImpl db, TreeLocation location, LNLogEntry lnEntry, long logLsn) {
        RecoveryManager.undo(logger, traceLevel, db, location, lnEntry, logLsn, lnEntry.getAbortLsn(), lnEntry.getAbortKnownDeleted(), false, false);
    }

    public static void rollbackUndo(Logger logger, Level traceLevel, UndoReader undo, TxnChain.RevertInfo revertTo, TreeLocation location, long undoLsn) {
        RecoveryManager.undo(logger, traceLevel, undo.db, location, undo.logEntry, undoLsn, revertTo.revertLsn, revertTo.revertKnownDeleted, true, revertTo.isIntermediateVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void undo(Logger logger, Level traceLevel, DatabaseImpl db, TreeLocation location, LNLogEntry lnEntry, long logLsn, long abortLsn, boolean abortKnownDeleted, boolean isRollback, boolean rollbackToIntermediateVersion) throws DatabaseException {
        boolean found = false;
        boolean replaced = false;
        boolean success = false;
        LN lnFromLog = lnEntry.getLN();
        try {
            location.reset();
            found = db.getTree().getParentBINForChildLN(location, lnEntry.getKey(), false, false, CacheMode.DEFAULT);
            if (found) {
                boolean updateEntry;
                if (location.childLsn == -1L) {
                    int slot = location.index;
                    if (!location.bin.isEntryKnownDeleted(slot) && !location.bin.isEntryPendingDeleted(slot)) {
                        throw EnvironmentFailureException.unexpectedState(location + " has a NULL_LSN but the " + "slot is not empty. KD=" + location.bin.isEntryKnownDeleted(slot) + " PD=" + location.bin.isEntryPendingDeleted(slot));
                    }
                    success = true;
                    return;
                }
                boolean bl = updateEntry = DbLsn.compareTo(logLsn, location.childLsn) == 0;
                if (updateEntry) {
                    if (abortLsn == -1L) {
                        if (isRollback) {
                            location.bin.setKnownDeletedClearAll(location.index);
                        } else {
                            location.bin.setKnownDeleted(location.index);
                        }
                        location.bin.queueSlotDeletion();
                    } else {
                        replaced = true;
                        location.bin.updateNode(location.index, null, abortLsn, RecoveryManager.fetchLNSize(db, 0, abortLsn));
                        if (abortKnownDeleted) {
                            location.bin.setKnownDeleted(location.index);
                        } else {
                            location.bin.clearKnownDeleted(location.index);
                        }
                        boolean pendingDeleted = false;
                        if (rollbackToIntermediateVersion) {
                            LN ln = location.bin.fetchLNKnownActive(location.index, CacheMode.UNCHANGED);
                            if (ln != null && ln.isDeleted()) {
                                pendingDeleted = true;
                            }
                        } else if (db.hasDuplicatePartialComparator() || db.hasBtreePartialComparator()) {
                            location.bin.fetchLN(location.index, CacheMode.UNCHANGED);
                        }
                        if (pendingDeleted) {
                            location.bin.setPendingDeleted(location.index);
                        } else {
                            location.bin.clearPendingDeleted(location.index);
                        }
                    }
                }
            }
            success = true;
        }
        finally {
            if (location.bin != null) {
                location.bin.releaseLatch();
            }
            RecoveryManager.trace(logger, traceLevel, db, TRACE_LN_UNDO, success, lnFromLog, logLsn, location.bin, found, replaced, false, location.childLsn, abortLsn, location.index);
        }
    }

    private static int fetchLNSize(DatabaseImpl db, int size, long lsn) throws DatabaseException {
        if (size != 0) {
            return size;
        }
        EnvironmentImpl envImpl = db.getEnv();
        if (!envImpl.getCleaner().getFetchObsoleteSize(db)) {
            return 0;
        }
        try {
            LogEntryHeader header = envImpl.getLogManager().getWholeLogEntry(lsn).getHeader();
            return header.getEntrySize();
        }
        catch (FileNotFoundException e) {
            return 0;
        }
    }

    private void redoUtilizationInfo(long logLsn, long treeLsn, int treeLNLoggedSize, long commitLsn, boolean isCommitted, long abortLsn, boolean abortKnownDeleted, int logEntrySize, LNLogEntry lnEntry, DatabaseImpl db) {
        if (lnEntry.isImmediatelyObsolete(db)) {
            this.tracker.countObsoleteIfUncounted(logLsn, logLsn, null, logEntrySize, db.getId(), false);
        }
        if (treeLsn != -1L && !db.isLNImmediatelyObsolete()) {
            int cmpLogLsnToTreeLsn = DbLsn.compareTo(logLsn, treeLsn);
            if (cmpLogLsnToTreeLsn != 0) {
                boolean countExact;
                int oldSize;
                long oldLsn;
                long newLsn;
                if (cmpLogLsnToTreeLsn < 0) {
                    newLsn = treeLsn;
                    oldLsn = logLsn;
                    oldSize = logEntrySize;
                    countExact = isCommitted && !this.resurrectedLsns.contains(treeLsn);
                } else {
                    newLsn = logLsn;
                    oldLsn = treeLsn;
                    oldSize = treeLNLoggedSize;
                    countExact = isCommitted;
                }
                this.tracker.countObsoleteIfUncounted(oldLsn, newLsn, null, RecoveryManager.fetchLNSize(db, oldSize, oldLsn), db.getId(), countExact);
            }
            if (cmpLogLsnToTreeLsn <= 0 && abortLsn != -1L && !abortKnownDeleted && commitLsn != -1L) {
                this.tracker.countObsoleteIfUncounted(abortLsn, commitLsn, null, 0, db.getId(), false);
            }
        }
    }

    private void undoUtilizationInfo(LNLogEntry lnEntry, DatabaseImpl db, long logLsn, int logEntrySize) {
        boolean counted = this.tracker.countObsoleteIfUncounted(logLsn, logLsn, null, logEntrySize, db.getId(), true);
        if (!counted && !lnEntry.isImmediatelyObsolete(db)) {
            this.tracker.countObsoleteUnconditional(logLsn, null, logEntrySize, db.getId(), false);
        }
    }

    private void deleteMapLNs() {
        for (DatabaseId id : this.expectDeletedMapLNs) {
            DatabaseImpl dbImpl = this.envImpl.getDbTree().getDb(id);
            if (dbImpl == null) continue;
            dbImpl.finishDeleteProcessing();
        }
    }

    private void removeTempDbs() throws DatabaseException {
        this.startupTracker.start(StartupTracker.Phase.REMOVE_TEMP_DBS);
        this.startupTracker.setProgress(RecoveryProgress.REMOVE_TEMP_DBS);
        StartupTracker.Counter counter = this.startupTracker.getCounter(StartupTracker.Phase.REMOVE_TEMP_DBS);
        DbTree dbMapTree = this.envImpl.getDbTree();
        BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl, false);
        boolean operationOk = false;
        try {
            Iterator<DatabaseId> removeDbs = this.tempDbIds.iterator();
            while (removeDbs.hasNext()) {
                counter.incNumRead();
                DatabaseId dbId = removeDbs.next();
                DatabaseImpl db = dbMapTree.getDb(dbId);
                dbMapTree.releaseDb(db);
                if (db == null) continue;
                assert (db.isTemporary());
                if (!db.isDeleted()) {
                    try {
                        counter.incNumProcessed();
                        this.envImpl.getDbTree().dbRemove(locker, db.getName(), db.getId());
                        continue;
                    }
                    catch (DbTree.NeedRepLockerException e) {
                        throw EnvironmentFailureException.unexpectedException(this.envImpl, (Exception)e);
                    }
                    catch (DatabaseNotFoundException e) {
                        throw EnvironmentFailureException.unexpectedException(e);
                    }
                }
                counter.incNumDeleted();
            }
            operationOk = true;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
        finally {
            locker.operationEnd(operationOk);
            this.startupTracker.stop(StartupTracker.Phase.REMOVE_TEMP_DBS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLogVersion8UpgradeViolations() throws EnvironmentFailureException {
        boolean v8DupNodes = false;
        for (DatabaseId dbId : this.logVersion8UpgradeDbs) {
            DbTree dbTree = this.envImpl.getDbTree();
            DatabaseImpl db = dbTree.getDb(dbId);
            try {
                if (db == null || !db.getSortedDuplicates()) continue;
                v8DupNodes = true;
                break;
            }
            finally {
                dbTree.releaseDb(db);
            }
        }
        boolean v8Deltas = this.logVersion8UpgradeDeltas.get();
        if (v8DupNodes || v8Deltas) {
            String illegalEntries = v8DupNodes ? "JE 4.1 duplicate DB entries" : "JE 4.1 BINDeltas";
            throw EnvironmentFailureException.unexpectedState(illegalEntries + " were found in the recovery interval. " + "Before upgrading to JE 5.0, the following utility " + "must be run using JE 4.1 (4.1.20 or later): " + (this.envImpl.isReplicated() ? "DbRepPreUpgrade_4_1 " : "DbPreUpgrade_4_1 ") + ". See the change log.");
        }
    }

    private static void trace(Logger logger, DatabaseImpl database, String debugType, boolean success, Node node, long logLsn, IN parent, boolean found, boolean replaced, boolean inserted, long replacedLsn, long abortLsn, int index) {
        RecoveryManager.trace(logger, Level.FINE, database, debugType, success, node, logLsn, parent, found, replaced, inserted, replacedLsn, abortLsn, index);
    }

    private static void trace(Logger logger, Level level, DatabaseImpl database, String debugType, boolean success, Node node, long logLsn, IN parent, boolean found, boolean replaced, boolean inserted, long replacedLsn, long abortLsn, int index) {
        Level useLevel = level;
        if (!success) {
            useLevel = Level.SEVERE;
        }
        if (logger.isLoggable(useLevel)) {
            StringBuilder sb = new StringBuilder();
            sb.append(debugType);
            sb.append(" success=").append(success);
            if (node instanceof IN) {
                sb.append(" node=");
                sb.append(((IN)node).getNodeId());
            }
            sb.append(" lsn=");
            sb.append(DbLsn.getNoFormatString(logLsn));
            if (parent != null) {
                sb.append(" parent=").append(parent.getNodeId());
            }
            sb.append(" found=");
            sb.append(found);
            sb.append(" replaced=");
            sb.append(replaced);
            sb.append(" inserted=");
            sb.append(inserted);
            if (replacedLsn != -1L) {
                sb.append(" replacedLsn=");
                sb.append(DbLsn.getNoFormatString(replacedLsn));
            }
            if (abortLsn != -1L) {
                sb.append(" abortLsn=");
                sb.append(DbLsn.getNoFormatString(abortLsn));
            }
            sb.append(" index=").append(index);
            if (useLevel.equals(Level.SEVERE)) {
                LoggerUtils.traceAndLog(logger, database.getEnv(), useLevel, sb.toString());
            } else {
                LoggerUtils.logMsg(logger, database.getEnv(), useLevel, sb.toString());
            }
        }
    }

    private void traceAndThrowException(long badLsn, String method, Exception originalException) throws DatabaseException {
        String badLsnString = DbLsn.getNoFormatString(badLsn);
        LoggerUtils.traceAndLogException(this.envImpl, "RecoveryManager", method, "last LSN = " + badLsnString, originalException);
        throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "last LSN=" + badLsnString, originalException);
    }

    public static void traceRootDeletion(Logger logger, DatabaseImpl database) {
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append(TRACE_ROOT_DELETE);
            sb.append(" Dbid=").append(database.getId());
            LoggerUtils.logMsg(logger, database.getEnv(), Level.FINE, sb.toString());
        }
    }

    private static class RootUpdater
    implements WithRootLatched {
        private final Tree tree;
        private final IN inFromLog;
        private long lsn = -1L;
        private boolean inserted = false;
        private boolean replaced = false;
        private long originalLsn = -1L;
        private boolean inFromLogIsLatched = true;

        RootUpdater(Tree tree, IN inFromLog, long lsn) {
            this.tree = tree;
            this.inFromLog = inFromLog;
            this.lsn = lsn;
        }

        boolean getInFromLogIsLatched() {
            return this.inFromLogIsLatched;
        }

        @Override
        public IN doWork(ChildReference root) throws DatabaseException {
            ChildReference newRoot = this.tree.makeRootChildReference(this.inFromLog, new byte[0], this.lsn);
            this.inFromLog.releaseLatch();
            this.inFromLogIsLatched = false;
            if (root == null) {
                this.tree.setRoot(newRoot, false);
                this.inserted = true;
            } else {
                this.originalLsn = root.getLsn();
                if (DbLsn.compareTo(this.originalLsn, this.lsn) < 0) {
                    this.tree.setRoot(newRoot, false);
                    this.replaced = true;
                }
            }
            return null;
        }

        boolean updateDone() {
            return this.inserted || this.replaced;
        }

        boolean getInserted() {
            return this.inserted;
        }

        boolean getReplaced() {
            return this.replaced;
        }

        long getOriginalLsn() {
            return this.originalLsn;
        }
    }

    private static class RedoEligible {
        final boolean isEligible;
        final Txn resurrectTxn;
        final long commitLsn;
        static RedoEligible NOT = new RedoEligible(false);
        static RedoEligible ELIGIBLE_NON_TXNAL = new RedoEligible(true);

        RedoEligible(Txn resurrectTxn) {
            this.isEligible = true;
            this.resurrectTxn = resurrectTxn;
            this.commitLsn = -1L;
        }

        RedoEligible(long commitLsn) {
            this.isEligible = true;
            this.resurrectTxn = null;
            this.commitLsn = commitLsn;
        }

        RedoEligible(boolean eligible) {
            this.isEligible = eligible;
            this.resurrectTxn = null;
            this.commitLsn = -1L;
        }

        boolean isNonTransactional() {
            return this.isEligible && this.commitLsn == -1L && this.resurrectTxn == null;
        }

        boolean isCommitted() {
            return this.commitLsn != -1L || this.isNonTransactional();
        }
    }
}

