/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.je.rep.impl.RepParams;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class HostPortPair {
    public static final String SEPARATOR = ":";

    public static InetSocketAddress getSocket(String hostPortPair) {
        if ("".equals(hostPortPair)) {
            throw new IllegalArgumentException("Host and port pair was missing");
        }
        int portStartIndex = hostPortPair.indexOf(SEPARATOR);
        String hostName = hostPortPair;
        int port = -1;
        if (portStartIndex < 0) {
            port = Integer.parseInt(RepParams.DEFAULT_PORT.getDefault());
        } else {
            hostName = hostPortPair.substring(0, portStartIndex);
            port = Integer.parseInt(hostPortPair.substring(portStartIndex + 1));
        }
        return new InetSocketAddress(hostName, port);
    }

    public static Set<InetSocketAddress> getSockets(String hostPortPairs) {
        HashSet<InetSocketAddress> helpers = new HashSet<InetSocketAddress>();
        StringTokenizer tokenizer = new StringTokenizer(hostPortPairs, ",");
        while (tokenizer.hasMoreTokens()) {
            String hostPortPair = tokenizer.nextToken();
            helpers.add(HostPortPair.getSocket(hostPortPair));
        }
        return helpers;
    }

    public static String getString(String host, int port) {
        return host + SEPARATOR + port;
    }

    public static String getHostname(String hostPortPair) {
        int portStartIndex = hostPortPair.indexOf(SEPARATOR);
        return portStartIndex < 0 ? hostPortPair : hostPortPair.substring(0, portStartIndex);
    }

    public static int getPort(String hostPortPair) {
        int portStartIndex = hostPortPair.indexOf(SEPARATOR);
        return Integer.parseInt(portStartIndex < 0 ? RepParams.DEFAULT_PORT.getDefault() : hostPortPair.substring(portStartIndex + 1));
    }
}

