/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INArrayRep;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.utilint.SizeofMarker;

public abstract class INTargetRep
extends INArrayRep<INTargetRep, Type, Node> {
    public static final None NONE = new None();

    public static class None
    extends INTargetRep {
        private None() {
        }

        public None(SizeofMarker marker) {
        }

        @Override
        public Type getType() {
            return Type.NONE;
        }

        @Override
        public Node get(int idx) {
            return null;
        }

        @Override
        public INTargetRep set(int idx, Node node, IN parent) {
            Sparse targets = new Sparse(parent.getMaxEntries());
            this.noteRepChange(targets, parent);
            return (INTargetRep)((INArrayRep)targets).set(idx, node, parent);
        }

        @Override
        public INTargetRep copy(int from, int to, int n, IN parent) {
            return this;
        }

        @Override
        public INTargetRep compact(IN parent) {
            return this;
        }

        @Override
        public long calculateMemorySize() {
            return 0L;
        }

        @Override
        public void updateCacheStats(boolean increment, Evictor evictor) {
            if (increment) {
                evictor.getNINNoTarget().incrementAndGet();
            } else {
                evictor.getNINNoTarget().decrementAndGet();
            }
        }
    }

    public static class Sparse
    extends INTargetRep {
        public static final int MAX_ENTRIES = 4;
        public static final int MAX_INDEX = Short.MAX_VALUE;
        final short[] idxs = new short[4];
        final Node[] targets = new Node[4];

        public Sparse(int capacity) {
            this.idxs[3] = -1;
            this.idxs[2] = -1;
            this.idxs[1] = -1;
            this.idxs[0] = -1;
        }

        public Sparse(SizeofMarker marker) {
        }

        @Override
        public Type getType() {
            return Type.SPARSE;
        }

        @Override
        public Node get(int j) {
            assert (j >= 0 && j <= Short.MAX_VALUE);
            if (this.idxs[0] == j) {
                return this.targets[0];
            }
            if (this.idxs[1] == j) {
                return this.targets[1];
            }
            if (this.idxs[2] == j) {
                return this.targets[2];
            }
            if (this.idxs[3] == j) {
                return this.targets[3];
            }
            return null;
        }

        @Override
        public INTargetRep set(int j, Node node, IN parent) {
            assert (j >= 0 && j <= Short.MAX_VALUE);
            int slot = -1;
            for (int i = 0; i < this.targets.length; ++i) {
                if (this.idxs[i] == j) {
                    this.targets[i] = node;
                    return this;
                }
                if (slot >= 0 || this.targets[i] != null) continue;
                slot = i;
            }
            if (node == null) {
                return this;
            }
            if (slot >= 0) {
                this.targets[slot] = node;
                this.idxs[slot] = (short)j;
                return this;
            }
            Default fe = new Default(parent.getMaxEntries());
            this.noteRepChange(fe, parent);
            for (int i = 0; i < this.targets.length; ++i) {
                if (this.targets[i] == null) continue;
                fe.set((int)this.idxs[i], this.targets[i], parent);
            }
            return fe.set(j, node, parent);
        }

        @Override
        public INTargetRep copy(int from, int to, int n, IN parent) {
            INTargetRep target;
            block4: {
                target = this;
                if (to == from || n == 0) break block4;
                if (to < from) {
                    for (int i = 0; i < n; ++i) {
                        target = (INTargetRep)((INArrayRep)target).set(to++, this.get(from++), parent);
                    }
                } else {
                    from += n;
                    to += n;
                    for (int i = 0; i < n; ++i) {
                        target = (INTargetRep)((INArrayRep)target).set(--to, this.get(--from), parent);
                    }
                }
            }
            return target;
        }

        @Override
        public INTargetRep compact(IN parent) {
            int count = 0;
            for (Node target : this.targets) {
                if (target == null) continue;
                ++count;
            }
            if (count == 0) {
                None newRep = NONE;
                this.noteRepChange(newRep, parent);
                return newRep;
            }
            return this;
        }

        @Override
        public long calculateMemorySize() {
            return MemoryBudget.SPARSE_TARGET_ENTRY_OVERHEAD;
        }

        @Override
        public void updateCacheStats(boolean increment, Evictor evictor) {
            if (increment) {
                evictor.getNINSparseTarget().incrementAndGet();
            } else {
                evictor.getNINSparseTarget().decrementAndGet();
            }
        }
    }

    public static class Default
    extends INTargetRep {
        private final Node[] targets;

        public Default(int capacity) {
            this.targets = new Node[capacity];
        }

        public Default(SizeofMarker marker) {
            this.targets = null;
        }

        @Override
        public Type getType() {
            return Type.DEFAULT;
        }

        @Override
        public Node get(int idx) {
            return this.targets[idx];
        }

        @Override
        public INTargetRep set(int idx, Node node, IN parent) {
            this.targets[idx] = node;
            return this;
        }

        @Override
        public INTargetRep copy(int from, int to, int n, IN parent) {
            System.arraycopy(this.targets, from, this.targets, to, n);
            return this;
        }

        @Override
        public INTargetRep compact(IN parent) {
            int count = 0;
            for (Node target : this.targets) {
                if (target == null) continue;
                ++count;
            }
            if (count > 4 || this.targets.length > Short.MAX_VALUE) {
                return this;
            }
            INTargetRep newRep = null;
            if (count == 0) {
                newRep = NONE;
            } else {
                newRep = new Sparse(this.targets.length);
                for (int i = 0; i < this.targets.length; ++i) {
                    if (this.targets[i] == null) continue;
                    newRep.set(i, this.targets[i], parent);
                }
            }
            this.noteRepChange(newRep, parent);
            return newRep;
        }

        @Override
        public long calculateMemorySize() {
            return MemoryBudget.DEFAULT_TARGET_ENTRY_OVERHEAD + MemoryBudget.objectArraySize(this.targets.length);
        }

        @Override
        public void updateCacheStats(boolean increment, Evictor evictor) {
        }
    }

    public static enum Type {
        DEFAULT,
        SPARSE,
        NONE;

    }
}

