/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.RepConfigProxy;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DbEnvPool {
    private static DbEnvPool pool = new DbEnvPool();
    private final Map<String, EnvironmentImpl> envs = new HashMap<String, EnvironmentImpl>();
    private final Set<EnvironmentImpl> sharedCacheEnvs = new HashSet<EnvironmentImpl>();
    private TestHook<EnvironmentImpl> beforeFinishInitHook;

    private DbEnvPool() {
    }

    public static DbEnvPool getInstance() {
        return pool;
    }

    public void setBeforeFinishInitHook(TestHook<EnvironmentImpl> hook) {
        this.beforeFinishInitHook = hook;
    }

    public synchronized int getNSharedCacheEnvironments() {
        return this.sharedCacheEnvs.size();
    }

    private EnvironmentImpl getAnySharedCacheEnv() {
        Iterator<EnvironmentImpl> iter = this.sharedCacheEnvs.iterator();
        return iter.hasNext() ? iter.next() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvironmentImpl getEnvironment(File envHome, EnvironmentConfig config, boolean checkImmutableParams, boolean openIfNeeded, RepConfigProxy repConfigProxy) throws EnvironmentNotFoundException, EnvironmentLockedException {
        DbEnvPool dbEnvPool;
        String environmentKey = null;
        EnvironmentImpl envImpl = null;
        DbEnvPool dbEnvPool2 = this;
        synchronized (dbEnvPool2) {
            environmentKey = this.getEnvironmentMapKey(envHome);
            envImpl = this.envs.get(environmentKey);
            if (envImpl != null) {
                if (!envImpl.isReplicated() && repConfigProxy != null) {
                    throw new UnsupportedOperationException("This environment was previously opened as a standalone environment. It cannot be re-opened for replication.");
                }
                if (envImpl.isReplicated() && repConfigProxy == null && !config.getReadOnly()) {
                    throw new UnsupportedOperationException("This environment was previously opened for replication. It cannot be re-opened in read/write mode for standalone operation.");
                }
                if (envImpl.isArbiter()) {
                    throw new UnsupportedOperationException("An Arbiter is currently using this directory. " + envHome.getAbsolutePath());
                }
                envImpl.checkIfInvalid();
                if (checkImmutableParams) {
                    envImpl.checkImmutablePropsForEquality(DbInternal.getProps(config));
                }
                envImpl.incOpenCount();
            } else {
                if (!openIfNeeded) {
                    return null;
                }
                EnvironmentImpl sharedCacheEnv = config.getSharedCache() ? this.getAnySharedCacheEnv() : null;
                EnvironmentImpl environmentImpl = envImpl = repConfigProxy == null ? new EnvironmentImpl(envHome, config, sharedCacheEnv) : this.loadRepImpl(envHome, config, sharedCacheEnv, repConfigProxy);
                assert (config.getSharedCache() == envImpl.getSharedCache());
                envImpl.incOpenCount();
                this.envs.put(environmentKey, envImpl);
                this.addToSharedCacheEnvs(envImpl);
            }
        }
        TestHookExecute.doHookIfSet(this.beforeFinishInitHook, envImpl);
        boolean success = false;
        try {
            if (envImpl.finishInit(config)) {
                dbEnvPool = this;
                synchronized (dbEnvPool) {
                    this.finishAdditionOfSharedCacheEnv(envImpl);
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                dbEnvPool = this;
                synchronized (dbEnvPool) {
                    this.envs.remove(environmentKey);
                    this.sharedCacheEnvs.remove(envImpl);
                }
            }
        }
        return envImpl;
    }

    private EnvironmentImpl loadRepImpl(File envHome, EnvironmentConfig config, EnvironmentImpl sharedCacheEnv, RepConfigProxy repConfigProxy) throws DatabaseException {
        String repClassName = "com.sleepycat.je.rep.impl.RepImpl";
        String envImplName = "com.sleepycat.je.dbi.EnvironmentImpl";
        String repProxy = "com.sleepycat.je.dbi.RepConfigProxy";
        try {
            Class<?> repClass = Class.forName("com.sleepycat.je.rep.impl.RepImpl");
            return (EnvironmentImpl)repClass.getConstructor(envHome.getClass(), config.getClass(), Class.forName("com.sleepycat.je.dbi.EnvironmentImpl"), Class.forName("com.sleepycat.je.dbi.RepConfigProxy")).newInstance(envHome, config, sharedCacheEnv, repConfigProxy);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (Exception e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    private void addToSharedCacheEnvs(EnvironmentImpl envImpl) throws DatabaseException {
        if (envImpl.getSharedCache()) {
            if (this.sharedCacheEnvs.contains(envImpl)) {
                throw EnvironmentFailureException.unexpectedState();
            }
            this.sharedCacheEnvs.add(envImpl);
        }
    }

    private void finishAdditionOfSharedCacheEnv(EnvironmentImpl envImpl) throws DatabaseException {
        if (envImpl.getSharedCache()) {
            if (!this.sharedCacheEnvs.contains(envImpl)) {
                throw EnvironmentFailureException.unexpectedState();
            }
            assert (envImpl.getEvictor().checkEnv(envImpl));
            this.resetSharedCache(-1L, envImpl);
        }
    }

    synchronized void setMutableConfig(EnvironmentImpl envImpl, EnvironmentMutableConfig mutableConfig) throws DatabaseException {
        envImpl.doSetMutableConfig(mutableConfig);
        if (envImpl.getSharedCache()) {
            this.resetSharedCache(envImpl.getMemoryBudget().getMaxMemory(), envImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeEnvironment(EnvironmentImpl envImpl, boolean doCheckpoint, boolean isAbnormalClose) {
        EnvironmentImpl environmentImpl = envImpl;
        synchronized (environmentImpl) {
            if (envImpl.decOpenCount()) {
                try {
                    envImpl.doClose(doCheckpoint, isAbnormalClose);
                }
                finally {
                    this.removeEnvironment(envImpl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeEnvironmentAfterInvalid(EnvironmentImpl envImpl) throws DatabaseException {
        try {
            envImpl.doCloseAfterInvalid();
        }
        finally {
            this.removeEnvironment(envImpl);
        }
    }

    private void removeEnvironment(EnvironmentImpl envImpl) throws DatabaseException {
        boolean found;
        String environmentKey = this.getEnvironmentMapKey(envImpl.getEnvironmentHome());
        boolean bl = found = this.envs.remove(environmentKey) != null;
        if (this.sharedCacheEnvs.remove(envImpl)) {
            assert (found && envImpl.getSharedCache());
            assert (!envImpl.getEvictor().checkEnv(envImpl));
            if (this.sharedCacheEnvs.isEmpty()) {
                envImpl.getEvictor().shutdown();
            } else {
                envImpl.getMemoryBudget().subtractCacheUsage();
                this.resetSharedCache(-1L, null);
            }
        } else assert (!found || !envImpl.getSharedCache());
        if (this.envs.isEmpty()) {
            LatchSupport.clear();
        }
    }

    public synchronized void clear() {
        this.envs.clear();
    }

    public synchronized Collection<EnvironmentImpl> getEnvImpls() {
        return this.envs.values();
    }

    String getEnvironmentMapKey(File file) throws DatabaseException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    private void resetSharedCache(long newMaxMemory, EnvironmentImpl skipEnv) throws DatabaseException {
        for (EnvironmentImpl envImpl : this.sharedCacheEnvs) {
            if (envImpl == skipEnv || !envImpl.isValid()) continue;
            envImpl.getMemoryBudget().reset(newMaxMemory, false, envImpl.getConfigManager());
        }
    }
}

