/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.log.VersionedWriteLoggable;
import com.sleepycat.je.log.entry.BaseEntry;
import com.sleepycat.je.log.entry.ReplicableLogEntry;
import java.nio.ByteBuffer;

abstract class BaseReplicableEntry<T extends VersionedWriteLoggable>
extends BaseEntry<T>
implements ReplicableLogEntry {
    BaseReplicableEntry(Class<T> logClass) {
        super(logClass);
    }

    BaseReplicableEntry() {
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer) {
        this.writeEntry(destBuffer, 11);
    }

    @Override
    public int getSize(int logVersion) {
        return BaseReplicableEntry.getSize(this, logVersion);
    }

    public static int getSize(ReplicableLogEntry entry, int logVersion) {
        BaseReplicableEntry.checkCurrentVersion(entry, logVersion);
        return entry.getSize();
    }

    public static void checkCurrentVersion(ReplicableLogEntry entry, int logVersion) {
        int lastFormatChange = entry.getLastFormatChange();
        if (logVersion < lastFormatChange) {
            throw new IllegalArgumentException("The requested log version, " + logVersion + ", is older than the last format change, " + lastFormatChange + ", for class " + entry.getClass().getName());
        }
    }
}

