/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.nio;

import com.sshtools.common.events.EventListener;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.util.ByteBufferPool;
import com.sshtools.synergy.nio.ListeningInterface;
import com.sshtools.synergy.nio.ProtocolContextFactory;
import com.sshtools.synergy.nio.SshEngine;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SshEngineContext {
    String product = "SSHD";
    int maximumConnections = -1;
    String tooManyConnectionsText = "Too many connections";
    SshEngine daemon;
    int permanentAcceptThreads = 1;
    int permanentConnectThreads = 1;
    int permanentTransferThreads = 2;
    int maximumChannelsPerThread = 1000;
    int idleServicePeriod = 1;
    int inactivePeriodsPerIdleEvent = 1;
    boolean useDirectByteBuffers = true;
    int bufferPoolArraySize = 69632;
    Map<String, ListeningInterface> interfacesToBind = new ConcurrentHashMap<String, ListeningInterface>(8, 0.9f, 1);
    int ipv6WorkaroundPort = 60022;
    String ipv6WorkaroundBindAddress = "127.0.0.1";
    SelectorProvider selectorProvider = SelectorProvider.provider();
    ByteBufferPool bufferPool = null;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    SshEngineContext(SshEngine daemon) {
        this.daemon = daemon;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getProduct() {
        return this.product;
    }

    public void setMaximumConnections(int maximumConnections) {
        this.maximumConnections = maximumConnections;
    }

    public int getMaximumConnections() {
        return this.maximumConnections;
    }

    public String getTooManyConnectionsText() {
        return this.tooManyConnectionsText;
    }

    public void setTooManyConnectionsText(String tooManyConnectionsText) {
        this.tooManyConnectionsText = tooManyConnectionsText;
    }

    public synchronized ByteBufferPool getBufferPool() {
        if (this.bufferPool == null) {
            this.bufferPool = new ByteBufferPool(this.bufferPoolArraySize, this.useDirectByteBuffers);
        }
        return this.bufferPool;
    }

    public void setSelectorProvider(SelectorProvider selectorProvider) {
        this.selectorProvider = selectorProvider;
    }

    public SelectorProvider getSelectorProvider() {
        return this.selectorProvider;
    }

    public SshEngine getEngine() {
        return this.daemon;
    }

    public boolean isUsingDirectBuffers() {
        return this.useDirectByteBuffers;
    }

    public void setUsingDirectBuffers(boolean useDirectByteBuffers) {
        this.useDirectByteBuffers = useDirectByteBuffers;
    }

    public void setBufferPoolArraySize(int bufferPoolArraySize) {
        if (bufferPoolArraySize < 35000) {
            throw new IllegalArgumentException("The buffer pool must have an array size of at least 35000 bytes (the maximum packet size supported)");
        }
        this.bufferPoolArraySize = bufferPoolArraySize;
    }

    public ListeningInterface addListeningInterface(String addressToBind, int portToBind, ProtocolContextFactory<?> contextFactory, boolean reuseAddress) throws IOException {
        return this.addListeningInterface(InetAddress.getByName(addressToBind), portToBind, contextFactory, reuseAddress);
    }

    public ListeningInterface addListeningInterface(InetAddress addressToBind, int portToBind, ProtocolContextFactory<?> contextFactory, boolean reuseAddress) throws IOException {
        InetSocketAddress ISA = new InetSocketAddress(addressToBind, portToBind);
        ListeningInterface li = new ListeningInterface(ISA, contextFactory);
        li.setSocketOptionReuseAddress(reuseAddress);
        this.interfacesToBind.put(ISA.toString(), li);
        if (this.daemon.isStarted() && !this.daemon.isStarting() && !this.daemon.startListeningInterface(li)) {
            throw new IOException("Failed to start interface " + li.getAddressToBind());
        }
        return li;
    }

    public void removeListeningInterface(InetAddress addressBound, int portBound) {
        InetSocketAddress ISA = new InetSocketAddress(addressBound, portBound);
        ListeningInterface li = this.interfacesToBind.remove(ISA.toString());
        if (li != null) {
            this.daemon.removeAcceptor(li);
        }
    }

    public void removeListeningInterface(String addressBound, int portBound) throws UnknownHostException {
        this.removeListeningInterface(InetAddress.getByName(addressBound), portBound);
    }

    public void removeListeningInterface(String anInterface) throws IOException {
        this.interfacesToBind.remove(anInterface);
    }

    public ListeningInterface[] getListeningInterfaces() {
        return this.interfacesToBind.values().toArray(new ListeningInterface[this.interfacesToBind.size()]);
    }

    public int getPermanentAcceptThreads() {
        return this.permanentAcceptThreads;
    }

    public void setPermanentAcceptThreads(int permanentAcceptThreads) {
        if (permanentAcceptThreads < 1) {
            throw new IllegalArgumentException("There must be at least one permanent ACCEPT thread");
        }
        this.permanentAcceptThreads = permanentAcceptThreads;
    }

    public int getPermanentConnectThreads() {
        return this.permanentConnectThreads;
    }

    public void setPermanentConnectThreads(int permanentConnectThreads) {
        if (permanentConnectThreads < 1) {
            throw new IllegalArgumentException("There must be at least one permanent CONNECT thread");
        }
        this.permanentConnectThreads = permanentConnectThreads;
    }

    public int getPermanentTransferThreads() {
        return this.permanentTransferThreads;
    }

    public void setPermanentTransferThreads(int permanentTransferThreads) {
        if (permanentTransferThreads < 1) {
            throw new IllegalArgumentException("There must be at least one permanent TRANSFER thread");
        }
        this.permanentTransferThreads = permanentTransferThreads;
    }

    public int getMaximumChannelsPerThread() {
        return this.maximumChannelsPerThread;
    }

    public void setMaximumChannelsPerThread(int maximumChannelsPerThread) {
        if (maximumChannelsPerThread < 1) {
            throw new IllegalArgumentException("You must have at least 1 selector per thread");
        }
        this.maximumChannelsPerThread = maximumChannelsPerThread;
    }

    public int getIdleServiceRunPeriod() {
        return this.idleServicePeriod;
    }

    public void setIdleServiceRunPeriod(int idleServicePeriod) {
        this.idleServicePeriod = idleServicePeriod;
    }

    public int getInactiveServiceRunsPerIdleEvent() {
        return this.inactivePeriodsPerIdleEvent;
    }

    public void setInactiveServiceRunsPerIdleEvent(int inactivePeriodsPerIdleEvent) {
        this.inactivePeriodsPerIdleEvent = inactivePeriodsPerIdleEvent;
    }

    public static void addEventListener(EventListener listener) {
        EventServiceImplementation.getInstance().addListener(listener);
    }

    public static void removeEventListener(EventListener listener) {
        EventServiceImplementation.getInstance().removeListener(listener);
    }

    public int getIpv6WorkaroundPort() {
        return this.ipv6WorkaroundPort;
    }

    public void setIpv6WorkaroundPort(int ipv6WorkaroundPort) {
        this.ipv6WorkaroundPort = ipv6WorkaroundPort;
    }

    public String getIpv6WorkaroundBindAddress() {
        return this.ipv6WorkaroundBindAddress;
    }

    public void setIpv6WorkaroundBindAddress(String ipv6WorkaroundBindAddress) {
        this.ipv6WorkaroundBindAddress = ipv6WorkaroundBindAddress;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public <K> K getAttribute(String name, K defaultValue) {
        if (!this.attributes.containsKey(name)) {
            this.attributes.put(name, defaultValue);
        }
        return (K)this.attributes.get(name);
    }
}

