/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.common.nio.IdleStateListener;
import com.sshtools.common.nio.WriteOperationRequest;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.ExecutorOperationQueues;
import com.sshtools.common.ssh.ExecutorOperationSupport;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.SshCipher;
import com.sshtools.common.ssh.components.SshHmac;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.ChaCha20Poly1305;
import com.sshtools.common.ssh.compression.SshCompression;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.UnsignedInteger64;
import com.sshtools.common.util.Utils;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.DisconnectRequestFuture;
import com.sshtools.synergy.nio.ProtocolEngine;
import com.sshtools.synergy.nio.SocketConnection;
import com.sshtools.synergy.nio.SocketWriteCallback;
import com.sshtools.synergy.ssh.Connection;
import com.sshtools.synergy.ssh.ConnectionTaskWrapper;
import com.sshtools.synergy.ssh.Service;
import com.sshtools.synergy.ssh.SshContext;
import com.sshtools.synergy.ssh.SshTransport;
import com.sshtools.synergy.ssh.TransportProtocolHelper;
import com.sshtools.synergy.ssh.TransportProtocolListener;
import com.sshtools.synergy.ssh.components.SshKeyExchange;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.Vector;

public abstract class TransportProtocol<T extends SshContext>
extends ExecutorOperationSupport<SshContext>
implements ProtocolEngine,
IdleStateListener,
SshTransport<T> {
    public static String CHARSET_ENCODING = "UTF-8";
    SecureRandom rnd = new SecureRandom();
    byte[] incomingSwap;
    protected String localIdentification = "SSH-2.0-";
    protected StringBuffer remoteIdentification = new StringBuffer();
    protected boolean receivedRemoteIdentification = false;
    protected boolean sentLocalIdentification = false;
    boolean postedIdentification = false;
    protected byte[] localkex;
    protected byte[] remotekex;
    protected byte[] sessionIdentifier;
    protected UUID uuid;
    LinkedList<SshMessage> outgoingQueue = new LinkedList();
    LinkedList<SshMessage> kexQueue = new LinkedList();
    protected Service activeService;
    List<TransportProtocolListener> transportListeners = new ArrayList<TransportProtocolListener>();
    List<IdleStateListener> idleListeners = new ArrayList<IdleStateListener>();
    static final int SSH_MSG_DISCONNECT = 1;
    static final int SSH_MSG_IGNORE = 2;
    static final int SSH_MSG_UNIMPLEMENTED = 3;
    static final int SSH_MSG_DEBUG = 4;
    protected static final int SSH_MSG_SERVICE_REQUEST = 5;
    public static final int SSH_MSG_SERVICE_ACCEPT = 6;
    static final int SSH_MSG_KEX_INIT = 20;
    static final int SSH_MSG_NEWKEYS = 21;
    boolean expectPacket = true;
    int expectedBytes = 0;
    byte[] payloadIncoming;
    byte[] packet;
    int offsetIncoming = 0;
    int numOutgoingBytesSinceKEX;
    int numOutgoingPacketsSinceKEX;
    int numIncomingBytesSinceKEX;
    int numIncomingPacketsSinceKEX;
    long lastActivity = System.currentTimeMillis();
    long lastIdleEvent = System.currentTimeMillis();
    boolean closed = false;
    protected boolean completedFirstKeyExchange = false;
    protected Date disconnectStarted = null;
    public static final int NEGOTIATING_PROTOCOL = 1;
    public static final int PERFORMING_KEYEXCHANGE = 2;
    public static final int CONNECTED = 3;
    public static final int DISCONNECTED = 4;
    int currentState = 1;
    SshKeyExchange<T> keyExchange;
    SshCipher encryption;
    SshCipher decryption;
    SshHmac outgoingMac;
    SshHmac incomingMac;
    SshCompression outgoingCompression;
    SshCompression incomingCompression;
    protected SshPublicKey hostKey;
    protected String cipherCS;
    protected String cipherSC;
    protected String macCS;
    protected String macSC;
    protected String compressionCS;
    protected String compressionSC;
    protected String keyExchangeAlgorithm;
    protected String publicKey;
    String remoteKeyExchanges;
    String remotePublicKeys;
    String remoteCiphersCS;
    String remoteCiphersSC;
    String remoteCSMacs;
    String remoteSCMacs;
    String remoteCSCompressions;
    String remoteSCCompressions;
    long outgoingSequence = 0L;
    long incomingSequence = 0L;
    long outgoingBytes = 0L;
    long incomingBytes = 0L;
    Object kexlockIn = new Object();
    Object kexlockOut = new Object();
    boolean queuedKexInit = false;
    boolean sentKexInit = false;
    protected Connection<T> con;
    public static final int HOST_NOT_ALLOWED = 1;
    public static final int PROTOCOL_ERROR = 2;
    public static final int KEY_EXCHANGE_FAILED = 3;
    public static final int RESERVED = 4;
    public static final int MAC_ERROR = 5;
    public static final int COMPRESSION_ERROR = 6;
    public static final int SERVICE_NOT_AVAILABLE = 7;
    public static final int PROTOCOL_VERSION_NOT_SUPPORTED = 8;
    public static final int HOST_KEY_NOT_VERIFIABLE = 9;
    public static final int CONNECTION_LOST = 10;
    public static final int BY_APPLICATION = 11;
    public static final int TOO_MANY_CONNECTIONS = 12;
    public static final int AUTH_CANCELLED_BY_USER = 13;
    public static final int NO_MORE_AUTH_METHODS_AVAILABLE = 14;
    public static final int ILLEGAL_USER_NAME = 15;
    private static final Integer ACTIVE_SERVICE_IN = ExecutorOperationQueues.generateUniqueQueue((String)"TransportProtocol.activeService.in");
    IgnoreMessage ignoreMessage;
    long lastKeepAlive = 0L;
    protected T sshContext;
    protected SocketConnection socketConnection;
    public static Object lock = new Object();
    Date started = new Date();
    ConnectRequestFuture connectFuture;
    DisconnectRequestFuture disconnectFuture = new DisconnectRequestFuture();
    int incomingCipherLength = 8;
    int incomingMacLength = 0;
    int msglen = 0;
    int padlen = 0;
    int remaining = 0;
    byte[] initial;

    protected void transferState(TransportProtocol<? extends SshContext> transport) {
        transport.localIdentification = this.localIdentification;
        transport.remoteIdentification = this.remoteIdentification;
        transport.receivedRemoteIdentification = true;
        transport.sentLocalIdentification = true;
        transport.sessionIdentifier = this.sessionIdentifier;
        transport.uuid = this.uuid;
        transport.currentState = this.currentState;
        transport.lastActivity = this.lastActivity;
        transport.outgoingQueue.addAll(this.outgoingQueue);
        transport.kexQueue.addAll(this.kexQueue);
        transport.socketConnection = this.socketConnection;
        transport.postedIdentification = this.postedIdentification;
        transport.onSocketConnect(this.socketConnection);
        this.receivedRemoteIdentification = false;
        this.currentState = 4;
    }

    @Override
    public ConnectRequestFuture getConnectFuture() {
        return this.connectFuture;
    }

    @Override
    public DisconnectRequestFuture getDisconnectFuture() {
        return this.disconnectFuture;
    }

    public TransportProtocol(T sshContext, ConnectRequestFuture connectFuture) {
        super("transport-protocol");
        this.sshContext = sshContext;
        this.ignoreMessage = new IgnoreMessage();
        this.connectFuture = connectFuture;
        this.uuid = UUID.randomUUID();
        this.incomingSwap = new byte[((SshContext)sshContext).getMaximumPacketLength()];
    }

    @Override
    public SocketConnection getSocketConnection() {
        return this.socketConnection;
    }

    public void addEventListener(TransportProtocolListener listener) {
        if (listener != null) {
            this.transportListeners.add(listener);
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.socketConnection.getRemoteAddress();
    }

    public int getRemotePort() {
        return this.socketConnection.getPort();
    }

    @Override
    public T getContext() {
        return this.sshContext;
    }

    public Connection<T> getConnection() {
        return this.con;
    }

    protected abstract boolean canConnect(SocketConnection var1);

    protected abstract void onConnected();

    protected abstract void onDisconnected();

    @Override
    public void onSocketConnect(SocketConnection connection) {
        this.socketConnection = connection;
        if (Log.isInfoEnabled()) {
            Log.info((String)"Connnection created {} on interface {}", (Object[])new Object[]{this.socketConnection.getRemoteAddress().toString(), this.socketConnection.getLocalAddress().toString()});
        }
        if (!this.canConnect(connection)) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Access denied by TransportProtocol.canConnect", (Object[])new Object[0]);
            }
            EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777215, (Throwable)new IOException("Access Denied")).addAttribute("CONNECTION", this.con).addAttribute("OP_STARTED", (Object)this.started).addAttribute("OP_FINISHED", (Object)new Date()));
            connection.closeConnection(false);
            return;
        }
        connection.getIdleStates().register((IdleStateListener)this);
        this.onConnected();
        if (!this.sentLocalIdentification) {
            EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777215, true).addAttribute("CONNECTION", this.con).addAttribute("OP_STARTED", (Object)this.started).addAttribute("OP_FINISHED", (Object)new Date()));
            this.localIdentification = this.localIdentification + ((SshContext)this.sshContext).getSoftwareVersionComments() + "\r\n";
            if (!((SshContext)this.sshContext).isHttpRedirect()) {
                this.sendLocalIdentification(false, null);
            }
        }
    }

    private synchronized void sendLocalIdentification() {
        this.sendLocalIdentification(false, null);
    }

    private synchronized void sendLocalIdentification(final boolean doHttpRedirect, final String hostname) {
        if (!this.postedIdentification) {
            this.postedIdentification = true;
            this.postMessage(new SshMessage(){

                public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                    try {
                        if (doHttpRedirect) {
                            String httpRedirect = "HTTP/1.1 302 Moved Location\r\nLocation: " + ((SshContext)TransportProtocol.this.sshContext).getHttpRedirectUrl().replace("${hostname}", hostname) + "/\r\nConnection: close\r\nContent-Type: text/plain\r\nContent-Length: " + TransportProtocol.this.localIdentification.getBytes("UTF-8").length + "\r\n\r\n";
                            buf.put(httpRedirect.getBytes("UTF-8"));
                        }
                        buf.put(TransportProtocol.this.localIdentification.getBytes("UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalStateException("UTF-8 is not supported!!");
                    }
                    return true;
                }

                public void messageSent(Long sequenceNo) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)("Sent local identification string " + TransportProtocol.this.localIdentification.trim()), (Object[])new Object[0]);
                    }
                    TransportProtocol.this.sentLocalIdentification = true;
                    if (TransportProtocol.this.receivedRemoteIdentification && TransportProtocol.this.canSendKeyExchangeInit()) {
                        TransportProtocol.this.sendKeyExchangeInit();
                    }
                }
            });
        }
    }

    protected boolean canSendKeyExchangeInit() {
        return true;
    }

    @Override
    public boolean onSocketRead(ByteBuffer incomingData) {
        if (Log.isTraceEnabled()) {
            Log.trace((String)"Processing APPLICATION READ data", (Object[])new Object[0]);
        }
        boolean wantsWrite = false;
        try {
            switch (this.currentState) {
                case 1: {
                    this.negotiateProtocol(incomingData);
                    break;
                }
                case 2: 
                case 3: {
                    wantsWrite = this.processBinaryPackets(incomingData);
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            if (Log.isInfoEnabled()) {
                Log.info((String)"Read error from {} {}", (Object[])new Object[]{this.getRemoteAddress().toString(), ex.getMessage()});
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Connection closed on socket read", (Throwable)ex, (Object[])new Object[0]);
            }
            this.socketConnection.closeConnection();
        }
        return wantsWrite;
    }

    @Override
    public boolean isConnected() {
        return this.currentState == 1 || this.currentState == 2 || this.currentState == 3;
    }

    void negotiateProtocol(ByteBuffer applicationData) throws IOException {
        if (this.receivedRemoteIdentification) {
            this.processBinaryPackets(applicationData);
            return;
        }
        char c = '\u0000';
        while (applicationData.remaining() > 0) {
            c = (char)applicationData.get();
            if (c == '\n') {
                if (this.remoteIdentification.toString().startsWith("SSH-")) {
                    if (this.startBinaryProtocol() && this.sentLocalIdentification) {
                        if (this.canSendKeyExchangeInit()) {
                            this.sendKeyExchangeInit();
                        }
                        this.processBinaryPackets(applicationData);
                    }
                    return;
                }
                try {
                    this.processNegotiationString(this.remoteIdentification.toString().trim());
                }
                catch (Throwable t) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Bad value in negotiation string!", (Throwable)t, (Object[])new Object[0]);
                    }
                    this.socketConnection.closeConnection();
                    return;
                }
                this.remoteIdentification.setLength(0);
                continue;
            }
            this.remoteIdentification.append(c);
        }
    }

    protected void processNegotiationString(String value) throws IOException {
    }

    protected boolean startBinaryProtocol() {
        if (Log.isInfoEnabled()) {
            Log.info((String)"Connnection {} identifies itself as {}", (Object[])new Object[]{this.getRemoteAddress().toString(), this.remoteIdentification.toString().trim()});
        }
        this.sendLocalIdentification(false, null);
        String tmp = this.remoteIdentification.toString();
        if (!tmp.startsWith("SSH-2.0-") && !tmp.startsWith("SSH-1.99-")) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Remote client reported an invalid protocol version!", (Object[])new Object[0]);
            }
            this.socketConnection.closeConnection();
            return false;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Remote client version OK", (Object[])new Object[0]);
        }
        this.receivedRemoteIdentification = true;
        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777206, true).addAttribute("CONNECTION", this.con).addAttribute("OP_STARTED", (Object)this.started).addAttribute("OP_FINISHED", (Object)new Date()));
        this.onRemoteIdentificationReceived(tmp);
        return true;
    }

    protected void onRemoteIdentificationReceived(String remoteIdentification) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processBinaryPackets(ByteBuffer applicationData) {
        boolean requiresWriteOperation = false;
        boolean hasMessage = false;
        try {
            while (this.isConnected() && (this.expectPacket && applicationData.remaining() > this.incomingCipherLength || this.expectedBytes > 0 && applicationData.hasRemaining()) && !requiresWriteOperation) {
                Object object = this.kexlockIn;
                synchronized (object) {
                    hasMessage = this.decryption != null && this.decryption instanceof ChaCha20Poly1305 ? this.decodeChaCha20Poly1305Format(applicationData) : (this.incomingMac != null && this.incomingMac.isETM() ? this.decodeETMPacketFormat(applicationData) : this.decodeOriginalPacketFormat(applicationData));
                }
                if (!hasMessage) continue;
                try {
                    this.processMessage(this.payloadIncoming, this.incomingSequence);
                }
                catch (WriteOperationRequest x) {
                    requiresWriteOperation = true;
                }
                finally {
                    if (++this.incomingSequence >= 0x100000000L) {
                        this.incomingSequence = 0L;
                    }
                    this.incomingBytes += (long)this.payloadIncoming.length;
                    this.numIncomingBytesSinceKEX += this.payloadIncoming.length;
                    ++this.numIncomingPacketsSinceKEX;
                    if ((long)this.numIncomingBytesSinceKEX >= this.getContext().getKeyExchangeTransferLimit() || (long)this.numIncomingPacketsSinceKEX >= this.getContext().getKeyExchangePacketLimit()) {
                        this.sendKeyExchangeInit();
                    }
                    this.expectPacket = true;
                    this.expectedBytes = 0;
                    this.offsetIncoming = 0;
                    this.payloadIncoming = null;
                    hasMessage = false;
                }
            }
            if (Log.isTraceEnabled()) {
                Log.trace((String)("Transport protocol " + (this.expectPacket ? "is expecting another packet" : "still has " + this.expectedBytes + " bytes of data to complete packet with " + this.offsetIncoming + " bytes already received requiresWrite=" + requiresWriteOperation)), (Object[])new Object[0]);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            if (Log.isInfoEnabled()) {
                Log.info((String)"Transport error {} {}", (Object[])new Object[]{this.getRemoteAddress().toString(), ex.getMessage()});
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Connection Error", (Throwable)ex, (Object[])new Object[0]);
            }
            if (this.isConnected()) {
                this.disconnect(2, "The application encountered an error");
            }
            requiresWriteOperation = true;
        }
        return requiresWriteOperation;
    }

    private boolean decodeChaCha20Poly1305Format(ByteBuffer applicationData) throws IOException {
        ChaCha20Poly1305 cipher = (ChaCha20Poly1305)this.decryption;
        if (this.expectPacket) {
            applicationData.get(this.incomingSwap, 0, 4);
            this.msglen = (int)cipher.readPacketLength(this.incomingSwap, new UnsignedInteger64(this.incomingSequence));
            if (this.msglen <= 0) {
                throw new IOException("Client sent invalid message length of " + this.msglen + "!");
            }
            if (this.msglen + 4 < 0 || this.msglen + 4 > ((SshContext)this.sshContext).getMaximumPacketLength()) {
                this.disconnect(2, "Incoming packet length " + this.msglen + (this.msglen + 4 < 0 ? " is too small" : " exceeds maximum supported length of " + ((SshContext)this.sshContext).getMaximumPacketLength()));
                throw new IOException("Disconnected");
            }
            this.remaining = this.msglen;
            this.expectedBytes = this.remaining + this.incomingMacLength;
            this.expectPacket = false;
            this.offsetIncoming += 4;
        }
        if (!this.expectPacket && applicationData.remaining() > 0) {
            int count = this.expectedBytes > applicationData.remaining() ? applicationData.remaining() : this.expectedBytes;
            applicationData.get(this.incomingSwap, this.offsetIncoming, count);
            this.expectedBytes -= count;
            this.offsetIncoming += count;
            if (this.expectedBytes == 0) {
                this.decryption.transform(this.incomingSwap, 4, this.incomingSwap, 4, this.remaining + this.incomingMacLength);
                this.padlen = this.incomingSwap[4] & 0xFF;
                this.payloadIncoming = new byte[this.msglen - this.padlen - 1];
                System.arraycopy(this.incomingSwap, 5, this.payloadIncoming, 0, this.msglen - this.padlen - 1);
                if (this.incomingCompression != null) {
                    this.payloadIncoming = this.incomingCompression.uncompress(this.payloadIncoming, 0, this.payloadIncoming.length);
                }
                return true;
            }
        }
        return false;
    }

    private boolean decodeETMPacketFormat(ByteBuffer applicationData) throws IOException {
        if (this.expectPacket) {
            applicationData.get(this.incomingSwap, this.offsetIncoming, 4);
            this.msglen = (int)ByteArrayReader.readInt((byte[])this.incomingSwap, (int)0);
            if (this.msglen <= 0) {
                throw new IOException("Client sent invalid message length of " + this.msglen + "!");
            }
            if (this.msglen + 4 < 0 || this.msglen + 4 > ((SshContext)this.sshContext).getMaximumPacketLength()) {
                this.disconnect(2, "Incoming packet length " + this.msglen + (this.msglen + 4 < 0 ? " is too small" : " exceeds maximum supported length of " + ((SshContext)this.sshContext).getMaximumPacketLength()));
                throw new IOException("Disconnected");
            }
            this.remaining = this.msglen;
            this.expectedBytes = this.remaining + this.incomingMacLength;
            this.expectPacket = false;
            this.offsetIncoming += 4;
        }
        if (!this.expectPacket && applicationData.remaining() > 0) {
            int count = this.expectedBytes > applicationData.remaining() ? applicationData.remaining() : this.expectedBytes;
            applicationData.get(this.incomingSwap, this.offsetIncoming, count);
            this.expectedBytes -= count;
            this.offsetIncoming += count;
            if (this.expectedBytes == 0) {
                int packetlen = this.msglen;
                if (this.incomingMac != null && !this.incomingMac.verify(this.incomingSequence, this.incomingSwap, 0, packetlen + 4, this.incomingSwap, packetlen + 4)) {
                    throw new IOException("Corrupt Mac on input");
                }
                if (this.decryption != null) {
                    this.decryption.transform(this.incomingSwap, 4, this.incomingSwap, 4, this.remaining);
                }
                this.padlen = this.incomingSwap[4] & 0xFF;
                this.payloadIncoming = new byte[this.msglen - this.padlen - 1];
                System.arraycopy(this.incomingSwap, 5, this.payloadIncoming, 0, this.msglen - this.padlen - 1);
                if (this.incomingCompression != null) {
                    this.payloadIncoming = this.incomingCompression.uncompress(this.payloadIncoming, 0, this.payloadIncoming.length);
                }
                return true;
            }
        }
        return false;
    }

    private boolean decodeOriginalPacketFormat(ByteBuffer applicationData) throws IOException {
        if (this.expectPacket) {
            applicationData.get(this.incomingSwap, this.offsetIncoming, this.incomingCipherLength);
            if (this.decryption != null && !this.decryption.isMAC()) {
                this.decryption.transform(this.incomingSwap, this.offsetIncoming, this.incomingSwap, this.offsetIncoming, this.incomingCipherLength);
            }
            this.msglen = (int)ByteArrayReader.readInt((byte[])this.incomingSwap, (int)this.offsetIncoming);
            if (this.msglen <= 0) {
                throw new IOException("Client sent invalid message length of " + this.msglen + "!");
            }
            if (this.msglen + 4 < 0 || this.msglen + 4 > ((SshContext)this.sshContext).getMaximumPacketLength()) {
                this.disconnect(2, "Incoming packet length " + this.msglen + (this.msglen + 4 < 0 ? " is too small" : " exceeds maximum supported length of " + ((SshContext)this.sshContext).getMaximumPacketLength()));
                throw new IOException("Disconnected");
            }
            this.padlen = this.incomingSwap[4] & 0xFF;
            this.remaining = this.msglen - (this.incomingCipherLength - 4);
            this.expectedBytes = this.remaining + this.incomingMacLength;
            this.expectPacket = false;
            this.offsetIncoming += this.incomingCipherLength;
        }
        if (!this.expectPacket && applicationData.remaining() > 0) {
            int count = this.expectedBytes > applicationData.remaining() ? applicationData.remaining() : this.expectedBytes;
            applicationData.get(this.incomingSwap, this.offsetIncoming, count);
            this.expectedBytes -= count;
            this.offsetIncoming += count;
            if (this.expectedBytes == 0) {
                int packetlen = this.msglen + 4;
                if (this.decryption != null) {
                    if (!this.decryption.isMAC()) {
                        this.decryption.transform(this.incomingSwap, this.incomingCipherLength, this.incomingSwap, this.incomingCipherLength, this.remaining);
                    } else {
                        this.decryption.transform(this.incomingSwap, 0, this.incomingSwap, 0, this.msglen + 4 + this.decryption.getMacLength());
                        this.padlen = this.incomingSwap[4] & 0xFF;
                    }
                }
                if (this.incomingMac != null && !this.incomingMac.verify(this.incomingSequence, this.incomingSwap, 0, packetlen, this.incomingSwap, packetlen)) {
                    throw new IOException("Corrupt Mac on input");
                }
                this.payloadIncoming = new byte[this.msglen - this.padlen - 1];
                System.arraycopy(this.incomingSwap, 5, this.payloadIncoming, 0, this.msglen - this.padlen - 1);
                if (this.incomingCompression != null) {
                    this.payloadIncoming = this.incomingCompression.uncompress(this.payloadIncoming, 0, this.payloadIncoming.length);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wantsToWrite() {
        Object object = this.kexlockOut;
        synchronized (object) {
            if (this.currentState == 2 && this.completedFirstKeyExchange) {
                return this.kexQueue.size() > 0;
            }
            return this.outgoingQueue.size() > 0 || this.kexQueue.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSizes() {
        Object object = this.kexlockOut;
        synchronized (object) {
            return this.outgoingQueue.size() + this.kexQueue.size();
        }
    }

    public boolean idle() {
        if (this.currentState == 4) {
            return true;
        }
        long idleTimeSeconds = (System.currentTimeMillis() - this.lastActivity) / 1000L;
        if (!this.hasCompletedKeyExchange() && this.con.getContext().getIdleAuthenticationTimeoutSeconds() > 0 && (long)this.con.getContext().getIdleAuthenticationTimeoutSeconds() < idleTimeSeconds) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Idle time of {} seconds exceeded threshold of {} seconds", (Object[])new Object[]{idleTimeSeconds, this.con.getContext().getIdleAuthenticationTimeoutSeconds()});
            }
            this.disconnect(11, String.format("Remote exceeded idle timeout of %d seconds for unauthenticated connections", this.con.getContext().getIdleAuthenticationTimeoutSeconds()));
            return true;
        }
        if (this.currentState == 3 && this.con.getContext().getIdleConnectionTimeoutSeconds() > 0 && (long)this.con.getContext().getIdleConnectionTimeoutSeconds() < idleTimeSeconds) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Idle time of {} seconds exceeded threshold of {} seconds", (Object[])new Object[]{idleTimeSeconds, this.con.getContext().getIdleConnectionTimeoutSeconds()});
            }
            this.disconnect(11, String.format("Remote exceeded idle timeout of %d seconds for authenticated connections", this.con.getContext().getIdleConnectionTimeoutSeconds()));
            return true;
        }
        if ((this.currentState == 3 || this.currentState == 2) && this.getContext().isSendIgnorePacketOnIdle() && this.getContext().getKeepAliveInterval() > 0 && idleTimeSeconds > (long)this.getContext().getKeepAliveInterval()) {
            long keepAliveSeconds = this.getContext().getKeepAliveInterval() + 1;
            if (this.lastKeepAlive > 0L) {
                keepAliveSeconds = (System.currentTimeMillis() - this.lastKeepAlive) / 1000L;
            }
            if (keepAliveSeconds > (long)this.getContext().getKeepAliveInterval()) {
                this.postMessage(this.ignoreMessage);
                this.lastKeepAlive = System.currentTimeMillis();
            }
        }
        if (this.activeService != null && this.activeService.getIdleTimeoutSeconds() > 0) {
            idleTimeSeconds = (System.currentTimeMillis() - this.lastIdleEvent) / 1000L;
            if (this.activeService != null && idleTimeSeconds >= (long)this.activeService.getIdleTimeoutSeconds()) {
                this.lastIdleEvent = System.currentTimeMillis();
                return this.activeService.idle();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SocketWriteCallback onSocketWrite(ByteBuffer outgoingMessage) {
        if (Log.isTraceEnabled()) {
            Log.debug((String)"Processing APPLICATION WRITE event", (Object[])new Object[0]);
        }
        try {
            final Long sequenceNo = this.outgoingSequence;
            Object object = this.kexlockOut;
            synchronized (object) {
                SshMessage msg;
                block22: {
                    block21: {
                        if (this.kexQueue.size() <= 0 && this.outgoingQueue.size() <= 0) break block21;
                        if (this.currentState == 2 && this.completedFirstKeyExchange) {
                            if (this.kexQueue.size() <= 0) {
                                return null;
                            }
                            msg = this.kexQueue.getFirst();
                            if (msg.writeMessageIntoBuffer(outgoingMessage)) {
                                this.kexQueue.removeFirst();
                            }
                        } else {
                            LinkedList<SshMessage> linkedList = this.outgoingQueue;
                            synchronized (linkedList) {
                                msg = this.outgoingQueue.getFirst();
                                if (msg.writeMessageIntoBuffer(outgoingMessage)) {
                                    this.outgoingQueue.removeFirst();
                                }
                            }
                        }
                        if (this.currentState != 1) {
                            outgoingMessage.flip();
                            if (this.encryption != null && this.encryption instanceof ChaCha20Poly1305) {
                                this.encodeChaCha20Poly1305FormatPacket(outgoingMessage);
                            } else if (this.outgoingMac != null && this.outgoingMac.isETM()) {
                                this.encodeETMFormatPacket(outgoingMessage);
                            } else {
                                this.encodeOriginalFormatPacket(outgoingMessage);
                            }
                            this.numOutgoingBytesSinceKEX += outgoingMessage.position();
                            ++this.numOutgoingPacketsSinceKEX;
                            ++this.outgoingSequence;
                            if (this.outgoingSequence >= 0x100000000L) {
                                this.outgoingSequence = 0L;
                            }
                        }
                        break block22;
                    }
                    msg = null;
                }
                if ((long)this.numOutgoingBytesSinceKEX >= this.getContext().getKeyExchangeTransferLimit() || (long)this.numOutgoingPacketsSinceKEX >= this.getContext().getKeyExchangePacketLimit()) {
                    this.sendKeyExchangeInit();
                }
                return new SocketWriteCallback(){

                    @Override
                    public void completedWrite() {
                        try {
                            if (msg != null) {
                                msg.messageSent(sequenceNo);
                            }
                        }
                        catch (SshException e) {
                            Log.error((String)"Failed during messageSent", (Throwable)e, (Object[])new Object[0]);
                            TransportProtocol.this.disconnect(2, "Internal error");
                        }
                    }
                };
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            if (Log.isInfoEnabled()) {
                Log.info((String)"Write error from {} {}", (Object[])new Object[]{this.getRemoteAddress().toString(), ex.getMessage()});
            }
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Connection closed on socket write", (Throwable)ex, (Object[])new Object[0]);
            }
            this.socketConnection.closeConnection();
            return null;
        }
    }

    private void encodeChaCha20Poly1305FormatPacket(ByteBuffer outgoingMessage) throws IOException {
        ChaCha20Poly1305 cipher = (ChaCha20Poly1305)this.encryption;
        byte[] payload = new byte[outgoingMessage.remaining()];
        outgoingMessage.get(payload);
        outgoingMessage.clear();
        int padding = 4;
        int cipherlen = 8;
        if (this.outgoingCompression != null) {
            payload = this.outgoingCompression.compress(payload, 0, payload.length);
        }
        padding += (cipherlen - (payload.length + 1 + padding) % cipherlen) % cipherlen;
        outgoingMessage.put(cipher.writePacketLength(payload.length + 1 + padding, new UnsignedInteger64(this.outgoingSequence)));
        outgoingMessage.put((byte)padding);
        outgoingMessage.put(payload, 0, payload.length);
        this.outgoingBytes += (long)(payload.length + padding + 1 + cipher.getMacLength() + 4);
        byte[] pad = new byte[padding];
        this.rnd.nextBytes(pad);
        outgoingMessage.put(pad);
        outgoingMessage.flip();
        byte[] packet = new byte[outgoingMessage.remaining() + this.encryption.getMacLength()];
        outgoingMessage.get(packet, 0, outgoingMessage.remaining());
        cipher.transform(packet, 4, packet, 4, packet.length - 4);
        outgoingMessage.clear();
        outgoingMessage.put(packet);
    }

    private void encodeETMFormatPacket(ByteBuffer outgoingMessage) throws IOException {
        byte[] payload = new byte[outgoingMessage.remaining()];
        outgoingMessage.get(payload);
        outgoingMessage.clear();
        int padding = 4;
        int cipherlen = 8;
        if (this.encryption != null) {
            cipherlen = this.encryption.getBlockSize();
        }
        if (this.outgoingCompression != null) {
            payload = this.outgoingCompression.compress(payload, 0, payload.length);
        }
        padding += (cipherlen - (payload.length + 1 + padding) % cipherlen) % cipherlen;
        outgoingMessage.putInt(payload.length + 1 + padding);
        outgoingMessage.put((byte)padding);
        outgoingMessage.put(payload, 0, payload.length);
        this.outgoingBytes += (long)(payload.length + padding + 1);
        byte[] pad = new byte[padding];
        this.rnd.nextBytes(pad);
        outgoingMessage.put(pad);
        outgoingMessage.flip();
        byte[] packet = this.encryption != null && this.encryption.isMAC() ? new byte[outgoingMessage.remaining() + this.encryption.getMacLength()] : new byte[outgoingMessage.remaining()];
        outgoingMessage.get(packet);
        byte[] mac = null;
        if (this.encryption != null) {
            this.encryption.transform(packet, 4, packet, 4, packet.length - 4);
        }
        if (this.outgoingMac != null) {
            mac = new byte[this.outgoingMac.getMacLength()];
            this.outgoingMac.generate(this.outgoingSequence, packet, 0, packet.length, mac, 0);
        }
        outgoingMessage.clear();
        outgoingMessage.put(packet);
        if (mac != null && mac.length > 0) {
            outgoingMessage.put(mac);
            this.outgoingBytes += (long)mac.length;
        }
    }

    private void encodeOriginalFormatPacket(ByteBuffer outgoingMessage) throws IOException {
        byte[] payload = new byte[outgoingMessage.remaining()];
        outgoingMessage.get(payload);
        outgoingMessage.clear();
        if (Log.isTraceEnabled()) {
            Log.raw((Log.Level)Log.Level.TRACE, (String)Utils.bytesToHex((byte[])payload, (int)0, (int)payload.length, (int)32, (boolean)true, (boolean)true), (boolean)true);
        }
        int padding = 4;
        int cipherlen = 8;
        if (this.encryption != null) {
            cipherlen = this.encryption.getBlockSize();
        }
        if (this.outgoingCompression != null) {
            payload = this.outgoingCompression.compress(payload, 0, payload.length);
        }
        padding = this.encryption != null && this.encryption.isMAC() ? (padding += (cipherlen - (payload.length + 1 + padding) % cipherlen) % cipherlen) : (padding += (cipherlen - (payload.length + 5 + padding) % cipherlen) % cipherlen);
        int msglen = payload.length + 1 + padding;
        outgoingMessage.putInt(msglen);
        outgoingMessage.put((byte)padding);
        outgoingMessage.put(payload, 0, payload.length);
        this.outgoingBytes += (long)(payload.length + padding + 5);
        byte[] pad = new byte[padding];
        this.rnd.nextBytes(pad);
        outgoingMessage.put(pad);
        outgoingMessage.flip();
        byte[] packet = this.encryption != null && this.encryption.isMAC() ? new byte[outgoingMessage.remaining() + this.encryption.getMacLength()] : new byte[outgoingMessage.remaining()];
        outgoingMessage.get(packet, 0, outgoingMessage.remaining());
        byte[] mac = null;
        if (this.outgoingMac != null) {
            mac = new byte[this.outgoingMac.getMacLength()];
            this.outgoingMac.generate(this.outgoingSequence, packet, 0, packet.length, mac, 0);
        }
        if (this.encryption != null) {
            if (this.encryption.isMAC()) {
                this.encryption.transform(packet, 0, packet, 0, msglen + 4);
            } else {
                this.encryption.transform(packet);
            }
        }
        outgoingMessage.clear();
        outgoingMessage.put(packet);
        if (mac != null && mac.length > 0) {
            outgoingMessage.put(mac);
            this.outgoingBytes += (long)mac.length;
        }
    }

    public int getState() {
        return this.currentState;
    }

    public SocketAddress getLocalAddress() {
        return this.socketConnection.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socketConnection.getLocalPort();
    }

    public String getRemoteIdentification() {
        return this.remoteIdentification.toString();
    }

    public String getUUID() {
        return this.uuid.toString();
    }

    @Override
    public void disconnect(int reason, String description) {
        if (description == null) {
            description = "Failure";
        }
        this.disconnectStarted = new Date();
        if (Log.isInfoEnabled()) {
            Log.info((String)"Disconnect {} {}", (Object[])new Object[]{this.getRemoteAddress().toString(), description});
        }
        this.postMessage(new DisconnectMessage(reason, description));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSocketClose() {
        TransportProtocol transportProtocol = this;
        synchronized (transportProtocol) {
            if (!this.closed) {
                Connection<T> connection = this.getConnection();
                this.closed = true;
                if (Log.isInfoEnabled()) {
                    Log.info((String)"Connection closed {}", (Object[])new Object[]{this.getRemoteAddress().toString()});
                }
                if (this.disconnectStarted == null) {
                    this.disconnectStarted = new Date();
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Performing internal disconnect {}", (Object[])new Object[]{this.getUUID()});
                }
                this.setTransportState(4);
                this.disconnectFuture.disconnected();
                if (this.socketConnection != null) {
                    this.socketConnection.getIdleStates().remove((IdleStateListener)this);
                }
                if (this.activeService != null) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Stopping the active service", (Object[])new Object[0]);
                    }
                    this.activeService.stop();
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Logging off user", (Object[])new Object[0]);
                }
                Iterator<TransportProtocolListener> it = this.transportListeners.iterator();
                while (it.hasNext()) {
                    it.next().onDisconnect(this);
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Submitting transport cleanup to executor service", (Object[])new Object[0]);
                }
                if (connection != null) {
                    this.addTask(EVENTS, new ConnectionTaskWrapper(connection, new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = lock;
                            synchronized (object) {
                                TransportProtocol.this.cleanupOperations(new ConnectionAwareTask(TransportProtocol.this.con){

                                    protected void doTask() {
                                        TransportProtocol.this.disconnected();
                                        TransportProtocol.this.onDisconnected();
                                        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16776961, true).addAttribute("CONNECTION", (Object)this.con).addAttribute("OP_STARTED", (Object)TransportProtocol.this.disconnectStarted).addAttribute("OP_FINISHED", (Object)new Date()));
                                    }
                                });
                            }
                        }
                    }));
                }
            }
        }
    }

    public SecureRandom getRND() {
        return this.rnd;
    }

    void setTransportState(int transportState) {
        this.currentState = transportState;
    }

    protected abstract void initializeKeyExchange(SshKeyExchange<T> var1, boolean var2, boolean var3) throws IOException, SshException;

    void performKeyExchange(byte[] msg) throws IOException, WriteOperationRequest {
        ByteArrayReader bar = null;
        if (!this.postedIdentification) {
            this.sendLocalIdentification();
        }
        this.checkAlgorithms();
        try {
            this.currentState = 2;
            this.remotekex = msg;
            bar = new ByteArrayReader(this.remotekex, 0, this.remotekex.length);
            bar.skip(17L);
            this.remoteKeyExchanges = this.checkValidString("key exchange", bar.readString());
            this.remotePublicKeys = this.checkValidString("public key", bar.readString());
            this.remoteCiphersCS = this.checkValidString("client->server cipher", bar.readString());
            this.remoteCiphersSC = this.checkValidString("server->client cipher", bar.readString());
            this.remoteCSMacs = bar.readString();
            this.remoteSCMacs = bar.readString();
            this.remoteCSCompressions = bar.readString();
            this.remoteSCCompressions = bar.readString();
            String lang = bar.readString();
            lang = bar.readString();
            boolean firstPacketFollows = bar.read() != 0;
            this.onKeyExchangeInit();
            this.sendKeyExchangeInit();
            String localKeyExchanges = ((SshContext)this.sshContext).supportedKeyExchanges().list(((SshContext)this.sshContext).getPreferredKeyExchange());
            String localCiphersCS = ((SshContext)this.sshContext).supportedCiphersCS().list(((SshContext)this.sshContext).getPreferredCipherCS());
            String localCiphersSC = ((SshContext)this.sshContext).supportedCiphersSC().list(((SshContext)this.sshContext).getPreferredCipherSC());
            String localPublicKeys = ((SshContext)this.sshContext).getPublicKeys();
            String localMacsCS = ((SshContext)this.sshContext).supportedMacsCS().list(((SshContext)this.sshContext).getPreferredMacCS());
            String localMacsSC = ((SshContext)this.sshContext).supportedMacsSC().list(((SshContext)this.sshContext).getPreferredMacSC());
            String localCompressionCS = ((SshContext)this.sshContext).supportedCompressionsCS().list(((SshContext)this.sshContext).getPreferredCompressionCS());
            String localCompressionSC = ((SshContext)this.sshContext).supportedCompressionsSC().list(((SshContext)this.sshContext).getPreferredCompressionSC());
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Remote Key Exchanges: {}", (Object[])new Object[]{this.remoteKeyExchanges});
                Log.debug((String)"Remote Public Keys: {}", (Object[])new Object[]{this.remotePublicKeys});
                Log.debug((String)"Remote Ciphers CS: {}", (Object[])new Object[]{this.remoteCiphersCS});
                Log.debug((String)"Remote Ciphers SC: {}", (Object[])new Object[]{this.remoteCiphersSC});
                Log.debug((String)"Remote Macs CS: {}", (Object[])new Object[]{this.remoteCSMacs});
                Log.debug((String)"Remote Macs SC: {}", (Object[])new Object[]{this.remoteSCMacs});
                Log.debug((String)"Remote Compression CS: {}", (Object[])new Object[]{this.remoteCSCompressions});
                Log.debug((String)"Remote Compression SC: {}", (Object[])new Object[]{this.remoteSCCompressions});
                Log.debug((String)"Lang: {}", (Object[])new Object[]{lang});
                Log.debug((String)"First Packet Follows: {}", (Object[])new Object[]{firstPacketFollows});
                Log.debug((String)"Local Key Exchanges: {}", (Object[])new Object[]{localKeyExchanges});
                Log.debug((String)"Local Public Keys: {}", (Object[])new Object[]{localPublicKeys});
                Log.debug((String)"Local Ciphers CS: {}", (Object[])new Object[]{localCiphersCS});
                Log.debug((String)"Local Ciphers SC: {}", (Object[])new Object[]{localCiphersSC});
                Log.debug((String)"Local Macs CS: {}", (Object[])new Object[]{localMacsCS});
                Log.debug((String)"Local Macs SC: {}", (Object[])new Object[]{localMacsSC});
                Log.debug((String)"Local Compression CS: {}", (Object[])new Object[]{localCompressionCS});
                Log.debug((String)"Local Compression SC: {}", (Object[])new Object[]{localCompressionSC});
            }
            this.keyExchangeAlgorithm = this.selectNegotiatedComponent(this.remoteKeyExchanges, localKeyExchanges);
            this.keyExchange = (SshKeyExchange)((SshContext)this.sshContext).supportedKeyExchanges().getInstance(this.keyExchangeAlgorithm);
            this.publicKey = this.selectNegotiatedComponent(this.remotePublicKeys, ((SshContext)this.sshContext).getSupportedPublicKeys());
            boolean useFirstPacket = this.remoteKeyExchanges.startsWith(((SshContext)this.sshContext).getPreferredKeyExchange()) && this.remotePublicKeys.startsWith(((SshContext)this.sshContext).getPreferredPublicKey());
            EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777211, true).addAttribute("CONNECTION", this.con).addAttribute("REMOTE_KEY_EXCHANGES", (Object)this.remoteKeyExchanges).addAttribute("LOCAL_KEY_EXCHANGES", (Object)localKeyExchanges).addAttribute("REMOTE_PUBLICKEYS", (Object)this.remotePublicKeys).addAttribute("LOCAL_PUBLICKEYS", (Object)localPublicKeys).addAttribute("REMOTE_CIPHERS_CS", (Object)this.remoteCiphersCS).addAttribute("LOCAL_CIPHERS_CS", (Object)localCiphersCS).addAttribute("REMOTE_CIPHERS_SC", (Object)this.remoteCiphersSC).addAttribute("LOCAL_CIPHERS_SC", (Object)localCiphersSC).addAttribute("REMOTE_CS_MACS", (Object)this.remoteCSMacs).addAttribute("LOCAL_CS_MACS", (Object)localMacsCS).addAttribute("REMOTE_SC_MACS", (Object)this.remoteSCMacs).addAttribute("LOCAL_SC_MACS", (Object)localMacsSC).addAttribute("REMOTE_CS_COMPRESSIONS", (Object)this.remoteCSCompressions).addAttribute("LOCAL_CS_COMPRESSIONS", (Object)localCompressionCS).addAttribute("REMOTE_SC_COMPRESSIONS", (Object)this.remoteSCCompressions).addAttribute("LOCAL_SC_COMPRESSIONS", (Object)localCompressionSC));
            this.initializeKeyExchange(this.keyExchange, firstPacketFollows, useFirstPacket);
            this.cipherCS = this.selectNegotiatedComponent(this.checkValidString("client->server cipher list", this.remoteCiphersCS), localCiphersCS);
            this.cipherSC = this.selectNegotiatedComponent(this.checkValidString("server->client cipher list", this.remoteCiphersSC), localCiphersSC);
            this.macCS = this.selectNegotiatedComponent(this.checkValidString("client->server hmac list", this.remoteCSMacs), localMacsCS);
            this.macSC = this.selectNegotiatedComponent(this.checkValidString("server->client hmac list", this.remoteSCMacs), localMacsSC);
            this.compressionCS = this.selectNegotiatedComponent(this.checkValidString("client->server compression list", this.remoteCSCompressions), localCompressionCS);
            this.compressionSC = this.selectNegotiatedComponent(this.checkValidString("server->client compression list", this.remoteSCCompressions), localCompressionSC);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Negotiated Key Exchange: {}", (Object[])new Object[]{this.keyExchangeAlgorithm});
                Log.debug((String)"Negotiated Public Key: {}", (Object[])new Object[]{this.publicKey});
                Log.debug((String)"Negotiated Cipher CS: {}", (Object[])new Object[]{this.cipherCS});
                Log.debug((String)"Negotiated Cipher SC: {}", (Object[])new Object[]{this.cipherSC});
                Log.debug((String)"Negotiated Mac CS: {}", (Object[])new Object[]{this.macCS});
                Log.debug((String)"Negotiated Mac SC: {}", (Object[])new Object[]{this.macSC});
                Log.debug((String)"Negotiated Compression CS: {}", (Object[])new Object[]{this.compressionCS});
                Log.debug((String)"Negotiated Compression SC: {}", (Object[])new Object[]{this.compressionSC});
            }
            this.keyExchangeInitialized();
        }
        catch (SshException ex) {
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace();
            }
            EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777210, true).addAttribute("CONNECTION", this.con));
            throw new IOException("Unexpected protocol termination: " + ex.getMessage());
        }
        finally {
            if (bar != null) {
                bar.close();
            }
        }
    }

    protected abstract void onKeyExchangeInit() throws SshException;

    private void checkAlgorithms() {
        if (Boolean.getBoolean("maverick.isolate")) {
            String kex = System.getProperty("maverick.isolatedKex", "ecdh-sha2-nistp256");
            String cipher = System.getProperty("maverick.isolatedCipher", "aes128-ctr");
            String mac = System.getProperty("maverick.isolatedMac", "hmac-sha1");
            String compression = System.getProperty("maverick.isolatedComp", "none");
            String pk = System.getProperty("maverick.isolatedPublicKey", "ssh-rsa");
            this.getContext().supportedKeyExchanges().removeAllBut(kex);
            this.getContext().supportedCiphersCS().removeAllBut(cipher);
            this.getContext().supportedCiphersSC().removeAllBut(cipher);
            this.getContext().supportedMacsCS().removeAllBut(mac);
            this.getContext().supportedMacsSC().removeAllBut(mac);
            this.getContext().supportedCompressionsCS().removeAllBut(compression);
            this.getContext().supportedCompressionsSC().removeAllBut(compression);
            this.getContext().supportedPublicKeys().removeAllBut(pk);
        }
    }

    protected void keyExchangeInitialized() {
    }

    protected abstract void disconnected();

    protected abstract void onNewKeysReceived();

    protected abstract boolean processTransportMessage(int var1, byte[] var2) throws IOException, SshException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(final byte[] msg, final long sequenceNo) throws SshException, IOException, WriteOperationRequest {
        this.resetIdleState(this);
        if (msg.length < 1) {
            throw new IOException("Invalid transport protocol message");
        }
        if (Log.isTraceEnabled()) {
            Log.raw((Log.Level)Log.Level.TRACE, (String)Utils.bytesToHex((byte[])msg, (int)32, (boolean)true, (boolean)true), (boolean)true);
        }
        final byte msgId = msg[0];
        if (Log.isTraceEnabled()) {
            Log.debug((String)"Processing transport protocol message id {}", (Object[])new Object[]{(int)msgId});
        }
        switch (msgId) {
            case 1: {
                try (ByteArrayReader bar = new ByteArrayReader(msg);){
                    bar.skip(5L);
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Recieved SSH_MSG_DISCONNECT {}", (Object[])new Object[]{bar.readString()});
                    }
                    this.socketConnection.closeConnection();
                    break;
                }
            }
            case 2: {
                if (!Log.isDebugEnabled()) break;
                Log.debug((String)"Received SSH_MSG_IGNORE", (Object[])new Object[0]);
                break;
            }
            case 4: {
                if (!Log.isDebugEnabled()) break;
                Log.debug((String)"Received SSH_MSG_DEBUG", (Object[])new Object[0]);
                break;
            }
            case 21: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Received SSH_MSG_NEWKEYS", (Object[])new Object[0]);
                }
                SshKeyExchange<T> bar = this.keyExchange;
                synchronized (bar) {
                    this.keyExchange.setReceivedNewKeys(true);
                    this.onNewKeysReceived();
                    break;
                }
            }
            case 20: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Received SSH_MSG_KEX_INIT", (Object[])new Object[0]);
                }
                this.performKeyExchange(msg);
                break;
            }
            case 3: {
                try (ByteArrayReader bar = new ByteArrayReader(msg);){
                    bar.skip(1L);
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Received SSH_MSG_UNIMPLEMENTED for sequence {}", (Object[])new Object[]{bar.readInt()});
                    }
                }
                if (!Boolean.getBoolean("maverick.failOnUnimplemented")) break;
                throw new IllegalStateException("SSH_MSG_UNIMPLEMENTED message returned by remote");
            }
            default: {
                if (this.processTransportMessage(msgId, msg)) {
                    return;
                }
                if (this.currentState == 2 && this.keyExchange.processMessage(msg)) break;
                if (Log.isTraceEnabled()) {
                    Log.trace((String)"Posting mesage id {} to active service for processing", (Object[])new Object[]{(int)msgId});
                }
                this.addTask(ACTIVE_SERVICE_IN, new ConnectionAwareTask(this.con){

                    protected void doTask() {
                        try {
                            if (Log.isTraceEnabled()) {
                                Log.trace((String)"Processing active service message id {}", (Object[])new Object[]{msgId});
                            }
                            if (TransportProtocol.this.activeService != null && TransportProtocol.this.activeService.processMessage(msg)) {
                                return;
                            }
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)"Unimplemented Message id={}", (Object[])new Object[]{msg[0]});
                            }
                            TransportProtocol.this.postMessage(new UnimplementedMessage(sequenceNo));
                        }
                        catch (SshException | IOException e) {
                            TransportProtocol.this.disconnect(2, e.getMessage());
                        }
                    }
                });
            }
        }
    }

    protected abstract void onNewKeysSent();

    @Override
    public void sendNewKeys() {
        this.postMessage(new SshMessage(){

            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                buf.put((byte)21);
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void messageSent(Long sequenceNo) {
                SshKeyExchange sshKeyExchange = TransportProtocol.this.keyExchange;
                synchronized (sshKeyExchange) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Sent SSH_MSG_NEWKEYS", (Object[])new Object[0]);
                    }
                    TransportProtocol.this.keyExchange.setSentNewKeys(true);
                    TransportProtocol.this.onNewKeysSent();
                }
            }
        }, true);
    }

    public T getSshContext() {
        return this.sshContext;
    }

    protected String selectNegotiatedComponent(String clientlist, String serverlist) throws IOException {
        int idx;
        String originalClient = clientlist;
        String originalServer = serverlist;
        Vector<String> r = new Vector<String>();
        while ((idx = serverlist.indexOf(",")) > -1) {
            r.addElement(serverlist.substring(0, idx).trim());
            serverlist = serverlist.substring(idx + 1).trim();
        }
        r.addElement(serverlist);
        while ((idx = clientlist.indexOf(",")) > -1) {
            String name = clientlist.substring(0, idx).trim();
            if (r.contains(name)) {
                return name;
            }
            clientlist = clientlist.substring(idx + 1).trim();
        }
        if (r.contains(clientlist)) {
            return clientlist;
        }
        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777208, true).addAttribute("CONNECTION", this.con).addAttribute("LOCAL_COMPONENT_LIST", (Object)serverlist).addAttribute("REMOTE_COMPONENT_LIST", (Object)clientlist));
        throw new IOException(String.format("Failed to negotiate a transport component from %s and %s", originalClient, originalServer));
    }

    protected void completeKeyExchange(SshKeyExchange<T> keyExchange) {
        this.localkex = null;
        this.remotekex = null;
        this.completedFirstKeyExchange = true;
        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777209, true).addAttribute("CONNECTION", this.con).addAttribute("USING_PUBLICKEY", (Object)this.publicKey).addAttribute("USING_KEY_EXCHANGE", (Object)this.keyExchangeAlgorithm).addAttribute("USING_CS_CIPHER", (Object)this.cipherCS).addAttribute("USING_SC_CIPHERC", (Object)this.cipherSC).addAttribute("USING_CS_MAC", (Object)this.macCS).addAttribute("USING_SC_MAC", (Object)this.macSC).addAttribute("USING_CS_COMPRESSION", (Object)this.compressionCS).addAttribute("USING_SC_COMPRESSION", (Object)this.compressionSC));
        this.setTransportState(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateNewKeysServerOut() {
        Object object = this.kexlockOut;
        synchronized (object) {
            block10: {
                try {
                    if (this.sessionIdentifier == null) {
                        this.sessionIdentifier = this.keyExchange.getExchangeHash();
                    }
                    this.encryption = (SshCipher)((SshContext)this.sshContext).supportedCiphersSC().getInstance(this.cipherSC);
                    this.encryption.init(0, this.makeSshKey('B', this.encryption.getBlockSize()), this.makeSshKey('D', this.encryption.getKeyLength()));
                    if (!this.encryption.isMAC()) {
                        this.outgoingMac = (SshHmac)((SshContext)this.sshContext).supportedMacsSC().getInstance(this.macSC);
                        this.outgoingMac.init(this.makeSshKey('F', this.outgoingMac.getMacSize()));
                    }
                    this.outgoingCompression = null;
                    if (!this.compressionSC.equals("none")) {
                        this.outgoingCompression = (SshCompression)((SshContext)this.sshContext).supportedCompressionsSC().getInstance(this.compressionSC);
                        this.outgoingCompression.init(1, ((SshContext)this.getSshContext()).getCompressionLevel());
                    }
                    if (this.keyExchange.hasReceivedNewKeys()) {
                        this.completeKeyExchange(this.keyExchange);
                    }
                }
                catch (Throwable ex) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Failed to create transport component", (Throwable)ex, (Object[])new Object[0]);
                    }
                    this.connectFuture.done(false);
                    if (this.disconnectStarted == null) break block10;
                    this.disconnect(2, "Failed to create a transport component! " + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateNewKeysServerIn() {
        Object object = this.kexlockIn;
        synchronized (object) {
            block11: {
                try {
                    if (this.sessionIdentifier == null) {
                        this.sessionIdentifier = this.keyExchange.getExchangeHash();
                    }
                    this.decryption = (SshCipher)((SshContext)this.sshContext).supportedCiphersCS().getInstance(this.cipherCS);
                    this.decryption.init(1, this.makeSshKey('A', this.decryption.getBlockSize()), this.makeSshKey('C', this.decryption.getKeyLength()));
                    if (!this.decryption.isMAC()) {
                        this.incomingMac = (SshHmac)((SshContext)this.sshContext).supportedMacsCS().getInstance(this.macCS);
                        this.incomingMac.init(this.makeSshKey('E', this.incomingMac.getMacSize()));
                        this.incomingMacLength = this.incomingMac.getMacLength();
                    } else {
                        this.incomingMacLength = this.decryption.getMacLength();
                    }
                    this.incomingCompression = null;
                    if (!this.compressionCS.equals("none")) {
                        this.incomingCompression = (SshCompression)((SshContext)this.sshContext).supportedCompressionsCS().getInstance(this.compressionCS);
                        this.incomingCompression.init(0, ((SshContext)this.getSshContext()).getCompressionLevel());
                    }
                    this.incomingCipherLength = this.decryption.getBlockSize();
                    if (this.keyExchange.hasSentNewKeys()) {
                        this.completeKeyExchange(this.keyExchange);
                    }
                }
                catch (Throwable ex) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Failed to create transport component", (Throwable)ex, (Object[])new Object[0]);
                    }
                    this.connectFuture.done(false);
                    if (this.disconnectStarted == null) break block11;
                    this.disconnect(2, "Failed to create a transport component! " + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateNewKeysClientOut() {
        Object object = this.kexlockOut;
        synchronized (object) {
            block10: {
                try {
                    if (this.sessionIdentifier == null) {
                        this.sessionIdentifier = this.keyExchange.getExchangeHash();
                    }
                    this.encryption = (SshCipher)((SshContext)this.sshContext).supportedCiphersSC().getInstance(this.cipherCS);
                    this.encryption.init(0, this.makeSshKey('A', this.encryption.getBlockSize()), this.makeSshKey('C', this.encryption.getKeyLength()));
                    if (!this.encryption.isMAC()) {
                        this.outgoingMac = (SshHmac)((SshContext)this.sshContext).supportedMacsSC().getInstance(this.macCS);
                        this.outgoingMac.init(this.makeSshKey('E', this.outgoingMac.getMacSize()));
                    }
                    this.outgoingCompression = null;
                    if (!this.compressionSC.equals("none")) {
                        this.outgoingCompression = (SshCompression)((SshContext)this.sshContext).supportedCompressionsSC().getInstance(this.compressionCS);
                        this.outgoingCompression.init(1, ((SshContext)this.getSshContext()).getCompressionLevel());
                    }
                    if (this.keyExchange.hasReceivedNewKeys()) {
                        this.completeKeyExchange(this.keyExchange);
                    }
                }
                catch (Throwable ex) {
                    if (Log.isErrorEnabled()) {
                        Log.error((String)"Failed to create transport component", (Throwable)ex, (Object[])new Object[0]);
                    }
                    this.connectFuture.done(false);
                    if (this.disconnectStarted == null) break block10;
                    this.disconnect(2, "Failed to create a transport component! " + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateNewKeysClientIn() {
        Object object = this.kexlockIn;
        synchronized (object) {
            block11: {
                try {
                    if (this.sessionIdentifier == null) {
                        this.sessionIdentifier = this.keyExchange.getExchangeHash();
                    }
                    this.decryption = (SshCipher)((SshContext)this.sshContext).supportedCiphersCS().getInstance(this.cipherSC);
                    this.decryption.init(1, this.makeSshKey('B', this.decryption.getBlockSize()), this.makeSshKey('D', this.decryption.getKeyLength()));
                    if (!this.decryption.isMAC()) {
                        this.incomingMac = (SshHmac)((SshContext)this.sshContext).supportedMacsCS().getInstance(this.macSC);
                        this.incomingMac.init(this.makeSshKey('F', this.incomingMac.getMacSize()));
                        this.incomingMacLength = this.incomingMac.getMacLength();
                    } else {
                        this.incomingMacLength = this.decryption.getMacLength();
                    }
                    this.incomingCompression = null;
                    if (!this.compressionCS.equals("none")) {
                        this.incomingCompression = (SshCompression)((SshContext)this.sshContext).supportedCompressionsCS().getInstance(this.compressionSC);
                        this.incomingCompression.init(0, ((SshContext)this.getSshContext()).getCompressionLevel());
                    }
                    this.incomingCipherLength = this.decryption.getBlockSize();
                    if (this.keyExchange.hasSentNewKeys()) {
                        this.completeKeyExchange(this.keyExchange);
                    }
                }
                catch (Throwable ex) {
                    if (Log.isErrorEnabled()) {
                        Log.error((String)"Failed to create transport component", (Throwable)ex, (Object[])new Object[0]);
                    }
                    this.connectFuture.done(false);
                    if (this.disconnectStarted == null) break block11;
                    this.disconnect(2, "Failed to create a transport component! " + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendKeyExchangeInit() {
        try {
            Object object = this.kexlockOut;
            synchronized (object) {
                this.numIncomingBytesSinceKEX = 0;
                this.numIncomingPacketsSinceKEX = 0;
                this.numOutgoingBytesSinceKEX = 0;
                this.numOutgoingPacketsSinceKEX = 0;
                this.setTransportState(2);
                if (this.localkex == null) {
                    try {
                        this.localkex = TransportProtocolHelper.generateKexInit((SshContext)this.getContext());
                        this.kexQueue.clear();
                        if (Log.isDebugEnabled()) {
                            Log.debug((String)"Posting SSH_MSG_KEX_INIT", (Object[])new Object[0]);
                        }
                        this.postMessage(new SshMessage(){

                            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                                buf.put(TransportProtocol.this.localkex);
                                return true;
                            }

                            public void messageSent(Long sequenceNo) {
                                if (Log.isDebugEnabled()) {
                                    Log.debug((String)"Sent SSH_MSG_KEX_INIT", (Object[])new Object[0]);
                                }
                            }
                        }, true);
                    }
                    catch (SshException e) {
                        this.disconnect(11, "Internal error");
                    }
                }
            }
        }
        catch (IOException ex) {
            this.disconnect(2, "Failed to create SSH_MSG_KEX_INIT");
        }
    }

    public String getCipherCS() {
        return this.cipherCS;
    }

    public String getCipherSC() {
        return this.cipherSC;
    }

    public String getMacCS() {
        return this.macCS;
    }

    public String getMacSC() {
        return this.macSC;
    }

    public String getCompressionCS() {
        return this.compressionCS;
    }

    public String getCompressionSC() {
        return this.compressionSC;
    }

    private String checkValidString(String id, String str) throws IOException {
        if (str.trim().equals("")) {
            throw new IOException("Client sent invalid " + id + " value '" + str + "'");
        }
        StringTokenizer t = new StringTokenizer(str, ",");
        if (!t.hasMoreElements()) {
            throw new IOException("Client sent invalid " + id + " value '" + str + "'");
        }
        return str;
    }

    @Override
    public void postMessage(SshMessage msg) {
        if (!msg.equals(this.ignoreMessage) && !(msg instanceof DisconnectMessage)) {
            this.resetIdleState(this);
        }
        this.postMessage(msg, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postMessage(SshMessage msg, boolean kex) {
        if (Log.isTraceEnabled()) {
            Log.debug((String)("Posting message " + msg.getClass().getName() + " to queue"), (Object[])new Object[0]);
        }
        LinkedList<SshMessage> list = kex && this.completedFirstKeyExchange ? this.kexQueue : this.outgoingQueue;
        Object object = this.kexlockOut;
        synchronized (object) {
            list.addLast(msg);
        }
        this.socketConnection.flagWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] makeSshKey(char chr, int sizeRequired) throws SshException, IOException {
        try (ByteArrayWriter keydata = new ByteArrayWriter();){
            byte[] data = new byte[20];
            Digest hash = (Digest)ComponentManager.getDefaultInstance().supportedDigests().getInstance(this.keyExchange.getHashAlgorithm());
            hash.putBigInteger(this.keyExchange.getSecret());
            hash.putBytes(this.keyExchange.getExchangeHash());
            hash.putByte((byte)chr);
            hash.putBytes(this.sessionIdentifier);
            data = hash.doFinal();
            keydata.write(data);
            while (keydata.size() < sizeRequired) {
                hash.reset();
                hash.putBigInteger(this.keyExchange.getSecret());
                hash.putBytes(this.keyExchange.getExchangeHash());
                hash.putBytes(data);
                data = hash.doFinal();
                keydata.write(data);
            }
            byte[] byArray = keydata.toByteArray();
            return byArray;
        }
    }

    public byte[] getSessionKey() {
        return this.sessionIdentifier;
    }

    public static byte[] getBytes(String str, String charset) {
        try {
            return str.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("System does not support " + charset);
        }
    }

    public void kill() {
        this.socketConnection.closeConnection();
    }

    public String getHostKeyAlgorithm() {
        return this.publicKey;
    }

    public SshPublicKey getHostKey() {
        return this.hostKey;
    }

    public String getKeyExchangeAlgorithm() {
        return this.keyExchangeAlgorithm;
    }

    public String[] getRemoteKeyExchanges() {
        return this.remoteKeyExchanges.split(",");
    }

    public String[] getRemotePublicKeys() {
        return this.remotePublicKeys.split(",");
    }

    public String[] getRemoteCiphersCS() {
        return this.remoteCiphersCS.split(",");
    }

    public String[] getRemoteCiphersSC() {
        return this.remoteCiphersSC.split(",");
    }

    public String[] getRemoteMacsCS() {
        return this.remoteCSMacs.split(",");
    }

    public String[] getRemoteMacsSC() {
        return this.remoteSCMacs.split(",");
    }

    public String[] getRemoteCompressionsCS() {
        return this.remoteCSCompressions.split(",");
    }

    public String[] getRemoteCompressionsSC() {
        return this.remoteSCCompressions.split(",");
    }

    public boolean hasCompletedKeyExchange() {
        return this.completedFirstKeyExchange;
    }

    @Override
    public ExecutorOperationSupport<?> getExecutor() {
        return this;
    }

    public void registerIdleStateListener(IdleStateListener listener) {
        this.idleListeners.add(listener);
    }

    public void removeIdleStateListener(IdleStateListener listener) {
        this.idleListeners.remove(listener);
    }

    public void resetIdleState(IdleStateListener listener) {
        if (Log.isTraceEnabled()) {
            Log.trace((String)"Resetting idle state", (Object[])new Object[0]);
        }
        this.lastActivity = System.currentTimeMillis();
        if (this.getContext().getIdleConnectionTimeoutSeconds() > 0 && this.socketConnection != null) {
            this.socketConnection.getIdleStates().reset((IdleStateListener)this);
        }
    }

    public boolean isSelectorThread() {
        return Thread.currentThread().equals(this.getSocketConnection().getSelectorThread());
    }

    public String getKeyExchangeInUse() {
        return this.keyExchangeAlgorithm;
    }

    public String getHostKeyInUse() {
        return this.publicKey;
    }

    public String getLocalIdentification() {
        return this.localIdentification.trim();
    }

    class DisconnectMessage
    implements SshMessage {
        int reason;
        String description;

        DisconnectMessage(int reason, String description) {
            this.reason = reason;
            this.description = description;
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            buf.put((byte)1);
            buf.putInt(this.reason);
            buf.putInt(this.description.length());
            buf.put(this.description.getBytes());
            buf.putInt(0);
            return true;
        }

        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Sent SSH_MSG_DISCONNECT reason=" + this.reason + " " + this.description), (Object[])new Object[0]);
            }
            TransportProtocol.this.socketConnection.closeConnection();
        }
    }

    class UnimplementedMessage
    implements SshMessage {
        long sequenceNo;

        UnimplementedMessage(long sequenceNo) {
            this.sequenceNo = sequenceNo;
        }

        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            buf.put((byte)3);
            buf.putInt((int)this.sequenceNo);
            return true;
        }

        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sent SSH_MSG_UNIMPLEMENTED", (Object[])new Object[0]);
            }
        }
    }

    class IgnoreMessage
    implements SshMessage {
        SecureRandom rnd = new SecureRandom();

        IgnoreMessage() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean writeMessageIntoBuffer(ByteBuffer buf) {
            byte[] tmp = new byte[Math.min(TransportProtocol.this.getContext().getKeepAliveDataMaxLength(), 1024)];
            try {
                buf.put((byte)2);
                int len = (int)(Math.random() * (double)(tmp.length + 1));
                this.rnd.nextBytes(tmp);
                buf.putInt(len);
                buf.put(tmp, 0, len);
                boolean bl = true;
                return bl;
            }
            finally {
                tmp = null;
            }
        }

        public void messageSent(Long sequenceNo) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Sent SSH_MSG_IGNORE {}", (Object[])new Object[]{TransportProtocol.this.activeService.getIdleLog()});
            }
        }
    }
}

