/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vsession.commands.ssh;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.vsession.commands.ssh.CommandUtil;
import com.sshtools.vsession.commands.ssh.SshClientArguments;
import com.sshtools.vsession.commands.ssh.SshClientOptions;
import com.sshtools.vsession.commands.ssh.SshOptionsResolver;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.jline.reader.Candidate;

public class AbstractSshOptionsEvaluator {
    static Set<SshOptionsResolver> resolvers = new HashSet<SshOptionsResolver>();

    public static void addResolver(SshOptionsResolver resolver) {
        resolvers.add(resolver);
    }

    protected static void complete(String destination, List<Candidate> candidates) {
        for (SshOptionsResolver resolver : resolvers) {
            for (String candidate : resolver.matchDestinations(destination)) {
                candidates.add(new Candidate(candidate));
            }
        }
    }

    protected static void parseDestination(CommandLine commandLine, SshClientArguments arguments) throws IOException {
        List commandLineArguments = commandLine.getArgList();
        String destination = (String)commandLineArguments.get(1);
        String loginName = null;
        if (destination.contains("@")) {
            String[] destinationParts = destination.split("@");
            loginName = destinationParts[0];
            destination = destinationParts[1];
        }
        arguments.setDestination(destination);
        arguments.setLoginName(loginName);
        for (SshOptionsResolver resolver : resolvers) {
            if (resolver.resolveOptions(destination, arguments, VirtualConsole.getCurrentConsole())) break;
        }
    }

    protected static void parsePort(CommandLine commandLine, SshClientArguments arguments) {
        int port = 22;
        if (commandLine.hasOption(SshClientOptions.Port.PORT_OPTION)) {
            String portValue = commandLine.getOptionValue(SshClientOptions.Port.PORT_OPTION);
            try {
                port = Integer.parseInt(portValue);
            }
            catch (Exception e) {
                port = 22;
            }
        }
        arguments.setPort(port);
    }

    protected static void parseLoginName(CommandLine commandLine, SshClientArguments arguments) {
        if (commandLine.hasOption(SshClientOptions.LoginName.LOGIN_NAME_OPTION)) {
            arguments.setLoginName(commandLine.getOptionValue(SshClientOptions.LoginName.LOGIN_NAME_OPTION));
        }
    }

    protected static void parseIdentityFilename(CommandLine commandLine, SshClientArguments arguments, VirtualConsole console) throws IOException, PermissionDeniedException {
        if (commandLine.hasOption(SshClientOptions.IdentityFile.IDENTITY_FILE_OPTION)) {
            String filename = commandLine.getOptionValue(SshClientOptions.IdentityFile.IDENTITY_FILE_OPTION);
            AbstractFile file = console.getCurrentDirectory().resolveFile(filename);
            if (!file.exists()) {
                throw new IllegalArgumentException(filename + " does not exist");
            }
            arguments.setIdentityFile(file);
        }
    }

    protected static void parseCiphers(CommandLine commandLine, SshClientArguments arguments) {
        if (commandLine.hasOption(SshClientOptions.CipherSpec.CIPHER_SPEC_OPTION)) {
            String[] cipherSpecParts = commandLine.getOptionValues(SshClientOptions.CipherSpec.CIPHER_SPEC_OPTION);
            String[] finalValues = CommandUtil.toStringFromCsvs(cipherSpecParts);
            arguments.setCiphers(finalValues);
        }
    }

    protected static void parseMacs(CommandLine commandLine, SshClientArguments arguments) {
        if (commandLine.hasOption(SshClientOptions.MacSpec.MAC_SPEC_OPTION)) {
            String[] macSpecParts = commandLine.getOptionValues(SshClientOptions.MacSpec.MAC_SPEC_OPTION);
            String[] finalValues = CommandUtil.toStringFromCsvs(macSpecParts);
            arguments.setHmacs(finalValues);
        }
    }

    protected static void parseSecurityLevel(CommandLine commandLine, SshClientArguments arguments) {
        if (commandLine.hasOption(SshClientOptions.SecurityLevel.SECURITY_LEVEL_OPTION)) {
            String securityLevel = commandLine.getOptionValue(SshClientOptions.SecurityLevel.SECURITY_LEVEL_OPTION);
            arguments.setSecurityLevel(securityLevel);
        }
    }

    protected static void parseCompression(CommandLine commandLine, SshClientArguments arguments) {
        if (commandLine.hasOption(SshClientOptions.Compression.COMPRESSION_OPTION)) {
            arguments.setCompression(true);
        }
    }

    protected static Collection<SshOptionsResolver> getResolvers() {
        return Collections.unmodifiableCollection(resolvers);
    }
}

