/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.convert;

import com.stormpath.sdk.convert.ConversionStrategyName;
import com.stormpath.sdk.convert.ElementsConversion;
import com.stormpath.sdk.lang.Assert;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class Conversion {
    private boolean enabled = true;
    private String name;
    private ConversionStrategyName strategy = ConversionStrategyName.SCALARS;
    private Map<String, Conversion> fields = Collections.emptyMap();
    private String field;
    private ElementsConversion elements;

    public boolean isEnabled() {
        return this.enabled;
    }

    public Conversion setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Conversion setName(String name) {
        this.name = name;
        return this;
    }

    public ConversionStrategyName getStrategy() {
        return this.strategy;
    }

    public Conversion setStrategy(ConversionStrategyName strategy) {
        Assert.notNull((Object)((Object)strategy), (String)"strategy argument cannot be null.");
        this.strategy = strategy;
        return this;
    }

    public Conversion setStrategy(String strategy) {
        return this.setStrategy(ConversionStrategyName.fromName(strategy));
    }

    public String getField() {
        return this.field;
    }

    public Conversion setField(String field) {
        this.field = field;
        return this;
    }

    public Map<String, Conversion> getFields() {
        return this.fields;
    }

    public Conversion setFields(Map<String, Conversion> fields) {
        if (fields == null) {
            fields = Collections.emptyMap();
        }
        this.fields = fields;
        return this;
    }

    private Map<String, Conversion> ensureFields() {
        Map<String, Conversion> fields = this.fields;
        if (fields == null || fields == Collections.EMPTY_MAP) {
            this.fields = fields = new LinkedHashMap<String, Conversion>();
        }
        return fields;
    }

    public Conversion withField(String fieldName, Conversion conversion) {
        Assert.hasText((String)fieldName, (String)"fieldName argument cannot be null or empty.");
        Assert.notNull((Object)conversion, (String)"fieldConfig argument cannot be null.");
        this.ensureFields().put(fieldName, conversion);
        return this;
    }

    public ElementsConversion getElements() {
        return this.elements;
    }

    public Conversion setElements(ElementsConversion elements) {
        this.elements = elements;
        return this;
    }
}

