/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.convert;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.lang.Function;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.Map;

public class MapToJwtConverter
implements Function<Map<String, ?>, String> {
    private final Map<String, ?> baseHeader;
    private final Map<String, ?> baseClaims;
    private final String valueClaimName;
    private final Long expirationSeconds;
    private final Long notBeforeSeconds;
    private final SignatureAlgorithm signatureAlgorithm;
    private final Key signingKey;

    public MapToJwtConverter(Map<String, ?> baseHeader, Map<String, ?> baseClaims, String valueClaimName, SignatureAlgorithm signatureAlgorithm, Key signingKey, Long expirationSeconds, Long notBeforeSeconds) {
        this.valueClaimName = valueClaimName;
        this.baseHeader = baseHeader == null ? java.util.Collections.emptyMap() : baseHeader;
        this.baseClaims = baseClaims == null ? java.util.Collections.emptyMap() : baseClaims;
        this.expirationSeconds = expirationSeconds;
        this.notBeforeSeconds = notBeforeSeconds;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signingKey = signingKey;
        if (signatureAlgorithm != null) {
            Assert.notNull((Object)signingKey, (String)"A signing Key argument is required when specifying a SignatureAlgorithm.");
        } else if (signingKey != null) {
            String msg = "A SignatureAlgorithm argument is required when specifying a signing Key.";
            throw new IllegalArgumentException(msg);
        }
    }

    public String apply(Map<String, ?> value) {
        JwtBuilder builder = Jwts.builder();
        if (!Collections.isEmpty(this.baseHeader)) {
            builder.setHeader(this.baseHeader);
        }
        if (!Collections.isEmpty(this.baseClaims)) {
            builder.setClaims(this.baseClaims);
        }
        if (!Collections.isEmpty(value)) {
            if (this.valueClaimName != null) {
                builder.claim(this.valueClaimName, value);
            } else {
                for (Map.Entry<String, ?> entry : value.entrySet()) {
                    builder.claim(entry.getKey(), entry.getValue());
                }
            }
        }
        Date now = new Date();
        builder.setIssuedAt(now);
        long nowMillis = now.getTime();
        if (this.expirationSeconds != null) {
            long expMillis = nowMillis + this.expirationSeconds * 1000L;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        if (this.notBeforeSeconds != null) {
            long nbfMillis = nowMillis + this.notBeforeSeconds * 1000L;
            Date nbf = new Date(nbfMillis);
            builder.setNotBefore(nbf);
        }
        if (this.signatureAlgorithm != null) {
            Assert.notNull((Object)this.signingKey, (String)"Illegal state: signingKey cannot be null if signatureAlgorithm exists.");
            builder.signWith(this.signatureAlgorithm, this.signingKey);
        }
        return builder.compact();
    }
}

