/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.convert;

import com.stormpath.sdk.convert.Conversion;
import com.stormpath.sdk.convert.ConversionStrategyName;
import com.stormpath.sdk.convert.Conversions;
import com.stormpath.sdk.convert.ElementsConversion;
import com.stormpath.sdk.impl.resource.AbstractResource;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Function;
import com.stormpath.sdk.lang.Instants;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.resource.CollectionResource;
import com.stormpath.sdk.resource.Resource;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceConverter<T>
implements Function<T, Object> {
    private static final Logger log = LoggerFactory.getLogger(ResourceConverter.class);
    public static final Conversion DEFAULT_CONFIG = Conversions.withField("customData", Conversions.withStrategy(ConversionStrategyName.SCALARS)).withField("groups", Conversions.withStrategy(ConversionStrategyName.DEFINED).setElements(Conversions.each(new Conversion())));
    private Conversion config = DEFAULT_CONFIG;

    public Conversion getConfig() {
        return this.config;
    }

    public void setConfig(Conversion config) {
        Assert.notNull((Object)config, (String)"Conversion argument cannot be null.");
        this.config = config;
    }

    public Object apply(T t) {
        Assert.notNull(t, (String)"Argument cannot be null");
        return this.convert(t, this.config, "");
    }

    public Object convert(Object o, Conversion config, String path) {
        AbstractResource ar;
        Assert.notNull((Object)o, (String)"Object argument cannot be null");
        ConversionStrategyName strategy = config.getStrategy();
        Assert.notNull((Object)((Object)strategy), (String)"config strategy value cannot be null.");
        if (o instanceof AbstractResource && !(ar = (AbstractResource)o).isMaterialized()) {
            ar.materialize();
        }
        boolean isCollection = o instanceof Iterable;
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        if (strategy == ConversionStrategyName.SINGLE) {
            String fieldName = config.getField();
            if (Strings.hasText((String)fieldName) && this.hasProperty(o, fieldName)) {
                return this.getProperty(o, fieldName);
            }
            if (o instanceof AbstractResource) {
                return ((AbstractResource)o).getHref();
            }
            return null;
        }
        Map<String, Conversion> fieldsConfig = config.getFields();
        Set<String> fieldNames = this.getPropertyNames(o);
        Iterator<String> iterator = fieldNames.iterator();
        while (iterator.hasNext()) {
            String name;
            boolean enabled;
            boolean defined;
            String fieldName;
            String outputName = fieldName = iterator.next();
            ArrayList<Object> value = null;
            if (isCollection && fieldName.equals("items")) {
                ElementsConversion elementsConfig = config.getElements();
                defined = elementsConfig != null;
                enabled = !defined || elementsConfig.isEnabled();
            } else {
                defined = fieldsConfig.containsKey(fieldName);
                enabled = this.isEnabled(fieldsConfig, fieldName);
            }
            if (strategy == ConversionStrategyName.DEFINED) {
                boolean bl = enabled = defined && enabled;
            }
            if (enabled) {
                value = this.getProperty(o, fieldName);
            }
            boolean compound = this.isCompound(value);
            if (strategy == ConversionStrategyName.SCALARS && compound && !defined) {
                enabled = false;
            }
            if (!enabled) continue;
            Conversion fieldConfig = fieldsConfig.get(fieldName);
            if (fieldConfig != null && Strings.hasText((String)(name = fieldConfig.getName()))) {
                outputName = name;
            }
            if (compound) {
                if (isCollection) {
                    String elementsPath = this.joinPath(path, "elements");
                    ElementsConversion elementsConfig = config.getElements();
                    String eachPath = this.joinPath(elementsPath, "each");
                    Conversion elementConfig = elementsConfig.getEach();
                    ArrayList<Object> elements = new ArrayList<Object>();
                    int i = 0;
                    for (Object element : (Iterable)o) {
                        Object elementValue = this.convert(element, elementConfig, eachPath + "[" + i + "]");
                        if (elementValue != null) {
                            elements.add(elementValue);
                        }
                        ++i;
                    }
                    value = elements;
                    if (strategy == ConversionStrategyName.LIST) {
                        return value;
                    }
                    String elementsName = elementsConfig.getName();
                    if (Strings.hasText((String)elementsName)) {
                        outputName = elementsName;
                    }
                } else {
                    String fieldsPath = this.joinPath(path, "fields");
                    fieldConfig = fieldsConfig.get(fieldName);
                    String newPath = this.joinPath(fieldsPath, fieldName);
                    value = this.convert(value, fieldConfig, newPath);
                }
            }
            props.put(outputName, value);
        }
        if (props.isEmpty() && o instanceof AbstractResource) {
            props.put("href", ((AbstractResource)o).getHref());
        }
        return props;
    }

    protected Set<String> getPropertyNames(Object o) {
        if (o instanceof AbstractResource) {
            return ((AbstractResource)o).getPropertyNames();
        }
        if (o instanceof Map) {
            return ((Map)o).keySet();
        }
        throw new IllegalArgumentException("Argument must be an AbstractResource or Map.");
    }

    protected boolean hasProperty(Object o, String name) {
        if (o instanceof AbstractResource) {
            return ((AbstractResource)o).hasProperty(name);
        }
        if (o instanceof Map) {
            return ((Map)o).containsKey(name);
        }
        throw new IllegalArgumentException("Argument must be an AbstractResource or Map.");
    }

    protected Object getProperty(Object o, String name) {
        Object value;
        if (o instanceof Map) {
            value = ((Map)o).get(name);
        } else if (o instanceof AbstractResource) {
            AbstractResource resource = (AbstractResource)o;
            if (o instanceof CollectionResource && name.equals("items")) {
                value = resource.getProperty(name);
            } else {
                try {
                    Class<?> resourceClass = resource.getClass();
                    String methodName = "get" + Strings.capitalize((String)name);
                    Method method = resourceClass.getMethod(methodName, new Class[0]);
                    value = method.invoke(o, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    if (log.isDebugEnabled()) {
                        String msg = "Unable to access resource property '" + name + "': " + e.getMessage();
                        log.debug(msg, (Throwable)e);
                    }
                    value = resource.getProperty(name);
                }
            }
        } else {
            throw new IllegalArgumentException("Argument must be an AbstractResource or Map.");
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            value = Instants.toUtcIso8601((Date)date);
        }
        return value;
    }

    protected boolean isCompound(Object value) {
        return value instanceof Collection || value instanceof Map || value instanceof Resource;
    }

    protected boolean isEnabled(Map<String, Conversion> fieldConfig, String field) {
        if ("password".equals(field)) {
            return false;
        }
        Conversion config = fieldConfig.get(field);
        return config == null || config.isEnabled();
    }

    protected String joinPath(String parent, String child) {
        StringBuilder sb = new StringBuilder(parent);
        if (!"".equals(parent)) {
            sb.append('.');
        }
        sb.append(child);
        return sb.toString();
    }
}

