/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.convert.ResourceConverter;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Function;
import com.stormpath.sdk.servlet.account.AccountResolver;
import com.stormpath.sdk.servlet.account.DefaultAccountResolver;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.json.JsonFunction;
import com.stormpath.sdk.servlet.json.ResourceJsonFunction;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AccountStringResolver
implements Resolver<String> {
    private Function<Account, String> accountStringFunction;
    private AccountResolver accountResolver = new DefaultAccountResolver();

    public AccountStringResolver() {
        final ResourceConverter converter = new ResourceConverter();
        Function<Account, Map<String, Object>> fn = new Function<Account, Map<String, Object>>(){

            public Map<String, Object> apply(Account account) {
                Object o = converter.apply(account);
                Assert.isInstanceOf(Map.class, (Object)o, (String)"ResourceConverter was expected to return a Map instance.");
                return (Map)o;
            }
        };
        this.accountStringFunction = new ResourceJsonFunction<Account>(fn, new JsonFunction<Object>());
    }

    public void setAccountStringFunction(Function<Account, String> accountStringFunction) {
        Assert.notNull(accountStringFunction, (String)"accountStringFunction cannot be null.");
        this.accountStringFunction = accountStringFunction;
    }

    public void setAccountResolver(AccountResolver accountResolver) {
        Assert.notNull((Object)accountResolver, (String)"accountResolver cannot be null.");
        this.accountResolver = accountResolver;
    }

    @Override
    public String get(HttpServletRequest request, HttpServletResponse response) {
        Account account = this.accountResolver.getAccount((ServletRequest)request);
        if (account != null) {
            return (String)this.accountStringFunction.apply((Object)account);
        }
        return null;
    }
}

