/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.account.AccountResolver;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class DefaultAccountResolver
implements AccountResolver {
    public static final String REQUEST_ATTR_NAME = Account.class.getName();

    @Override
    public boolean hasAccount(ServletRequest request) {
        Assert.notNull((Object)request, (String)"ServletRequest argument cannot be null.");
        Account account = this.findAccount(request);
        return account != null;
    }

    protected Account findAccount(ServletRequest request) {
        Object value = request.getAttribute(REQUEST_ATTR_NAME);
        if (value == null) {
            Assert.isInstanceOf(HttpServletRequest.class, (Object)request, (String)"Only HttpServletRequests are supported.");
            HttpServletRequest req = (HttpServletRequest)request;
            HttpSession session = req.getSession(false);
            if (session != null) {
                value = session.getAttribute(REQUEST_ATTR_NAME);
            }
        }
        if (value == null) {
            return null;
        }
        Assert.isInstanceOf(Account.class, (Object)value, (String)("Account attribute must be a " + Account.class.getName() + " instance."));
        return (Account)value;
    }

    @Override
    public Account getAccount(ServletRequest request) {
        Assert.notNull((Object)request, (String)"ServletRequest argument cannot be null.");
        return this.findAccount(request);
    }

    @Override
    public Account getRequiredAccount(ServletRequest request) {
        Assert.notNull((Object)request, (String)"ServletRequest argument cannot be null.");
        Account account = this.findAccount(request);
        Assert.notNull((Object)account, (String)"The current request does not reflect an authenticated user.  Call 'hasAccount' to check if an authenticated user exists before calling this method.");
        return account;
    }
}

