/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.application;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.lang.UnknownClassException;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.application.DefaultApplicationResolver;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationLoader {
    public static final String APP_RESOLVER_CLASS_PARAM_NAME = "stormpathApplicationResolverClass";
    public static final String APP_ATTRIBUTE_NAME = Application.class.getName();
    private static final Logger log = LoggerFactory.getLogger(ApplicationLoader.class);

    public Application getApplication(ServletContext servletContext) throws IllegalStateException {
        if (servletContext.getAttribute(APP_ATTRIBUTE_NAME) != null) {
            String msg = "There is already a Stormpath Application instance associated with the current ServletContext.  Check if you have multiple ApplicationLoader* definitions in your web.xml or annotation config!";
            throw new IllegalStateException(msg);
        }
        servletContext.log("Initializing Stormpath Application instance.");
        log.info("Starting Stormpath Application initialization.");
        long startTime = System.currentTimeMillis();
        try {
            Application app = this.doGetApplication(servletContext);
            servletContext.setAttribute(APP_ATTRIBUTE_NAME, (Object)app);
            log.debug("Published Application resource as ServletContext attribute with name [{}]", (Object)APP_ATTRIBUTE_NAME);
            if (log.isInfoEnabled()) {
                long elapsed = System.currentTimeMillis() - startTime;
                log.info("Stormpath Application initialized in {} ms.", (Object)elapsed);
            }
            return app;
        }
        catch (RuntimeException ex) {
            log.error("Stormpath application initialization failed", (Throwable)ex);
            servletContext.setAttribute(APP_ATTRIBUTE_NAME, (Object)ex);
            throw ex;
        }
        catch (Error err) {
            log.error("Stormpath application initialization failed", (Throwable)err);
            servletContext.setAttribute(APP_ATTRIBUTE_NAME, (Object)err);
            throw err;
        }
    }

    protected Class<?> determineApplicationResolverClass(ServletContext servletContext) {
        String className = servletContext.getInitParameter(APP_RESOLVER_CLASS_PARAM_NAME);
        if ((className = Strings.trimWhitespace((String)className)) != null) {
            try {
                return Classes.forName((String)className);
            }
            catch (UnknownClassException ex) {
                String msg = "Failed to load custom ApplicationResolver class [" + className + "]";
                throw new IllegalStateException(msg, ex);
            }
        }
        return DefaultApplicationResolver.class;
    }

    protected Application doGetApplication(ServletContext sc) {
        Class<?> clazz = this.determineApplicationResolverClass(sc);
        if (!ApplicationResolver.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Custom ApplicationResolver class [" + clazz.getName() + "] is not of required type [" + ApplicationResolver.class.getName() + "]");
        }
        ApplicationResolver resolver = (ApplicationResolver)Classes.newInstance(clazz);
        return resolver.getApplication(sc);
    }

    public void removeApplication(ServletContext servletContext) {
        servletContext.log("Cleaning up Stormpath application.");
        servletContext.removeAttribute(APP_ATTRIBUTE_NAME);
    }
}

