/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.client;

import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.lang.UnknownClassException;
import com.stormpath.sdk.servlet.client.DefaultServletContextClientFactory;
import com.stormpath.sdk.servlet.client.ServletContextClientFactory;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientLoader {
    public static final String CLIENT_FACTORY_CLASS_PARAM = "stormpathServletContextClientFactoryClass";
    public static final String CLIENT_ATTRIBUTE_KEY = Client.class.getName();
    private static final Logger log = LoggerFactory.getLogger(ClientLoader.class);

    public Client createClient(ServletContext servletContext) throws IllegalStateException {
        if (servletContext.getAttribute(CLIENT_ATTRIBUTE_KEY) != null) {
            String msg = "There is already a Stormpath client instance associated with the current ServletContext.  Check if you have multiple ClientLoader* definitions in your web.xml or annotation config!";
            throw new IllegalStateException(msg);
        }
        servletContext.log("Initializing Stormpath client instance.");
        log.info("Starting Stormpath client initialization.");
        long startTime = System.currentTimeMillis();
        try {
            Client client = this.doCreateClient(servletContext);
            servletContext.setAttribute(CLIENT_ATTRIBUTE_KEY, (Object)client);
            log.debug("Published Client as ServletContext attribute with name [{}]", (Object)CLIENT_ATTRIBUTE_KEY);
            if (log.isInfoEnabled()) {
                long elapsed = System.currentTimeMillis() - startTime;
                log.info("Stormpath client initialized in {} ms.", (Object)elapsed);
            }
            return client;
        }
        catch (RuntimeException ex) {
            log.error("Stormpath client initialization failed", (Throwable)ex);
            servletContext.setAttribute(CLIENT_ATTRIBUTE_KEY, (Object)ex);
            throw ex;
        }
        catch (Error err) {
            log.error("Stormpath client initialization failed", (Throwable)err);
            servletContext.setAttribute(CLIENT_ATTRIBUTE_KEY, (Object)err);
            throw err;
        }
    }

    protected Class<?> determineClientFactoryClass(ServletContext servletContext) {
        String className = servletContext.getInitParameter(CLIENT_FACTORY_CLASS_PARAM);
        if ((className = Strings.trimWhitespace((String)className)) != null) {
            try {
                return Classes.forName((String)className);
            }
            catch (UnknownClassException ex) {
                throw new IllegalStateException("Failed to load custom ServletContextClientFactory class [" + className + "]", ex);
            }
        }
        return DefaultServletContextClientFactory.class;
    }

    protected Client doCreateClient(ServletContext sc) {
        Class<?> clazz = this.determineClientFactoryClass(sc);
        if (!ServletContextClientFactory.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException("Custom ServletContextClientFactory class [" + clazz.getName() + "] is not of required type [" + ServletContextClientFactory.class.getName() + "]");
        }
        ServletContextClientFactory factory = (ServletContextClientFactory)Classes.newInstance(clazz);
        return factory.createClient(sc);
    }

    public void destroyClient(ServletContext servletContext) {
        servletContext.log("Cleaning up Stormpath client.");
        servletContext.removeAttribute(CLIENT_ATTRIBUTE_KEY);
    }
}

