/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.client;

import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.client.ClientLoader;
import com.stormpath.sdk.servlet.client.ClientResolver;
import com.stormpath.sdk.servlet.client.DefaultClientLoaderListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;

public class DefaultClientResolver
implements ClientResolver {
    private static final String ERROR_MSG = "There is no Client instance accessible via the ServletContext attribute key [" + ClientLoader.CLIENT_ATTRIBUTE_KEY + "].  This is an invalid webapp configuration.  Consider defining the " + DefaultClientLoaderListener.class.getName() + " in web.xml or manually adding a Client instance to the ServletContext under this key.  For example:\n\n<listener>\n     <listener-class>com.stormpath.sdk.servlet.client.DefaultClientLoaderListener</listener-class>\n </listener>";

    @Override
    public Client getClient(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, (String)"ServletContext argument cannot be null.");
        Object object = servletContext.getAttribute(ClientLoader.CLIENT_ATTRIBUTE_KEY);
        Assert.notNull((Object)object, (String)ERROR_MSG);
        Assert.isInstanceOf(Client.class, (Object)object, (String)("Object instance found under servlet context attribute name " + ClientLoader.CLIENT_ATTRIBUTE_KEY + "' is not a " + Client.class.getName() + " instance as required.  Instance is of type: " + object.getClass().getName()));
        return (Client)object;
    }

    @Override
    public Client getClient(ServletRequest request) {
        return this.getClient(request.getServletContext());
    }
}

