/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.ConfigResolver;
import com.stormpath.sdk.servlet.config.Factory;
import com.stormpath.sdk.servlet.util.ServletContextInitializable;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public abstract class ConfigSingletonFactory<T>
implements ServletContextInitializable,
Factory<T> {
    private T instance;
    private ServletContext servletContext;

    @Override
    public T getInstance() {
        Assert.notNull(this.instance, (String)"Factory must be initialized before it can be used.");
        return this.instance;
    }

    protected Config getConfig() {
        Assert.notNull((Object)this.servletContext, (String)"init must be called first before config can be obtained.");
        return ConfigResolver.INSTANCE.getConfig(this.servletContext);
    }

    protected abstract T createInstance(ServletContext var1) throws Exception;

    @Override
    public void init(ServletContext servletContext) throws ServletException {
        this.servletContext = servletContext;
        try {
            T instance = this.createInstance(servletContext);
            Assert.notNull(instance, (String)"Factory instance cannot be null.");
            this.instance = instance;
        }
        catch (Exception e) {
            String msg = "Unable to create singleton instance: " + e;
            throw new ServletException(msg, (Throwable)e);
        }
    }
}

