/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.Factory;
import java.util.LinkedHashMap;
import java.util.Map;

public class ImplementationClassResolver<T> {
    private final Config CONFIG;
    private final String PROPERTY_NAME_PREFIX;
    private final Class<T> EXPECTED_TYPE;

    public ImplementationClassResolver(Config config, String propertyNamePrefix, Class<T> expectedType) {
        Assert.notNull((Object)config, (String)"config cannot be null.");
        Assert.notNull(expectedType, (String)"expectedType cannot be null.");
        Assert.hasText((String)propertyNamePrefix, (String)"propertyNamePrefix cannot be null or empty.");
        this.CONFIG = config;
        this.PROPERTY_NAME_PREFIX = propertyNamePrefix;
        this.EXPECTED_TYPE = expectedType;
    }

    public Map<String, Class<T>> findImplementationClasses() {
        LinkedHashMap<String, Class<T>> classes = new LinkedHashMap<String, Class<T>>();
        for (String key : this.CONFIG.keySet()) {
            String instanceName;
            int i;
            if (!key.startsWith(this.PROPERTY_NAME_PREFIX) || (i = (instanceName = key.substring(this.PROPERTY_NAME_PREFIX.length())).indexOf(46)) >= 0) continue;
            String className = (String)this.CONFIG.get(key);
            try {
                Class clazz = Classes.forName((String)className);
                Assert.isTrue((this.EXPECTED_TYPE.isAssignableFrom(clazz) || Factory.class.isAssignableFrom(clazz) ? 1 : 0) != 0);
                classes.put(instanceName, clazz);
            }
            catch (Exception e) {
                String msg = key + " value [" + className + "] is not a valid " + this.EXPECTED_TYPE.getName() + " class.";
                throw new IllegalArgumentException(msg, e);
            }
        }
        return classes;
    }
}

