/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.http.Resolver;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IsRequestSecureResolver
implements Resolver<Boolean> {
    private final Resolver<Boolean> secureRequiredExceptForLocalhostResolver;
    private final Resolver<Boolean> secureForwardedProtoAwareResolver;
    private static final String HTTPS = "https";

    public IsRequestSecureResolver(Resolver<Boolean> secureRequiredExceptForLocalhostResolver, Resolver<Boolean> secureForwardedProtoAwareResolver) {
        Assert.notNull(secureRequiredExceptForLocalhostResolver, (String)"secureRequiredExceptForLocalhostResolver resolver cannot be null.");
        Assert.notNull(secureForwardedProtoAwareResolver, (String)"secureForwardedProtoAwareResolver resolver cannot be null.");
        this.secureRequiredExceptForLocalhostResolver = secureRequiredExceptForLocalhostResolver;
        this.secureForwardedProtoAwareResolver = secureForwardedProtoAwareResolver;
    }

    @Override
    public Boolean get(HttpServletRequest request, HttpServletResponse response) {
        if (HTTPS.equals(request.getScheme())) {
            return true;
        }
        boolean result = this.secureRequiredExceptForLocalhostResolver.get(request, response);
        if (!result) {
            result = this.secureForwardedProtoAwareResolver.get(request, response);
        }
        return result;
    }
}

