/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.BiPredicate;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.application.DefaultApplicationResolver;
import com.stormpath.sdk.servlet.config.RegisterEnabledPredicate;
import com.stormpath.sdk.servlet.http.Resolver;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RegisterEnabledResolver
implements Resolver<Boolean> {
    private final boolean registerEnabled;
    private final ApplicationResolver applicationResolver;
    private final BiPredicate<Boolean, Application> predicate;

    public RegisterEnabledResolver(boolean registerEnabled) {
        this(registerEnabled, new DefaultApplicationResolver());
    }

    public RegisterEnabledResolver(boolean registerEnabled, ApplicationResolver applicationResolver) {
        this(registerEnabled, applicationResolver, new RegisterEnabledPredicate());
    }

    public RegisterEnabledResolver(boolean registerEnabled, ApplicationResolver applicationResolver, BiPredicate<Boolean, Application> predicate) {
        this.registerEnabled = registerEnabled;
        this.applicationResolver = applicationResolver;
        this.predicate = predicate;
        Assert.notNull((Object)applicationResolver, (String)"applicationResolver cannot be null.");
        Assert.notNull(predicate, (String)"predicate cannot be null.");
    }

    @Override
    public Boolean get(HttpServletRequest request, HttpServletResponse response) {
        if (!this.registerEnabled) {
            return false;
        }
        Application application = this.applicationResolver.getApplication((ServletRequest)request);
        return this.predicate.test((Object)true, (Object)application);
    }
}

