/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config;

import com.stormpath.sdk.servlet.config.ConfigSingletonFactory;
import com.stormpath.sdk.servlet.config.IsRequestSecureResolver;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.util.SecureRequiredExceptForLocalhostResolver;
import javax.servlet.ServletContext;

public class SecureResolverFactory
extends ConfigSingletonFactory<Resolver<Boolean>> {
    public static final String LOCALHOST_RESOLVER = "stormpath.web.localhost.resolver";
    public static final String X_FORWARDED_PROTO_RESOLVER = "stormpath.web.xforwardedproto.resolver";

    @Override
    protected Resolver<Boolean> createInstance(ServletContext servletContext) throws Exception {
        Resolver localhostResolver = (Resolver)this.getConfig().getInstance(LOCALHOST_RESOLVER);
        Resolver xForwardedProtoResolver = (Resolver)this.getConfig().getInstance(X_FORWARDED_PROTO_RESOLVER);
        SecureRequiredExceptForLocalhostResolver secureRequiredExceptForLocalhostResolver = new SecureRequiredExceptForLocalhostResolver(localhostResolver);
        return new IsRequestSecureResolver(secureRequiredExceptForLocalhostResolver, xForwardedProtoResolver);
    }
}

