/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config.filter;

import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.filter.ControllerFilterFactory;
import com.stormpath.sdk.servlet.filter.DefaultServerUriResolver;
import com.stormpath.sdk.servlet.filter.mvc.ControllerFilter;
import com.stormpath.sdk.servlet.idsite.DefaultIdSiteOrganizationResolver;
import com.stormpath.sdk.servlet.mvc.Controller;
import com.stormpath.sdk.servlet.mvc.IdSiteController;
import com.stormpath.sdk.servlet.organization.DefaultOrganizationNameKeyResolver;
import com.stormpath.sdk.servlet.util.SubdomainResolver;

public abstract class AbstractIDSiteFilterFactory<T extends IdSiteController>
extends ControllerFilterFactory<T> {
    @Override
    protected abstract T newController();

    @Override
    protected void configure(T controller, Config config) throws Exception {
        SubdomainResolver subdomainResolver = new SubdomainResolver();
        subdomainResolver.setBaseDomainName((String)config.get("stormpath.web.application.domain"));
        DefaultOrganizationNameKeyResolver organizationNameKeyResolver = new DefaultOrganizationNameKeyResolver();
        organizationNameKeyResolver.setSubdomainResolver(subdomainResolver);
        DefaultIdSiteOrganizationResolver idSiteOrganizationResolver = new DefaultIdSiteOrganizationResolver();
        idSiteOrganizationResolver.setOrganizationNameKeyResolver(organizationNameKeyResolver);
        ((IdSiteController)controller).setServerUriResolver(new DefaultServerUriResolver());
        ((IdSiteController)controller).setCallbackUri(this.getConfig().getCallbackUri());
        ((IdSiteController)controller).setAlreadyLoggedInUri((String)config.get("stormpath.web.login.nextUri"));
        ((IdSiteController)controller).setIdSiteOrganizationResolver(idSiteOrganizationResolver);
        ControllerFilter filter = new ControllerFilter();
        filter.setProducedMediaTypes(config.getProducedMediaTypes());
        filter.setController((Controller)controller);
        this.doConfigure(controller, config);
    }

    public abstract void doConfigure(T var1, Config var2);
}

