/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config.filter;

import com.stormpath.sdk.servlet.authz.RequestAuthorizer;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.filter.ControllerFilterFactory;
import com.stormpath.sdk.servlet.event.impl.Publisher;
import com.stormpath.sdk.servlet.filter.oauth.AccessTokenAuthenticationRequestFactory;
import com.stormpath.sdk.servlet.filter.oauth.AccessTokenResultFactory;
import com.stormpath.sdk.servlet.filter.oauth.RefreshTokenAuthenticationRequestFactory;
import com.stormpath.sdk.servlet.filter.oauth.RefreshTokenResultFactory;
import com.stormpath.sdk.servlet.http.Saver;
import com.stormpath.sdk.servlet.http.authc.BasicAuthenticationScheme;
import com.stormpath.sdk.servlet.mvc.AccessTokenController;
import com.stormpath.sdk.servlet.util.GrantTypeValidator;

public class AccessTokenFilterFactory
extends ControllerFilterFactory<AccessTokenController> {
    protected static final String ACCESS_TOKEN_AUTHENTICATION_REQUEST_FACTORY = "stormpath.web.oauth2.authenticationRequestFactory";
    protected static final String ACCESS_TOKEN_RESULT_FACTORY = "stormpath.web.oauth2.resultFactory";
    protected static final String REFRESH_TOKEN_AUTHENTICATION_REQUEST_FACTORY = "stormpath.web.refreshToken.authenticationRequestFactory";
    protected static final String REFRESH_TOKEN_RESULT_FACTORY = "stormpath.web.refreshToken.resultFactory";
    protected static final String REQUEST_AUTHORIZER = "stormpath.web.oauth2.authorizer";
    protected static final String ACCOUNT_SAVER = "stormpath.web.authc.saver";
    protected static final String EVENT_PUBLISHER = "stormpath.web.request.event.publisher";
    protected static final String BASIC_AUTHENTICATION_REQUEST_FACTORY = "stormpath.web.http.authc.schemes.basic";

    @Override
    protected AccessTokenController newController() {
        return new AccessTokenController();
    }

    @Override
    protected void configure(AccessTokenController controller, Config config) throws Exception {
        AccessTokenAuthenticationRequestFactory accessTokenAuthenticationRequestFactory = (AccessTokenAuthenticationRequestFactory)config.getInstance(ACCESS_TOKEN_AUTHENTICATION_REQUEST_FACTORY);
        RefreshTokenAuthenticationRequestFactory refreshTokenAuthenticationRequestFactory = (RefreshTokenAuthenticationRequestFactory)config.getInstance(REFRESH_TOKEN_AUTHENTICATION_REQUEST_FACTORY);
        RequestAuthorizer requestAuthorizer = (RequestAuthorizer)config.getInstance(REQUEST_AUTHORIZER);
        AccessTokenResultFactory accessTokenResultFactory = (AccessTokenResultFactory)config.getInstance(ACCESS_TOKEN_RESULT_FACTORY);
        RefreshTokenResultFactory refreshTokenResultFactory = (RefreshTokenResultFactory)config.getInstance(REFRESH_TOKEN_RESULT_FACTORY);
        Saver accountSaver = (Saver)config.getInstance(ACCOUNT_SAVER);
        Publisher eventPublisher = (Publisher)config.getInstance(EVENT_PUBLISHER);
        BasicAuthenticationScheme basicAuthenticationScheme = (BasicAuthenticationScheme)config.getInstance(BASIC_AUTHENTICATION_REQUEST_FACTORY);
        GrantTypeValidator grantTypeValidator = config.getGrantTypeStatusValidator();
        controller.setEventPublisher(eventPublisher);
        controller.setAccessTokenAuthenticationRequestFactory(accessTokenAuthenticationRequestFactory);
        controller.setAccessTokenResultFactory(accessTokenResultFactory);
        controller.setRefreshTokenAuthenticationRequestFactory(refreshTokenAuthenticationRequestFactory);
        controller.setRefreshTokenResultFactory(refreshTokenResultFactory);
        controller.setAccountSaver(accountSaver);
        controller.setRequestAuthorizer(requestAuthorizer);
        controller.setBasicAuthenticationScheme(basicAuthenticationScheme);
        controller.setGrantTypeValidator(grantTypeValidator);
    }
}

