/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config.filter;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.filter.FilterFactory;
import com.stormpath.sdk.servlet.filter.Filters;
import com.stormpath.sdk.servlet.filter.account.AccountResolverFilter;
import com.stormpath.sdk.servlet.http.Resolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class AccountResolverFilterFactory
extends FilterFactory<AccountResolverFilter> {
    public static final String ACCOUNT_RESOLVER_LOCATIONS = "stormpath.web.account.resolvers";
    public static final String ACCOUNT_RESOLVER_PROPERTY_PREFIX = "stormpath.web.account.resolvers.";

    @Override
    protected AccountResolverFilter createInstance(ServletContext servletContext, Config config) throws Exception {
        AccountResolverFilter filter = new AccountResolverFilter();
        filter.setOauthEndpointUri(config.getAccessTokenUrl());
        List<Resolver<Account>> resolvers = this.getResolvers(config);
        filter.setResolvers(resolvers);
        return (AccountResolverFilter)Filters.builder().setServletContext(servletContext).setName(Strings.uncapitalize((String)AccountResolverFilter.class.getSimpleName())).setFilter(filter).build();
    }

    protected List<Resolver<Account>> getResolvers(Config config) throws ServletException {
        List<String> locations = null;
        String val = (String)config.get(ACCOUNT_RESOLVER_LOCATIONS);
        if (Strings.hasText((String)val)) {
            String[] locs = Strings.split((String)val);
            locations = Arrays.asList(locs);
        }
        Assert.notEmpty(locations, (String)"At least one stormpath.web.account.resolvers must be specified.");
        assert (locations != null);
        Map<String, Resolver> resolverMap = config.getInstances(ACCOUNT_RESOLVER_PROPERTY_PREFIX, Resolver.class);
        ArrayList<Resolver> resolvers = new ArrayList<Resolver>(resolverMap.size());
        for (String location : locations) {
            Resolver resolver = resolverMap.get(location);
            Assert.notNull((Object)resolver, (String)("There is no configured Account Resolver named " + location));
            Resolver accountResolver = resolver;
            resolvers.add(accountResolver);
        }
        return Collections.unmodifiableList(resolvers);
    }
}

