/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config.filter;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.UriCleaner;
import com.stormpath.sdk.servlet.config.impl.DefaultUriCleaner;
import com.stormpath.sdk.servlet.config.impl.ExpressionConfigReader;
import com.stormpath.sdk.servlet.filter.DefaultFilter;
import com.stormpath.sdk.servlet.filter.FilterChainManager;
import java.util.LinkedHashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class DefaultFilterChainManagerConfigurer {
    public static final String ROUTE_CONFIG_NAME_PREFIX = "stormpath.web.uris.";
    private static final UriCleaner URI_CLEANER = new DefaultUriCleaner();
    private final FilterChainManager mgr;
    private final ServletContext servletContext;
    private final Config config;

    public DefaultFilterChainManagerConfigurer(FilterChainManager mgr, ServletContext servletContext, Config config) {
        Assert.notNull((Object)mgr, (String)"FilterChainManager cannot be null.");
        this.mgr = mgr;
        this.config = config;
        this.servletContext = servletContext;
    }

    protected String cleanUri(String uri) {
        return URI_CLEANER.clean(uri);
    }

    public FilterChainManager configure() throws ServletException {
        if (!this.config.isStormpathWebEnabled()) {
            return this.mgr;
        }
        ExpressionConfigReader reader = new ExpressionConfigReader(this.servletContext, this.config);
        boolean assetsEnabled = reader.getBoolean("stormpath.web.assets.enabled");
        boolean jsEnabled = reader.getBoolean("stormpath.web.assets.js.enabled");
        boolean cssEnabled = reader.getBoolean("stormpath.web.assets.css.enabled");
        String loginUrl = this.config.getLoginConfig().getUri();
        String loginUrlPattern = this.cleanUri(loginUrl);
        boolean loginChainSpecified = false;
        boolean loginEnabled = this.config.getLoginConfig().isEnabled();
        String logoutUrl = this.config.getLogoutConfig().getUri();
        String logoutUrlPattern = this.cleanUri(logoutUrl);
        boolean logoutChainSpecified = false;
        boolean logoutEnabled = this.config.getLogoutConfig().isEnabled();
        String forgotUrl = this.config.getForgotPasswordConfig().getUri();
        String forgotUrlPattern = this.cleanUri(forgotUrl);
        boolean forgotChainSpecified = false;
        boolean forgotPasswordEnabled = this.config.getForgotPasswordConfig().isEnabled();
        String changeUrl = this.config.getChangePasswordConfig().getUri();
        String changeUrlPattern = this.cleanUri(changeUrl);
        boolean changeChainSpecified = false;
        boolean changePasswordEnabled = this.config.getChangePasswordConfig().isEnabled();
        String registerUrl = this.config.getRegisterConfig().getUri();
        String registerUrlPattern = this.cleanUri(registerUrl);
        boolean registerChainSpecified = false;
        boolean registerEnabled = this.config.getRegisterConfig().isEnabled();
        registerEnabled = this.config.getRegisterEnabledPredicate().test((Object)registerEnabled, (Object)this.config.getApplicationResolver().getApplication(this.servletContext));
        String verifyUrl = this.config.getVerifyConfig().getUri();
        String verifyUrlPattern = this.cleanUri(verifyUrl);
        boolean verifyChainSpecified = false;
        boolean verifyEmailEnabled = this.config.getVerifyConfig().isEnabled();
        String accessTokenUrl = this.config.getAccessTokenUrl();
        String accessTokenUrlPattern = this.cleanUri(accessTokenUrl);
        boolean accessTokenChainSpecified = false;
        boolean oauthEnabled = this.config.isOAuthEnabled();
        String revokeTokenUrl = this.config.getRevokeTokenUrl();
        String revokeTokenUrlPattern = this.cleanUri(revokeTokenUrl);
        boolean revokeTokenChainSpecified = false;
        String unauthorizedUrl = this.config.getUnauthorizedUrl();
        String unauthorizedUrlPattern = this.cleanUri(unauthorizedUrl);
        boolean unauthorizedChainSpecified = false;
        String samlUrl = this.config.getSamlConfig().getUri();
        String samlUrlPattern = this.cleanUri(samlUrl);
        String samlCallbackUrl = this.config.getCallbackUri();
        String samlCallbackPattern = this.cleanUri(samlCallbackUrl);
        boolean samlChainSpecified = false;
        boolean callbackEnabled = this.config.isCallbackEnabled();
        String meUrl = this.config.getMeUrl();
        String meUrlPattern = this.cleanUri(meUrl);
        boolean meChainSpecified = false;
        boolean meEnabled = this.config.isMeEnabled();
        boolean idSiteEnabled = this.config.isIdSiteEnabled();
        String idSiteResultUrl = this.config.getCallbackUri();
        String idSiteResultUrlPattern = this.cleanUri(idSiteResultUrl);
        String googleCallbackUrl = (String)this.config.get("stormpath.web.social.google.uri");
        String googleCallbackUrlPattern = this.cleanUri(googleCallbackUrl);
        boolean googleCallbackChainSpecified = false;
        String githubCallbackUrl = (String)this.config.get("stormpath.web.social.github.uri");
        String githubCallbackUrlPattern = this.cleanUri(githubCallbackUrl);
        boolean githubCallbackChainSpecified = false;
        String facebookCallbackUrl = (String)this.config.get("stormpath.web.social.facebook.uri");
        String facebookCallbackUrlPattern = this.cleanUri(facebookCallbackUrl);
        boolean facebookCallbackChainSpecified = false;
        String linkedinCallbackUrl = (String)this.config.get("stormpath.web.social.linkedin.uri");
        String linkedinCallbackUrlPattern = this.cleanUri(linkedinCallbackUrl);
        boolean linkedinCallbackChainSpecified = false;
        LinkedHashMap<String, String> patternChains = new LinkedHashMap<String, String>();
        for (String key : this.config.keySet()) {
            String filterName;
            if (!key.startsWith(ROUTE_CONFIG_NAME_PREFIX)) continue;
            String uriPattern = key.substring(ROUTE_CONFIG_NAME_PREFIX.length());
            String chainDefinition = (String)this.config.get(key);
            if (uriPattern.startsWith(linkedinCallbackUrl)) {
                linkedinCallbackChainSpecified = true;
                filterName = DefaultFilter.linkedinCallback.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            } else if (uriPattern.startsWith(facebookCallbackUrl)) {
                facebookCallbackChainSpecified = true;
                filterName = DefaultFilter.facebookCallback.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            } else if (uriPattern.startsWith(githubCallbackUrl)) {
                githubCallbackChainSpecified = true;
                filterName = DefaultFilter.githubCallback.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            } else if (uriPattern.startsWith(googleCallbackUrl)) {
                googleCallbackChainSpecified = true;
                filterName = DefaultFilter.googleCallback.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            } else if (uriPattern.startsWith(loginUrlPattern)) {
                loginChainSpecified = true;
                filterName = DefaultFilter.login.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            } else if (uriPattern.startsWith(logoutUrlPattern)) {
                logoutChainSpecified = true;
                filterName = DefaultFilter.logout.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            } else if (uriPattern.startsWith(forgotUrlPattern)) {
                forgotChainSpecified = true;
                filterName = DefaultFilter.forgot.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            } else if (uriPattern.startsWith(changeUrlPattern)) {
                changeChainSpecified = true;
                filterName = DefaultFilter.change.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            } else if (uriPattern.startsWith(registerUrlPattern)) {
                registerChainSpecified = true;
                filterName = DefaultFilter.register.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            } else if (uriPattern.startsWith(verifyUrlPattern)) {
                verifyChainSpecified = true;
                filterName = DefaultFilter.verify.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            } else if (uriPattern.startsWith(accessTokenUrlPattern)) {
                accessTokenChainSpecified = true;
                filterName = DefaultFilter.accessToken.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            } else if (uriPattern.startsWith(revokeTokenUrlPattern)) {
                revokeTokenChainSpecified = true;
                filterName = DefaultFilter.revokeToken.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            } else if (uriPattern.startsWith(unauthorizedUrlPattern)) {
                unauthorizedChainSpecified = true;
                filterName = DefaultFilter.unauthorized.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            } else if (uriPattern.startsWith(samlUrlPattern)) {
                samlChainSpecified = true;
                filterName = DefaultFilter.saml.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            } else if (uriPattern.startsWith(meUrlPattern)) {
                meChainSpecified = true;
                filterName = DefaultFilter.me.name();
                if (!chainDefinition.contains(filterName)) {
                    chainDefinition = chainDefinition + ',' + filterName;
                }
            }
            patternChains.put(uriPattern, chainDefinition);
        }
        if (assetsEnabled && (jsEnabled || cssEnabled)) {
            if (jsEnabled) {
                this.mgr.createChain("/assets/js/stormpath.js", "staticResource");
            }
            if (cssEnabled) {
                this.mgr.createChain("/assets/css/stormpath.css", "staticResource");
                this.mgr.createChain("/assets/css/custom.stormpath.css", "staticResource");
                this.mgr.createChain("/assets/css/override.stormpath.css", "staticResource");
            }
        }
        if (!unauthorizedChainSpecified) {
            this.mgr.createChain(unauthorizedUrlPattern, DefaultFilter.unauthorized.name());
        }
        if (!loginChainSpecified && loginEnabled) {
            if (!idSiteEnabled) {
                this.mgr.createChain(loginUrlPattern, DefaultFilter.login.name());
            } else {
                this.mgr.createChain(loginUrlPattern, DefaultFilter.idSite.name());
                this.mgr.createChain(idSiteResultUrlPattern, DefaultFilter.idSiteResult.name());
            }
        }
        if (!logoutChainSpecified && logoutEnabled) {
            if (!idSiteEnabled) {
                this.mgr.createChain(logoutUrlPattern, DefaultFilter.logout.name());
            } else {
                this.mgr.createChain(logoutUrlPattern, DefaultFilter.idSiteLogout.name());
            }
        }
        if (!forgotChainSpecified && forgotPasswordEnabled) {
            if (!idSiteEnabled) {
                this.mgr.createChain(forgotUrlPattern, DefaultFilter.forgot.name());
            } else {
                this.mgr.createChain(forgotUrlPattern, DefaultFilter.idSiteForgot.name());
            }
        }
        if (!changeChainSpecified && changePasswordEnabled) {
            this.mgr.createChain(changeUrlPattern, DefaultFilter.change.name());
        }
        if (!registerChainSpecified && registerEnabled) {
            if (!idSiteEnabled) {
                this.mgr.createChain(registerUrlPattern, DefaultFilter.register.name());
            } else {
                this.mgr.createChain(registerUrlPattern, DefaultFilter.idSiteRegister.name());
            }
        }
        if (!verifyChainSpecified && verifyEmailEnabled) {
            this.mgr.createChain(verifyUrlPattern, DefaultFilter.verify.name());
        }
        if (!accessTokenChainSpecified && oauthEnabled) {
            this.mgr.createChain(accessTokenUrlPattern, DefaultFilter.accessToken.name());
        }
        if (!revokeTokenChainSpecified && oauthEnabled) {
            this.mgr.createChain(revokeTokenUrlPattern, DefaultFilter.revokeToken.name());
        }
        if (!samlChainSpecified && callbackEnabled) {
            this.mgr.createChain(samlUrlPattern, DefaultFilter.saml.name());
            this.mgr.createChain(samlCallbackPattern, DefaultFilter.samlResult.name());
        }
        if (!meChainSpecified && meEnabled) {
            this.mgr.createChain(meUrlPattern, "authc," + DefaultFilter.me.name());
        }
        if (!googleCallbackChainSpecified) {
            this.mgr.createChain(googleCallbackUrlPattern, DefaultFilter.googleCallback.name());
        }
        if (!githubCallbackChainSpecified) {
            this.mgr.createChain(githubCallbackUrlPattern, DefaultFilter.githubCallback.name());
        }
        if (!facebookCallbackChainSpecified) {
            this.mgr.createChain(facebookCallbackUrlPattern, DefaultFilter.facebookCallback.name());
        }
        if (!linkedinCallbackChainSpecified) {
            this.mgr.createChain(linkedinCallbackUrlPattern, DefaultFilter.linkedinCallback.name());
        }
        for (String pattern : patternChains.keySet()) {
            String chainDefinition = (String)patternChains.get(pattern);
            this.mgr.createChain(pattern, chainDefinition);
        }
        return this.mgr;
    }
}

