/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config.filter;

import com.stormpath.sdk.servlet.config.ConfigSingletonFactory;
import com.stormpath.sdk.servlet.config.filter.AccountResolverFilterFactory;
import com.stormpath.sdk.servlet.config.filter.CorsFilterFactory;
import com.stormpath.sdk.servlet.filter.FilterChainManager;
import com.stormpath.sdk.servlet.filter.FilterChainResolver;
import com.stormpath.sdk.servlet.filter.PathMatchingFilterChainResolver;
import com.stormpath.sdk.servlet.filter.PrioritizedFilterChainResolver;
import java.util.ArrayList;
import javax.servlet.Filter;
import javax.servlet.ServletContext;

public class FilterChainResolverFactory
extends ConfigSingletonFactory<FilterChainResolver> {
    @Override
    protected FilterChainResolver createInstance(ServletContext servletContext) throws Exception {
        PathMatchingFilterChainResolver resolver = new PathMatchingFilterChainResolver(servletContext);
        FilterChainManager mgr = this.getConfig().getFilterChainManager();
        resolver.setFilterChainManager(mgr);
        AccountResolverFilterFactory factory = new AccountResolverFilterFactory();
        factory.init(servletContext);
        Filter accountFilter = (Filter)factory.getInstance();
        ArrayList<Filter> priorityFilters = new ArrayList<Filter>();
        priorityFilters.add(accountFilter);
        if (this.getConfig().isCorsEnabled()) {
            CorsFilterFactory corsFilterFactory = new CorsFilterFactory();
            corsFilterFactory.init(servletContext);
            priorityFilters.add((Filter)corsFilterFactory.getInstance());
        }
        return new PrioritizedFilterChainResolver(resolver, priorityFilters);
    }
}

