/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.BiPredicate;
import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.account.AccountResolver;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.client.ClientResolver;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.CookieConfig;
import com.stormpath.sdk.servlet.config.Factory;
import com.stormpath.sdk.servlet.config.ImplementationClassResolver;
import com.stormpath.sdk.servlet.config.RegisterEnabledResolver;
import com.stormpath.sdk.servlet.config.impl.AccessTokenCookieConfig;
import com.stormpath.sdk.servlet.config.impl.ConfigReader;
import com.stormpath.sdk.servlet.config.impl.ExpressionConfigReader;
import com.stormpath.sdk.servlet.config.impl.RefreshTokenCookieConfig;
import com.stormpath.sdk.servlet.csrf.CsrfTokenManager;
import com.stormpath.sdk.servlet.event.RequestEvent;
import com.stormpath.sdk.servlet.event.impl.Publisher;
import com.stormpath.sdk.servlet.filter.ChangePasswordConfig;
import com.stormpath.sdk.servlet.filter.ChangePasswordServletControllerConfig;
import com.stormpath.sdk.servlet.filter.ContentNegotiationResolver;
import com.stormpath.sdk.servlet.filter.ControllerConfig;
import com.stormpath.sdk.servlet.filter.FilterChainManager;
import com.stormpath.sdk.servlet.filter.FilterChainResolver;
import com.stormpath.sdk.servlet.filter.ServerUriResolver;
import com.stormpath.sdk.servlet.filter.ServletControllerConfig;
import com.stormpath.sdk.servlet.http.InvalidMediaTypeException;
import com.stormpath.sdk.servlet.http.MediaType;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.http.Saver;
import com.stormpath.sdk.servlet.http.authc.AccountStoreResolver;
import com.stormpath.sdk.servlet.i18n.DefaultMessageContext;
import com.stormpath.sdk.servlet.i18n.MessageContext;
import com.stormpath.sdk.servlet.i18n.MessageSource;
import com.stormpath.sdk.servlet.idsite.IdSiteOrganizationContext;
import com.stormpath.sdk.servlet.mvc.RequestFieldValueResolver;
import com.stormpath.sdk.servlet.mvc.WebHandler;
import com.stormpath.sdk.servlet.util.DefaultGrantTypeValidator;
import com.stormpath.sdk.servlet.util.GrantTypeValidator;
import com.stormpath.sdk.servlet.util.ServletContextInitializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class DefaultConfig
implements Config {
    public static final String UNAUTHORIZED_URL = "stormpath.web.unauthorized.uri";
    public static final String LOGOUT_INVALIDATE_HTTP_SESSION = "stormpath.web.logout.invalidateHttpSession";
    public static final String ACCESS_TOKEN_URL = "stormpath.web.oauth2.uri";
    public static final String REVOKE_TOKEN_URL = "stormpath.web.oauth2.revoke.uri";
    public static final String ACCESS_TOKEN_VALIDATION_STRATEGY = "stormpath.web.oauth2.password.validationStrategy";
    protected static final String SERVER_URI_RESOLVER = "stormpath.web.oauth2.origin.authorizer.serverUriResolver";
    protected static final String IDSITE_ORGANIZATION_RESOLVER_FACTORY = "stormpath.web.idSite.OrganizationResolverFactory";
    private static final String PROVIDER_ACCOUNT_REQUEST_RESOLVER = "";
    public static final String WEB_APPLICATION_DOMAIN = "stormpath.web.application.domain";
    public static final String PRODUCES_MEDIA_TYPES = "stormpath.web.produces";
    public static final String ME_ENABLED = "stormpath.web.me.enabled";
    public static final String ME_URL = "stormpath.web.me.uri";
    public static final String OAUTH_ENABLED = "stormpath.web.oauth2.enabled";
    public static final String CLIENT_CREDENTIALS_GRANT_TYPE_ENABLED = "stormpath.web.oauth2.client_credentials.enabled";
    public static final String PASSWORD_GRANT_TYPE_ENABLED = "stormpath.web.oauth2.password.enabled";
    public static final String ID_SITE_ENABLED = "stormpath.web.idSite.enabled";
    public static final String CALLBACK_ENABLED = "stormpath.web.callback.enabled";
    public static final String CALLBACK_URI = "stormpath.web.callback.uri";
    public static final String STORMPATH_ENABLED = "stormpath.enabled";
    public static final String STORMPATH_WEB_ENABLED = "stormpath.web.enabled";
    public static final String STORMPATH_WEB_CORS_ALLOWED_ORIGINS = "stormpath.web.cors.allowed.originUris";
    public static final String STORMPATH_WEB_CORS_ALLOWED_HEADERS = "stormpath.web.cors.allowed.headers";
    public static final String STORMPATH_WEB_CORS_ALLOWED_METHODS = "stormpath.web.cors.allowed.methods";
    public static final String STORMPATH_WEB_CORS_ENABLED = "stormpath.web.cors.enabled";
    private final ServletContext servletContext;
    private final ConfigReader CFG;
    private final Map<String, String> props;
    private final CookieConfig ACCESS_TOKEN_COOKIE_CONFIG;
    private final CookieConfig REFRESH_TOKEN_COOKIE_CONFIG;
    private final Map<String, Object> SINGLETONS;

    public DefaultConfig(ServletContext servletContext, Map<String, String> configProps) {
        Assert.notNull((Object)servletContext, (String)"servletContext argument cannot be null.");
        Assert.notNull(configProps, (String)"Properties argument cannot be null.");
        this.servletContext = servletContext;
        this.props = new HashMap<String, String>(configProps);
        this.CFG = new ExpressionConfigReader(servletContext, Collections.unmodifiableMap(this.props));
        this.SINGLETONS = new LinkedHashMap<String, Object>();
        this.ACCESS_TOKEN_COOKIE_CONFIG = new AccessTokenCookieConfig(this.CFG);
        this.REFRESH_TOKEN_COOKIE_CONFIG = new RefreshTokenCookieConfig(this.CFG);
        if (this.isIdSiteEnabled() && !this.isCallbackEnabled()) {
            throw new IllegalArgumentException("Cannot enable ID Site without having callback enabled. Please change 'stormpath.web.callback.enabled' to true or disable ID Site by setting 'stormpath.web.idSite.enabled` to false.");
        }
    }

    @Override
    public Client getClient() {
        return ClientResolver.INSTANCE.getClient(this.servletContext);
    }

    @Override
    public ApplicationResolver getApplicationResolver() {
        return ApplicationResolver.INSTANCE;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        try {
            return this.getInstance("stormpath.web.json.objectMapperFactory", ObjectMapper.class);
        }
        catch (ServletException e) {
            throw new RuntimeException("Couldn't instantiate the default ObjectMapper", e);
        }
    }

    @Override
    public MessageSource getMessageSource() {
        return (MessageSource)this.getRuntimeInstance("stormpath.web.message.source");
    }

    @Override
    public Resolver<Locale> getLocaleResolver() {
        return (Resolver)this.getRuntimeInstance("stormpath.web.locale.resolver");
    }

    @Override
    public MessageContext getMessageContext() {
        MessageSource messageSource = this.getMessageSource();
        Resolver<Locale> localeResolver = this.getLocaleResolver();
        return new DefaultMessageContext(messageSource, localeResolver);
    }

    @Override
    public CsrfTokenManager getCsrfTokenManager() {
        return (CsrfTokenManager)this.getRuntimeInstance("stormpath.web.csrf.token.manager");
    }

    @Override
    public RequestFieldValueResolver getFieldValueResolver() {
        return (RequestFieldValueResolver)this.getRuntimeInstance("stormpath.web.form.fields.valueResolver");
    }

    @Override
    public AccountResolver getAccountResolver() {
        return (AccountResolver)this.getRuntimeInstance("stormpath.web.account.resolver");
    }

    @Override
    public ContentNegotiationResolver getContentNegotiationResolver() {
        return (ContentNegotiationResolver)this.getRuntimeInstance("stormpath.web.conneg.resolver");
    }

    @Override
    public ControllerConfig getLoginConfig() {
        return new ServletControllerConfig("login", this);
    }

    @Override
    public ControllerConfig getLogoutConfig() {
        return new ServletControllerConfig("logout", this);
    }

    @Override
    public ControllerConfig getRegisterConfig() {
        return new ServletControllerConfig("register", this);
    }

    @Override
    public ControllerConfig getForgotPasswordConfig() {
        return new ServletControllerConfig("forgotPassword", this);
    }

    @Override
    public ControllerConfig getVerifyConfig() {
        return new ServletControllerConfig("verifyEmail", this);
    }

    @Override
    public ControllerConfig getSamlConfig() {
        return new ServletControllerConfig("saml", this);
    }

    @Override
    public ChangePasswordConfig getChangePasswordConfig() {
        return new ChangePasswordServletControllerConfig(this, "changePassword");
    }

    @Override
    public Saver<AuthenticationResult> getAuthenticationResultSaver() {
        return (Saver)this.getRuntimeInstance("stormpath.web.authc.saver");
    }

    @Override
    public AccountStoreResolver getAccountStoreResolver() {
        return (AccountStoreResolver)this.getRuntimeInstance("stormpath.web.accountStoreResolver");
    }

    @Override
    public Publisher<RequestEvent> getRequestEventPublisher() {
        return (Publisher)this.getRuntimeInstance("stormpath.web.request.event.publisher");
    }

    @Override
    public FilterChainManager getFilterChainManager() {
        return (FilterChainManager)this.getRuntimeInstance("stormpath.web.filter.chain.manager");
    }

    @Override
    public FilterChainResolver getFilterChainResolver() {
        return (FilterChainResolver)this.getRuntimeInstance("stormpath.web.filter.chain.resolver");
    }

    @Override
    public boolean isStormpathEnabled() {
        String isEnabled = this.CFG.getString(STORMPATH_ENABLED);
        return isEnabled == null || this.CFG.getBoolean(STORMPATH_ENABLED);
    }

    @Override
    public boolean isStormpathWebEnabled() {
        String isWebEnabled = this.CFG.getString(STORMPATH_WEB_ENABLED);
        return isWebEnabled == null || this.CFG.getBoolean(STORMPATH_WEB_ENABLED);
    }

    @Override
    public boolean isRegisterAutoLoginEnabled() {
        return this.CFG.getBoolean("stormpath.web.register.autoLogin");
    }

    @Override
    public boolean isLogoutInvalidateHttpSession() {
        return this.CFG.getBoolean(LOGOUT_INVALIDATE_HTTP_SESSION);
    }

    @Override
    public String getAccessTokenUrl() {
        return this.CFG.getString(ACCESS_TOKEN_URL);
    }

    @Override
    public String getRevokeTokenUrl() {
        return this.CFG.getString(REVOKE_TOKEN_URL);
    }

    @Override
    public String getUnauthorizedUrl() {
        return this.CFG.getString(UNAUTHORIZED_URL);
    }

    @Override
    public boolean isMeEnabled() {
        return this.CFG.getBoolean(ME_ENABLED);
    }

    @Override
    public String getMeUrl() {
        return this.CFG.getString(ME_URL);
    }

    @Override
    public List<String> getMeExpandedProperties() {
        ArrayList<String> results = new ArrayList<String>();
        Pattern pattern = Pattern.compile("^stormpath\\.web\\.me\\.expand\\.(\\w+)$");
        for (String key : this.keySet()) {
            Matcher matcher = pattern.matcher(key);
            if (!matcher.find() || !this.CFG.getBoolean(key)) continue;
            results.add(matcher.group(1));
        }
        return results;
    }

    @Override
    public CookieConfig getRefreshTokenCookieConfig() {
        return this.REFRESH_TOKEN_COOKIE_CONFIG;
    }

    @Override
    public CookieConfig getAccessTokenCookieConfig() {
        return this.ACCESS_TOKEN_COOKIE_CONFIG;
    }

    @Override
    public String getAccessTokenValidationStrategy() {
        return this.CFG.getString(ACCESS_TOKEN_VALIDATION_STRATEGY);
    }

    @Override
    public WebHandler getLoginPreHandler() {
        return (WebHandler)this.getRuntimeInstance("stormpath.web.login.preHandler");
    }

    @Override
    public WebHandler getLoginPostHandler() {
        return (WebHandler)this.getRuntimeInstance("stormpath.web.login.postHandler");
    }

    @Override
    public WebHandler getRegisterPreHandler() {
        return (WebHandler)this.getRuntimeInstance("stormpath.web.register.preHandler");
    }

    @Override
    public WebHandler getRegisterPostHandler() {
        return (WebHandler)this.getRuntimeInstance("stormpath.web.register.postHandler");
    }

    @Override
    public Resolver<Boolean> getRegisterEnabledResolver() {
        String key = "stormpath.web.register.enabled.resolver";
        if (this.containsKey(key)) {
            try {
                return (Resolver)this.getInstance(key);
            }
            catch (ServletException e) {
                throw new RuntimeException("Couldn't instantiate stormpath.web.register.enabled.resolver", e);
            }
        }
        boolean enabled = this.CFG.getBoolean("stormpath.web.register.enabled");
        ApplicationResolver appResolver = this.getApplicationResolver();
        BiPredicate<Boolean, Application> regEnabledPredicate = this.getRegisterEnabledPredicate();
        RegisterEnabledResolver resolver = new RegisterEnabledResolver(enabled, appResolver, regEnabledPredicate);
        this.SINGLETONS.put(key, resolver);
        return resolver;
    }

    @Override
    public BiPredicate<Boolean, Application> getRegisterEnabledPredicate() {
        return (BiPredicate)this.getRuntimeInstance("stormpath.web.register.enabled.predicate");
    }

    private <T> T getRuntimeInstance(String classPropertyName) {
        try {
            return this.getInstance(classPropertyName);
        }
        catch (ServletException e) {
            throw new RuntimeException("Couldn't acquire instance for '" + classPropertyName + "': " + e.getMessage());
        }
    }

    @Override
    public <T> T getInstance(String classPropertyName) throws ServletException {
        Object instance = this.SINGLETONS.get(classPropertyName);
        if (instance == null) {
            instance = this.newInstance(classPropertyName);
            this.SINGLETONS.put(classPropertyName, instance);
        }
        return (T)instance;
    }

    public <T> T getInstance(String classPropertyName, Class<T> expectedType) throws ServletException {
        Assert.notNull(expectedType, (String)"expectedType argument cannot be null.");
        Object instance = this.SINGLETONS.get(classPropertyName);
        if (instance == null) {
            instance = this.newInstance(classPropertyName);
            this.SINGLETONS.put(classPropertyName, instance);
        }
        if (!expectedType.isInstance(instance)) {
            String msg = "Configured " + classPropertyName + " class name must be an instance of " + expectedType.getName();
            throw new ServletException(msg);
        }
        return (T)instance;
    }

    @Override
    public <T> Map<String, T> getInstances(String propertyNamePrefix, Class<T> expectedType) throws ServletException {
        Map<String, Class<T>> classes = new ImplementationClassResolver<T>(this, propertyNamePrefix, expectedType).findImplementationClasses();
        LinkedHashMap<String, T> instances = new LinkedHashMap<String, T>(classes.size());
        for (Map.Entry<String, Class<T>> entry : classes.entrySet()) {
            String name = entry.getKey();
            T instance = this.getInstance(propertyNamePrefix + name);
            Assert.isInstanceOf(expectedType, instance);
            instances.put(name, instance);
        }
        return instances;
    }

    @Override
    public String getProducesMediaTypes() {
        List mediaTypes = this.CFG.getList(PRODUCES_MEDIA_TYPES);
        return Strings.collectionToCommaDelimitedString((Collection)mediaTypes);
    }

    @Override
    public List<MediaType> getProducedMediaTypes() {
        String mediaTypes = Strings.clean((String)this.getProducesMediaTypes());
        Assert.notNull((Object)mediaTypes, (String)"stormpath.web.produces property value cannot be null or empty.");
        try {
            return MediaType.parseMediaTypes(mediaTypes);
        }
        catch (InvalidMediaTypeException e) {
            String msg = "Unable to parse value in stormpath.web.produces property: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }

    @Override
    public boolean isOAuthEnabled() {
        return this.CFG.getBoolean(OAUTH_ENABLED);
    }

    @Override
    public boolean isIdSiteEnabled() {
        return this.CFG.getBoolean(ID_SITE_ENABLED);
    }

    @Override
    public boolean isCallbackEnabled() {
        return this.CFG.getBoolean(CALLBACK_ENABLED);
    }

    @Override
    public String getCallbackUri() {
        return this.CFG.getString(CALLBACK_URI);
    }

    @Override
    public ServerUriResolver getServerUriResolver() {
        return (ServerUriResolver)this.getRuntimeInstance(SERVER_URI_RESOLVER);
    }

    protected <T> T newInstance(String classPropertyName) throws ServletException {
        Object instance;
        if (!this.containsKey(classPropertyName)) {
            String msg = "Unable to instantiate class: there is no configuration property named " + classPropertyName;
            throw new ServletException(msg);
        }
        String val = this.get(classPropertyName);
        Assert.hasText((String)val, (String)(classPropertyName + " class name value is required."));
        try {
            instance = Classes.newInstance((String)val);
        }
        catch (Exception e) {
            String msg = "Unable to instantiate " + classPropertyName + " class name " + val + ": " + e.getMessage();
            throw new ServletException(msg, (Throwable)e);
        }
        if (instance instanceof ServletContextInitializable) {
            try {
                ((ServletContextInitializable)instance).init(this.servletContext);
            }
            catch (Exception e) {
                String msg = "Unable to initialize " + classPropertyName + " instance of type " + val + ": " + e.getMessage();
                throw new ServletException(msg, (Throwable)e);
            }
        }
        try {
            if (instance instanceof Factory) {
                instance = ((Factory)instance).getInstance();
            }
        }
        catch (Exception e) {
            String msg = "Unable to obtain factory instance from factory " + instance + ": " + e.getMessage();
            throw new ServletException(msg);
        }
        return (T)instance;
    }

    @Override
    public int size() {
        return this.props.size();
    }

    @Override
    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.props.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.props.containsValue(o);
    }

    @Override
    public String get(Object o) {
        return this.props.get(o);
    }

    @Override
    public String put(String s, String s2) {
        return this.props.put(s, s2);
    }

    @Override
    public String remove(Object o) {
        return this.props.remove(o);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        this.props.putAll(map);
    }

    @Override
    public void clear() {
        this.props.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.props.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.props.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.props.entrySet();
    }

    @Override
    public String getWebApplicationDomain() {
        return this.CFG.getString(WEB_APPLICATION_DOMAIN);
    }

    @Override
    public Resolver<IdSiteOrganizationContext> getIdSiteOrganizationResolver() {
        return (Resolver)this.getRuntimeInstance(IDSITE_ORGANIZATION_RESOLVER_FACTORY);
    }

    @Override
    public List<String> getAllowedCorsOrigins() {
        String allowedOrigins = this.get(STORMPATH_WEB_CORS_ALLOWED_ORIGINS);
        if (Strings.hasText((String)allowedOrigins)) {
            return Arrays.asList(Strings.split((String)allowedOrigins));
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getAllowedCorsHaders() {
        String allowedHeaders = this.get(STORMPATH_WEB_CORS_ALLOWED_HEADERS);
        if (Strings.hasText((String)allowedHeaders)) {
            return Arrays.asList(Strings.split((String)allowedHeaders));
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getAllowedCorsMethods() {
        String allowedMethods = this.get(STORMPATH_WEB_CORS_ALLOWED_METHODS);
        if (Strings.hasText((String)allowedMethods)) {
            return Arrays.asList(Strings.split((String)allowedMethods));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isCorsEnabled() {
        return this.CFG.getBoolean(STORMPATH_WEB_CORS_ENABLED);
    }

    @Override
    public GrantTypeValidator getGrantTypeStatusValidator() {
        boolean clientCredentialsEnabled = this.CFG.getString(CLIENT_CREDENTIALS_GRANT_TYPE_ENABLED) == null || this.CFG.getBoolean(CLIENT_CREDENTIALS_GRANT_TYPE_ENABLED);
        boolean passwordEnabled = this.CFG.getString(PASSWORD_GRANT_TYPE_ENABLED) == null || this.CFG.getBoolean(PASSWORD_GRANT_TYPE_ENABLED);
        DefaultGrantTypeValidator validator = new DefaultGrantTypeValidator();
        validator.setClientCredentialsGrantTypeEnabled(clientCredentialsEnabled);
        validator.setPasswordGrantTypeEnabled(passwordEnabled);
        return validator;
    }
}

