/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.config.impl;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.config.impl.ConfigReader;
import com.stormpath.sdk.servlet.config.impl.DefaultConfig;
import com.stormpath.sdk.servlet.config.impl.EvaluationModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ExpressionConfigReader
implements ConfigReader {
    private static final SpelExpressionParser EXPR_PARSER = ExpressionConfigReader.createExpressionParser();
    private static final ParserContext PARSER_CONTEXT = new ParserContext(){

        public boolean isTemplate() {
            return true;
        }

        public String getExpressionPrefix() {
            return "${";
        }

        public String getExpressionSuffix() {
            return "}";
        }
    };
    private final Map<String, String> PROPS;
    private final StandardEvaluationContext EXPR_CONTEXT;

    private static SpelExpressionParser createExpressionParser() {
        SpelCompilerMode mode = SpelCompilerMode.MIXED;
        ClassLoader cl = DefaultConfig.class.getClassLoader();
        SpelParserConfiguration config = new SpelParserConfiguration(mode, cl);
        return new SpelExpressionParser(config);
    }

    public ExpressionConfigReader(ServletContext servletContext, Map<String, String> props) {
        Assert.notNull((Object)servletContext);
        Assert.notNull(props);
        this.PROPS = props;
        StandardEvaluationContext ctx = new StandardEvaluationContext();
        EvaluationModel model = new EvaluationModel(servletContext, props);
        ctx.setRootObject((Object)model);
        this.EXPR_CONTEXT = ctx;
    }

    @Override
    public String getString(String name) {
        String val = this.PROPS.get(name);
        if (this.isExpression(val)) {
            Expression exp = EXPR_PARSER.parseExpression(val, PARSER_CONTEXT);
            Object o = exp.getValue((EvaluationContext)this.EXPR_CONTEXT);
            return o != null ? String.valueOf(o) : null;
        }
        return val;
    }

    @Override
    public int getInt(String name) {
        String val = this.PROPS.get(name);
        try {
            if (this.isExpression(val)) {
                Expression exp = EXPR_PARSER.parseExpression(val, PARSER_CONTEXT);
                Object o = exp.getValue((EvaluationContext)this.EXPR_CONTEXT);
                if (o instanceof Integer) {
                    return (Integer)o;
                }
                if (o instanceof Long) {
                    return ((Long)o).intValue();
                }
                throw new IllegalArgumentException("The " + name + " property expression must evaluate to an integer.");
            }
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(name + " value must be an integer.", e);
        }
    }

    @Override
    public long getLong(String name) {
        String val = this.PROPS.get(name);
        try {
            if (this.isExpression(val)) {
                Expression exp = EXPR_PARSER.parseExpression(val, PARSER_CONTEXT);
                Object o = exp.getValue((EvaluationContext)this.EXPR_CONTEXT);
                if (o instanceof Long) {
                    return (Long)o;
                }
                if (o instanceof Integer) {
                    return ((Integer)o).longValue();
                }
                throw new IllegalArgumentException("The " + name + " property expression must evaluate to a long.");
            }
            return Long.parseLong(val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(name + " value must be an long.", e);
        }
    }

    @Override
    public boolean getBoolean(String name) {
        String val = this.PROPS.get(name);
        try {
            if (this.isExpression(val)) {
                Expression exp = EXPR_PARSER.parseExpression(val, PARSER_CONTEXT);
                Object o = exp.getValue((EvaluationContext)this.EXPR_CONTEXT);
                if (!(o instanceof Boolean)) {
                    String msg = "The " + name + " property expression must evaluate to a boolean.";
                    throw new IllegalArgumentException(msg);
                }
                return (Boolean)o;
            }
            return Boolean.parseBoolean(val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(name + " value must be a boolean.", e);
        }
    }

    @Override
    public List<String> getList(String name) {
        String val = this.PROPS.get(name);
        if (val == null) {
            return Collections.EMPTY_LIST;
        }
        String[] items = val.split(",");
        ArrayList<String> list = new ArrayList<String>(items.length);
        for (String item : items) {
            list.add(item.trim());
        }
        return list;
    }

    private boolean isExpression(String val) {
        return val != null && val.contains(PARSER_CONTEXT.getExpressionPrefix()) && val.contains(PARSER_CONTEXT.getExpressionSuffix());
    }
}

