/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.csrf;

import com.stormpath.sdk.cache.Cache;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.csrf.CsrfTokenManager;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCsrfTokenManager
implements CsrfTokenManager {
    private static final String DEFAULT_CSRF_TOKEN_NAME = "csrfToken";
    private static final Logger log = LoggerFactory.getLogger(DefaultCsrfTokenManager.class);
    private final Cache<String, String> nonceCache;
    private final String signingKey;
    private final long ttlMillis;
    private final String tokenName;

    public DefaultCsrfTokenManager(String tokenName, Cache<String, String> nonceCache, String signingKey, long ttlMillis) {
        Assert.notNull(nonceCache, (String)"nonce cache cannot be null.");
        this.nonceCache = nonceCache;
        Assert.hasText((String)signingKey, (String)"signingKey cannot be null or empty.");
        this.signingKey = signingKey;
        Assert.isTrue((ttlMillis > 0L ? 1 : 0) != 0, (String)"ttlMillis must be greater than zero.");
        this.ttlMillis = ttlMillis;
        this.tokenName = Strings.hasText((String)tokenName) ? tokenName : DEFAULT_CSRF_TOKEN_NAME;
    }

    @Override
    public String getTokenName() {
        return this.tokenName;
    }

    @Override
    public String createCsrfToken(HttpServletRequest request, HttpServletResponse response) {
        String id = UUID.randomUUID().toString().replace("-", "");
        Date now = new Date();
        Date exp = new Date(System.currentTimeMillis() + this.ttlMillis);
        return Jwts.builder().setId(id).setIssuedAt(now).setNotBefore(now).setExpiration(exp).signWith(SignatureAlgorithm.HS256, this.signingKey).compact();
    }

    protected Client getClient(HttpServletRequest request) {
        Client client = (Client)request.getAttribute(Client.class.getName());
        Assert.notNull((Object)client, (String)"Client must be present as a request attribute.");
        return client;
    }

    @Override
    public boolean isValidCsrfToken(HttpServletRequest request, HttpServletResponse response, String csrfToken) {
        if (csrfToken == null) {
            return false;
        }
        try {
            Jws jws = Jwts.parser().setSigningKey(this.signingKey).parseClaimsJws(csrfToken);
            String id = ((Claims)jws.getBody()).getId();
            String usedNonce = (String)this.nonceCache.get((Object)id);
            if (usedNonce == null) {
                this.nonceCache.put((Object)id, (Object)csrfToken);
                return true;
            }
        }
        catch (Exception e) {
            log.debug("CSRF token is invalid (this is likely to happen and not an error condition).", (Throwable)e);
        }
        return false;
    }
}

