/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.event;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.error.Error;
import com.stormpath.sdk.oauth.OAuthRequests;
import com.stormpath.sdk.oauth.OAuthRevocationRequest;
import com.stormpath.sdk.oauth.OAuthTokenRevocators;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.servlet.account.event.RegisteredAccountRequestEvent;
import com.stormpath.sdk.servlet.account.event.VerifiedAccountRequestEvent;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.authc.FailedAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.authc.LogoutRequestEvent;
import com.stormpath.sdk.servlet.authc.SuccessfulAuthenticationRequestEvent;
import com.stormpath.sdk.servlet.event.RequestEventListener;
import com.stormpath.sdk.servlet.http.CookieResolver;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.rs.extractor.BearerHeaderTokenExtractor;
import org.apache.oltu.oauth2.rs.extractor.TokenExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRevocationRequestEventListener
implements RequestEventListener {
    private static final Logger log = LoggerFactory.getLogger(TokenRevocationRequestEventListener.class);
    private final TokenExtractor tokenExtractor = new BearerHeaderTokenExtractor();
    private final CookieResolver accessTokenCookieResolver = new CookieResolver("access_token");
    protected ApplicationResolver applicationResolver = ApplicationResolver.INSTANCE;

    @Override
    public void on(SuccessfulAuthenticationRequestEvent event) {
    }

    @Override
    public void on(FailedAuthenticationRequestEvent event) {
    }

    @Override
    public void on(RegisteredAccountRequestEvent event) {
    }

    @Override
    public void on(VerifiedAccountRequestEvent event) {
    }

    @Override
    public void on(LogoutRequestEvent event) {
        String jwt = this.getJwtFromLogoutRequestEvent(event);
        HttpServletRequest request = event.getRequest();
        Application application = this.applicationResolver.getApplication((ServletRequest)request);
        if (application != null && jwt != null) {
            try {
                OAuthRevocationRequest revocationRequest = OAuthRequests.OAUTH_TOKEN_REVOCATION_REQUEST.builder().setToken(jwt).build();
                OAuthTokenRevocators.OAUTH_TOKEN_REVOCATOR.forApplication(application).revoke(revocationRequest);
            }
            catch (ResourceException e) {
                Error error = e.getStormpathError();
                String message = error.getMessage();
                log.warn("There was an error trying to revoke a token", (Object)message);
            }
        }
    }

    protected String getJwtFromLogoutRequestEvent(LogoutRequestEvent event) {
        String jwt = this.tokenExtractor.getAccessToken(event.getRequest());
        if (jwt == null && this.accessTokenCookieResolver.get(event.getRequest(), null) != null) {
            jwt = this.accessTokenCookieResolver.get(event.getRequest(), null).getValue();
        }
        return jwt;
    }
}

