/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.filter.DefaultFilterConfig;
import com.stormpath.sdk.servlet.filter.FilterBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class DefaultFilterBuilder
implements FilterBuilder {
    private static final String PATH_CONFIG_INIT_PARAM_NAME = "pathConfig";
    private Class<? extends Filter> filterClass;
    private Filter instance;
    private ServletContext servletContext;
    private String name;
    private final Map<String, String> initParams = new LinkedHashMap<String, String>();

    @Override
    public FilterBuilder setFilterClass(Class<? extends Filter> filterClass) {
        this.filterClass = filterClass;
        return this;
    }

    @Override
    public FilterBuilder setFilter(Filter filter) {
        this.instance = filter;
        return this;
    }

    @Override
    public FilterBuilder setServletContext(ServletContext sc) {
        this.servletContext = sc;
        return this;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public FilterBuilder setName(String name) {
        this.name = Strings.clean((String)name);
        return this;
    }

    @Override
    public FilterBuilder setInitParam(String name, String value) {
        name = Strings.clean((String)name);
        Assert.notNull((Object)name, (String)"name argument cannot be null or empty.");
        value = Strings.clean((String)value);
        if (value == null) {
            this.initParams.remove(name);
        } else {
            this.initParams.put(name, value);
        }
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FilterBuilder setPathConfig(String pathConfig) {
        this.setInitParam(PATH_CONFIG_INIT_PARAM_NAME, pathConfig);
        return this;
    }

    @Override
    public String getPathConfig() {
        return this.initParams.get(PATH_CONFIG_INIT_PARAM_NAME);
    }

    @Override
    public Filter build() throws ServletException {
        Assert.isTrue((this.instance != null || this.filterClass != null ? 1 : 0) != 0, (String)"Either a filter instance or a filterClass must be specified.");
        Assert.notNull((Object)this.servletContext, (String)"servletContext must be specified.");
        Assert.notNull((Object)this.name, (String)"A non-null/non-empty name must be specified.");
        Filter filter = this.instance != null ? this.instance : (Filter)Classes.newInstance(this.filterClass);
        DefaultFilterConfig filterConfig = new DefaultFilterConfig(this.servletContext, this.name, this.initParams);
        filter.init((FilterConfig)filterConfig);
        return filter;
    }
}

