/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.ConfigResolver;
import com.stormpath.sdk.servlet.filter.LoginPageRedirector;
import com.stormpath.sdk.servlet.util.ServletUtils;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultLoginPageRedirector
implements LoginPageRedirector {
    private String loginUri;

    public DefaultLoginPageRedirector() {
    }

    public DefaultLoginPageRedirector(String loginUri) {
        Assert.hasText((String)loginUri, (String)"loginUri cannot be null or empty.");
        this.loginUri = loginUri;
    }

    @Override
    public void redirectToLoginPage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.loginUri == null) {
            Config config = ConfigResolver.INSTANCE.getConfig(request.getServletContext());
            this.loginUri = config.getLoginConfig().getUri();
        }
        String method = request.getMethod();
        String nextUri = this.loginUri;
        if (method.equalsIgnoreCase("GET")) {
            String requestURI = request.getServletPath() + (Strings.hasText((String)request.getQueryString()) ? "?" + request.getQueryString() : "");
            String encodedCurrentUrlString = URLEncoder.encode(requestURI, "UTF-8");
            nextUri = nextUri + "?next=" + encodedCurrentUrlString;
        }
        ServletUtils.issueRedirect(request, response, nextUri, null, true, true);
    }
}

