/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.servlet.filter.ServerUriResolver;
import javax.servlet.http.HttpServletRequest;

public class DefaultServerUriResolver
implements ServerUriResolver {
    private boolean excludeSchemeDefaultPorts = true;

    public boolean isExcludeSchemeDefaultPorts() {
        return this.excludeSchemeDefaultPorts;
    }

    public void setExcludeSchemeDefaultPorts(boolean excludeSchemeDefaultPorts) {
        this.excludeSchemeDefaultPorts = excludeSchemeDefaultPorts;
    }

    @Override
    public String getServerUri(HttpServletRequest request) {
        boolean includePort;
        StringBuilder sb = new StringBuilder();
        String scheme = request.getScheme();
        sb.append(scheme).append("://");
        String host = request.getHeader("Host");
        if (host == null) {
            host = request.getServerName();
        }
        String port = null;
        int i = host.lastIndexOf(58);
        if (i > -1) {
            port = host.substring(i + 1);
            host = host.substring(0, i);
        }
        sb.append(host);
        boolean bl = includePort = port != null;
        if (includePort && this.isExcludeSchemeDefaultPorts() && (scheme.equalsIgnoreCase("http") && "80".equals(port) || scheme.equalsIgnoreCase("https") && "443".equals(port))) {
            includePort = false;
        }
        if (includePort) {
            sb.append(':').append(port);
        }
        return sb.toString();
    }
}

