/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.filter.LoginPageRedirector;
import com.stormpath.sdk.servlet.filter.UnauthenticatedHandler;
import com.stormpath.sdk.servlet.http.UserAgent;
import com.stormpath.sdk.servlet.http.UserAgents;
import com.stormpath.sdk.servlet.http.authc.HeaderAuthenticator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultUnauthenticatedHandler
implements UnauthenticatedHandler {
    private HeaderAuthenticator httpAuthenticator;

    public DefaultUnauthenticatedHandler(HeaderAuthenticator httpAuthenticator) {
        Assert.notNull((Object)httpAuthenticator, (String)"HttpAuthenticator cannot be null.");
        this.httpAuthenticator = httpAuthenticator;
    }

    @Override
    public boolean onAuthenticationRequired(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setHeader("Cache-Control", "no-store, no-cache");
        response.setHeader("Pragma", "no-cache");
        if (this.isHtmlPreferred(request)) {
            LoginPageRedirector.INSTANCE.redirectToLoginPage(request, response);
        } else {
            this.httpAuthenticator.sendChallenge(request, response);
        }
        return false;
    }

    protected boolean isHtmlPreferred(HttpServletRequest request) {
        UserAgent ua = this.getUserAgent(request);
        return ua.isHtmlPreferred();
    }

    protected UserAgent getUserAgent(HttpServletRequest request) {
        return UserAgents.get(request);
    }
}

