/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.filter.UnauthorizedHandler;
import com.stormpath.sdk.servlet.http.UserAgent;
import com.stormpath.sdk.servlet.http.UserAgents;
import com.stormpath.sdk.servlet.util.ServletUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultUnauthorizedHandler
implements UnauthorizedHandler {
    private final String unauthorizedUrl;

    public DefaultUnauthorizedHandler(String unauthorizedUrl) {
        Assert.hasText((String)unauthorizedUrl, (String)"unauthorizedUrl cannot be null or empty.");
        this.unauthorizedUrl = unauthorizedUrl;
    }

    protected String getUnauthorizedUrl() {
        return this.unauthorizedUrl;
    }

    @Override
    public boolean onUnauthorized(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.isHtmlPreferred(request)) {
            String url = this.getUnauthorizedUrl();
            try {
                ServletUtils.issueRedirect(request, response, url, null, true, true);
            }
            catch (IOException e) {
                String msg = "Unable to issue unauthorized redirect: " + e.getMessage();
                throw new ServletException(msg, (Throwable)e);
            }
        } else {
            response.setStatus(403);
            response.setHeader("Cache-Control", "no-store, no-cache");
            response.setHeader("Pragma", "no-cache");
        }
        return false;
    }

    protected boolean isHtmlPreferred(HttpServletRequest request) {
        UserAgent userAgent = this.getUserAgent(request);
        return userAgent.isHtmlPreferred();
    }

    protected UserAgent getUserAgent(HttpServletRequest request) {
        return UserAgents.get(request);
    }
}

