/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.lang.Assert;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(HttpFilter.class);
    public static final String ALREADY_FILTERED_SUFFIX = ".FILTERED";
    private FilterConfig filterConfig;
    private ServletContext servletContext;
    private String name;
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.servletContext = filterConfig.getServletContext();
        this.name = filterConfig.getFilterName();
        try {
            this.onInit();
        }
        catch (Exception e) {
            String msg = "Unable to initialize '" + this.name + "' filter of type " + this.getClass().getName() + ": " + e.getMessage();
            throw new ServletException(msg, (Throwable)e);
        }
    }

    protected void onInit() throws Exception {
    }

    protected boolean isEnabled(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return true;
    }

    protected boolean isContinue(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return true;
    }

    protected String getFilteredAttributeName() {
        String name = this.getName();
        if (name == null) {
            name = this.getClass().getName();
        }
        return name + ALREADY_FILTERED_SUFFIX;
    }

    public final void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws ServletException, IOException {
        Assert.isInstanceOf(HttpServletRequest.class, (Object)req, (String)"Only HTTP requests are supported.");
        Assert.isInstanceOf(HttpServletResponse.class, (Object)resp, (String)"Only HTTP responses are supported.");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String alreadyFilteredAttributeName = this.getFilteredAttributeName();
        if (request.getAttribute(alreadyFilteredAttributeName) != null) {
            log.trace("Filter '{}' already executed.  Proceeding without invoking this filter.", (Object)this.getName());
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            log.trace("Filter '{}' not yet executed.  Executing now.", (Object)this.getName());
            request.setAttribute(alreadyFilteredAttributeName, (Object)Boolean.TRUE);
            try {
                if (this.isEnabled() && this.isEnabled(request, response)) {
                    if (this.isContinue(request, response)) {
                        log.trace("Filter '{}' is enabled and will filter the request.", (Object)this.name);
                        this.filter(request, response, chain);
                    } else {
                        String msg = "Filter '{}' has stopped chain execution and rendered the response directly.";
                        log.debug(msg, (Object)this.name);
                    }
                } else {
                    log.debug("Filter '{}' is not enabled. Continuing filter chain immediately.", (Object)this.name);
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (ServletException se) {
                throw se;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                String msg = "Filtered request resulted in an exception: " + e.getMessage();
                throw new ServletException(msg, (Throwable)e);
            }
            finally {
                request.removeAttribute(alreadyFilteredAttributeName);
            }
        }
    }

    protected void filter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws Exception {
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

