/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.servlet.filter.DefaultFilterChainManager;
import com.stormpath.sdk.servlet.filter.FilterChainManager;
import com.stormpath.sdk.servlet.filter.FilterChainResolver;
import com.stormpath.sdk.servlet.util.AntPathMatcher;
import com.stormpath.sdk.servlet.util.PatternMatcher;
import com.stormpath.sdk.servlet.util.ServletUtils;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathMatchingFilterChainResolver
implements FilterChainResolver {
    private static final transient Logger log = LoggerFactory.getLogger(PathMatchingFilterChainResolver.class);
    private FilterChainManager filterChainManager;
    private PatternMatcher pathMatcher = new AntPathMatcher();

    public PathMatchingFilterChainResolver(ServletContext servletContext) {
        this.filterChainManager = new DefaultFilterChainManager(servletContext);
    }

    public PatternMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setPathMatcher(PatternMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public FilterChainManager getFilterChainManager() {
        return this.filterChainManager;
    }

    public void setFilterChainManager(FilterChainManager filterChainManager) {
        this.filterChainManager = filterChainManager;
    }

    @Override
    public FilterChain getChain(HttpServletRequest request, HttpServletResponse response, FilterChain originalChain) {
        FilterChainManager filterChainManager = this.getFilterChainManager();
        if (!filterChainManager.hasChains()) {
            return originalChain;
        }
        String requestUri = this.getContextRelativeUri(request);
        for (String pathPattern : filterChainManager.getChainNames()) {
            if (!this.pathMatches(pathPattern, requestUri)) continue;
            if (log.isTraceEnabled()) {
                log.trace("Matched path pattern [" + pathPattern + "] for requestUri [" + requestUri + "].  Utilizing corresponding filter chain...");
            }
            return filterChainManager.proxy(originalChain, pathPattern);
        }
        return originalChain;
    }

    protected boolean pathMatches(String pattern, String path) {
        PatternMatcher pathMatcher = this.getPathMatcher();
        return pathMatcher.matches(pattern, path);
    }

    protected String getContextRelativeUri(HttpServletRequest request) {
        return ServletUtils.getContextRelativeUri(request);
    }
}

