/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.servlet.filter.FilterChainResolver;
import com.stormpath.sdk.servlet.filter.ProxiedFilterChain;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PrioritizedFilterChainResolver
implements FilterChainResolver {
    private final FilterChainResolver delegate;
    private final List<Filter> priorityFilters;

    public PrioritizedFilterChainResolver(FilterChainResolver delegate, List<Filter> priorityFilters) {
        Assert.notNull((Object)delegate, (String)"Delegate FilterChainResolver cannot be null.");
        this.delegate = delegate;
        this.priorityFilters = priorityFilters;
    }

    @Override
    public FilterChain getChain(HttpServletRequest request, HttpServletResponse response, FilterChain chain) {
        FilterChain target = this.delegate.getChain(request, response, chain);
        if (target == null) {
            target = chain;
        }
        if (Collections.isEmpty(this.priorityFilters)) {
            return target;
        }
        return new ProxiedFilterChain(target, this.priorityFilters);
    }
}

