/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.mvc.AbstractControllerConfig;
import java.util.HashSet;
import java.util.Set;

public class ServletControllerConfig
extends AbstractControllerConfig {
    private final String view;
    private final String uri;
    private final String nextUri;
    private final boolean enabled;

    public ServletControllerConfig(String controllerKey, final Config config) {
        super(controllerKey);
        Assert.notNull((Object)config, (String)"config cannot be null.");
        this.setPropertyResolver(new AbstractControllerConfig.AbstractPropertyResolver(){

            @Override
            public String getValue(String key) {
                return (String)config.get(key);
            }

            @Override
            public Set<String> getKeys(String prefix) {
                HashSet<String> keys = new HashSet<String>();
                for (String key : config.keySet()) {
                    if (key == null || !key.startsWith(prefix)) continue;
                    keys.add(key);
                }
                return keys;
            }
        });
        super.init();
        this.view = this.getControllerPropertyValue("view");
        this.uri = this.getControllerPropertyValue("uri");
        this.nextUri = this.getControllerPropertyValue("nextUri");
        String val = this.getControllerPropertyValue("enabled");
        this.enabled = val == null || Boolean.parseBoolean(val);
    }

    protected String getControllerPropertyValue(String propName) {
        String key = this.getConfigPrefix() + "." + propName;
        return this.getPropertyResolver().getValue(key);
    }

    @Override
    public String getView() {
        return this.view;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getNextUri() {
        return this.nextUri;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

