/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountStatus;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.account.DefaultAccountResolver;
import com.stormpath.sdk.servlet.filter.HttpFilter;
import com.stormpath.sdk.servlet.http.Resolver;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AccountResolverFilter
extends HttpFilter {
    private List<Resolver<Account>> resolvers;
    private String oauthEndpointUri;

    public List<Resolver<Account>> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(List<Resolver<Account>> resolvers) {
        this.resolvers = resolvers;
    }

    public void setOauthEndpointUri(String oauthEndpointUri) {
        this.oauthEndpointUri = oauthEndpointUri;
    }

    @Override
    protected void onInit() throws Exception {
        Assert.notEmpty(this.resolvers, (String)"resolvers cannot be null or empty.");
        Assert.hasText((String)this.oauthEndpointUri, (String)"oauthEndpointUri cannot be null or empty.");
    }

    @Override
    protected boolean isEnabled(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return !request.getServletPath().contains(this.oauthEndpointUri);
    }

    @Override
    protected void filter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws Exception {
        for (Resolver<Account> resolver : this.getResolvers()) {
            Account account = resolver.get(request, response);
            if (response.isCommitted()) {
                return;
            }
            if (account == null || !AccountStatus.ENABLED.equals((Object)account.getStatus())) continue;
            request.setAttribute(DefaultAccountResolver.REQUEST_ATTR_NAME, (Object)account);
            request.setAttribute("account", (Object)account);
            String authType = request.getAuthType();
            Assert.hasText((String)authType, (String)"Account Resolver must set a request authType value.");
            break;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

