/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.idsite.IdSiteResultStatus;
import com.stormpath.sdk.impl.jwt.JwtWrapper;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationException;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationResult;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationHeaderAccountResolver
implements Resolver<Account> {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationHeaderAccountResolver.class);
    private HttpAuthenticator httpAuthenticator;
    protected final String idSiteResultURI;

    public AuthorizationHeaderAccountResolver(HttpAuthenticator authenticator, String idSiteResultURI) {
        Assert.notNull((Object)authenticator, (String)"HttpAuthenticator argument cannot be null.");
        Assert.notNull((Object)idSiteResultURI, (String)"idSiteResultURI argument cannot be null.");
        this.httpAuthenticator = authenticator;
        this.idSiteResultURI = idSiteResultURI;
    }

    @Override
    public Account get(HttpServletRequest request, HttpServletResponse response) {
        String authzHeaderValue = request.getHeader("Authorization");
        if (authzHeaderValue != null) {
            JwtWrapper jwtWrapper;
            Map jsonPayload;
            IdSiteResultStatus resultStatus;
            if (request.getRequestURI().contains(this.idSiteResultURI) && (resultStatus = IdSiteResultStatus.valueOf((String)((String)(jsonPayload = (jwtWrapper = new JwtWrapper(request.getParameter("jwtResponse"))).getJsonPayloadAsMap()).get("status")))).equals((Object)IdSiteResultStatus.LOGOUT)) {
                return null;
            }
            try {
                HttpAuthenticationResult result = this.httpAuthenticator.authenticate(request, response);
                return result.getAuthenticationResult().getAccount();
            }
            catch (HttpAuthenticationException e) {
                if (log.isDebugEnabled()) {
                    String msg = "Unable to authenticate HTTP request Authorization header: " + e.getMessage();
                    msg = msg + " The header will be ignored and not be used to identify a request account.";
                    log.debug(msg, (Throwable)e);
                }
                request.setAttribute(HttpAuthenticationException.class.getName(), (Object)e);
            }
        }
        return null;
    }
}

