/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.oauth.AccessTokenResult;
import com.stormpath.sdk.oauth.Authenticators;
import com.stormpath.sdk.oauth.IdSiteAuthenticationRequest;
import com.stormpath.sdk.oauth.IdSiteAuthenticationRequestBuilder;
import com.stormpath.sdk.oauth.IdSiteAuthenticator;
import com.stormpath.sdk.oauth.OAuthGrantRequestAuthenticationResult;
import com.stormpath.sdk.oauth.OAuthRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthRequests;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.authc.impl.TransientAuthenticationResult;
import com.stormpath.sdk.servlet.client.ClientResolver;
import com.stormpath.sdk.servlet.config.CookieConfig;
import com.stormpath.sdk.servlet.filter.account.InsecureCookieException;
import com.stormpath.sdk.servlet.http.CookieSaver;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.http.Saver;
import com.stormpath.sdk.servlet.util.SecureRequiredExceptForLocalhostResolver;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieAuthenticationResultSaver
implements Saver<AuthenticationResult> {
    private static final Logger log = LoggerFactory.getLogger(CookieAuthenticationResultSaver.class);
    private static final int DEFAULT_COOKIE_MAX_AGE = 259200;
    private Resolver<Boolean> secureCookieRequired;
    private boolean secureWarned = false;
    private final CookieConfig accessTokenCookieConfig;
    private final CookieConfig refreshTokenCookieConfig;

    public CookieAuthenticationResultSaver(CookieConfig accessTokenCookieConfig, CookieConfig refreshTokenCookieConfig, Resolver<Boolean> secureCookieRequired) {
        Assert.notNull((Object)accessTokenCookieConfig, (String)"accessTokenCookieConfig cannot be null.");
        Assert.notNull((Object)refreshTokenCookieConfig, (String)"refreshTokenCookieConfig cannot be null.");
        Assert.notNull(secureCookieRequired, (String)"secureCookieRequired cannot be null.");
        this.accessTokenCookieConfig = accessTokenCookieConfig;
        this.refreshTokenCookieConfig = refreshTokenCookieConfig;
        this.secureCookieRequired = secureCookieRequired;
    }

    @Override
    public void set(HttpServletRequest request, HttpServletResponse response, AuthenticationResult value) {
        Client client = ClientResolver.INSTANCE.getClient((ServletRequest)request);
        byte[] clientSecret = client.getApiKey().getSecret().getBytes();
        if (value == null) {
            this.remove(request, response);
            return;
        }
        if (value instanceof AccessTokenResult) {
            AccessTokenResult accessTokenResult = (AccessTokenResult)value;
            String accessToken = accessTokenResult.getTokenResponse().getAccessToken();
            String refreshToken = accessTokenResult.getTokenResponse().getRefreshToken();
            this.getAccessTokenCookieSaver(request, this.getMaxAge(accessToken, clientSecret, this.accessTokenCookieConfig)).set(request, response, accessToken);
            if (Strings.hasText((String)refreshToken)) {
                this.getRefreshTokenCookieSaver(request, this.getMaxAge(refreshToken, clientSecret, this.refreshTokenCookieConfig)).set(request, response, refreshToken);
            }
        }
        if (value instanceof TransientAuthenticationResult) {
            Account account = value.getAccount();
            Application application = ApplicationResolver.INSTANCE.getApplication((ServletRequest)request);
            try {
                String jwt = Jwts.builder().setHeaderParam("kid", (Object)client.getApiKey().getId()).setSubject(account.getHref()).setIssuedAt(new Date()).setIssuer(application.getHref()).setAudience(client.getApiKey().getId()).setExpiration(DateTime.now().plusMinutes(1).toDate()).claim("status", (Object)"AUTHENTICATED").signWith(SignatureAlgorithm.HS256, client.getApiKey().getSecret().getBytes("UTF-8")).compact();
                IdSiteAuthenticationRequest authenticationRequest = ((IdSiteAuthenticationRequestBuilder)OAuthRequests.IDSITE_AUTHENTICATION_REQUEST.builder()).setToken(jwt).build();
                OAuthGrantRequestAuthenticationResult authenticationResult = (OAuthGrantRequestAuthenticationResult)((IdSiteAuthenticator)Authenticators.ID_SITE_AUTHENTICATOR.forApplication(application)).authenticate((OAuthRequestAuthentication)authenticationRequest);
                String accessToken = authenticationResult.getAccessTokenString();
                String refreshToken = authenticationResult.getRefreshTokenString();
                this.getAccessTokenCookieSaver(request, this.getMaxAge(accessToken, clientSecret, this.accessTokenCookieConfig)).set(request, response, accessToken);
                this.getRefreshTokenCookieSaver(request, this.getMaxAge(refreshToken, clientSecret, this.refreshTokenCookieConfig)).set(request, response, refreshToken);
            }
            catch (UnsupportedEncodingException e) {
                log.error("Error get the client API Secret", (Throwable)e);
            }
        }
    }

    protected void remove(HttpServletRequest request, HttpServletResponse response) {
        this.getAccessTokenCookieSaver(request, -1).set(request, response, null);
        this.getRefreshTokenCookieSaver(request, -1).set(request, response, null);
    }

    protected boolean isCookieSecure(HttpServletRequest request, CookieConfig config) {
        boolean isSecure;
        boolean warnable;
        boolean configSecure = config.isSecure();
        Resolver<Boolean> resolver = this.secureCookieRequired;
        boolean resolverSecure = resolver.get(request, null);
        boolean likelyLocalhost = resolver instanceof SecureRequiredExceptForLocalhostResolver;
        boolean bl = warnable = !configSecure || !resolverSecure && !likelyLocalhost;
        if (!this.secureWarned && warnable) {
            this.secureWarned = true;
            String msg = "INSECURE IDENTITY COOKIE CONFIGURATION: Your current Stormpath SDK account cookie configuration allows insecure identity cookies (transmission over non-HTTPS connections)!  This should typically never occur otherwise your users will be susceptible to man-in-the-middle attacks.  For more information in Servlet-only environments, please see the Security Notice here: https://docs.stormpath.com/java/servlet-plugin/login.html#https-required and the documentation on authentication state here: https://docs.stormpath.com/java/servlet-plugin/login.html#authentication-state and here: https://docs.stormpath.com/java/servlet-plugin/login.html#cookie-config (the callout entitled 'Secure Cookies').  If you are using Spring Boot, Spring Boot-specific documentation for these concepts are here: https://docs.stormpath.com/java/spring-boot-web/login.html#security-notice https://docs.stormpath.com/java/spring-boot-web/login.html#authentication-state and https://docs.stormpath.com/java/spring-boot-web/login.html#cookie-storage";
            log.warn(msg);
        }
        boolean bl2 = isSecure = configSecure && resolverSecure;
        if ("http".equals(request.getScheme()) && isSecure) {
            String msg = "INSECURE IDENTITY COOKIE RUNTIME: Your current Stormpath SDK cookie config doesn't allow insecure identity cookies (transmission over non-HTTPS connections)! This should typically never occur otherwise your users will be susceptible to man-in-the-middle attacks.For more information in Servlet-only environments, please see the Security Notice here: https://docs.stormpath.com/java/servlet-plugin/login.html#https-required and the documentation on authentication state here: https://docs.stormpath.com/java/servlet-plugin/login.html#authentication-state and here: https://docs.stormpath.com/java/servlet-plugin/login.html#cookie-config (the callout entitled 'Secure Cookies').  If you are using Spring Boot, Spring Boot-specific documentation for these concepts are here: https://docs.stormpath.com/java/spring-boot-web/login.html#security-notice https://docs.stormpath.com/java/spring-boot-web/login.html#authentication-state and https://docs.stormpath.com/java/spring-boot-web/login.html#cookie-storage";
            log.error(msg);
            throw new InsecureCookieException("Authentication error");
        }
        return isSecure;
    }

    private CookieSaver getRefreshTokenCookieSaver(HttpServletRequest request, int maxAge) {
        return this.getCookieSaver(this.refreshTokenCookieConfig, request, maxAge);
    }

    private CookieSaver getAccessTokenCookieSaver(HttpServletRequest request, int maxAge) {
        return this.getCookieSaver(this.accessTokenCookieConfig, request, maxAge);
    }

    private CookieSaver getCookieSaver(final CookieConfig cookieConfig, HttpServletRequest request, final int maxAge) {
        final boolean secure = this.isCookieSecure(request, cookieConfig);
        String path = Strings.clean((String)cookieConfig.getPath());
        if (!Strings.hasText((String)path)) {
            path = Strings.clean((String)request.getContextPath());
        }
        if (!Strings.hasText((String)path)) {
            path = "/";
        }
        final String PATH = path;
        return new CookieSaver(new CookieConfig(){

            @Override
            public String getName() {
                return cookieConfig.getName();
            }

            @Override
            public String getComment() {
                return cookieConfig.getComment();
            }

            @Override
            public String getDomain() {
                return cookieConfig.getDomain();
            }

            @Override
            public int getMaxAge() {
                return maxAge;
            }

            @Override
            public String getPath() {
                return PATH;
            }

            @Override
            public boolean isSecure() {
                return secure;
            }

            @Override
            public boolean isHttpOnly() {
                return cookieConfig.isHttpOnly();
            }
        });
    }

    private int getMaxAge(String token, byte[] clientSecret, CookieConfig cookieConfig) {
        if (cookieConfig.getMaxAge() != 0) {
            return cookieConfig.getMaxAge();
        }
        Jws claimsJws = Jwts.parser().setSigningKey(clientSecret).parseClaimsJws(token);
        DateTime issueAt = new DateTime((Object)((Claims)claimsJws.getBody()).getIssuedAt());
        DateTime expiration = new DateTime((Object)((Claims)claimsJws.getBody()).getExpiration());
        return Seconds.secondsBetween((ReadableInstant)issueAt, (ReadableInstant)expiration).getSeconds() - Seconds.secondsBetween((ReadableInstant)issueAt, (ReadableInstant)DateTime.now()).getSeconds();
    }
}

