/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.account.config;

import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.ConfigSingletonFactory;
import com.stormpath.sdk.servlet.filter.account.AuthenticationResultSaver;
import com.stormpath.sdk.servlet.http.Saver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;

public class AuthenticationResultSaverFactory
extends ConfigSingletonFactory<AuthenticationResultSaver> {
    public static final String ACCOUNT_SAVER_LOCATIONS = "stormpath.web.authc.savers";
    public static final String ACCOUNT_SAVER_PROPERTY_PREFIX = "stormpath.web.authc.savers.";

    @Override
    protected AuthenticationResultSaver createInstance(ServletContext servletContext) throws Exception {
        Config config = this.getConfig();
        List<String> locations = null;
        String val = (String)config.get(ACCOUNT_SAVER_LOCATIONS);
        if (Strings.hasText((String)val)) {
            String[] locs = Strings.split((String)val);
            locations = Arrays.asList(locs);
        }
        Assert.notEmpty(locations, (String)"At least one stormpath.web.authc.savers value must be specified.");
        assert (locations != null);
        Map<String, Saver> saverMap = config.getInstances(ACCOUNT_SAVER_PROPERTY_PREFIX, Saver.class);
        ArrayList<Saver<AuthenticationResult>> savers = new ArrayList<Saver<AuthenticationResult>>(saverMap.size());
        for (String location : locations) {
            Saver resolver = saverMap.get(location);
            Assert.notNull((Object)resolver, (String)("There is no configured AuthenticationResult Saver named " + location));
            Saver accountResolver = resolver;
            savers.add(accountResolver);
        }
        return new AuthenticationResultSaver(savers);
    }
}

