/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.config;

import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.config.Config;
import com.stormpath.sdk.servlet.config.ConfigResolver;
import com.stormpath.sdk.servlet.config.ConfigSingletonFactory;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.idsite.DefaultIdSiteOrganizationResolver;
import com.stormpath.sdk.servlet.idsite.IdSiteOrganizationContext;
import com.stormpath.sdk.servlet.organization.DefaultOrganizationNameKeyResolver;
import com.stormpath.sdk.servlet.util.SubdomainResolver;
import javax.servlet.ServletContext;

public class DefaultIDSiteOrganizationResolverFactory
extends ConfigSingletonFactory<Resolver<IdSiteOrganizationContext>> {
    protected static final String USE_SUBDOMAIN = "stormpath.web.idSite.useSubdomain";
    protected static final String SHOW_ORGANIZATION_FIELD = "stormpath.web.idSite.showOrganizationField";

    @Override
    protected Resolver<IdSiteOrganizationContext> createInstance(ServletContext servletContext) throws Exception {
        Config config = ConfigResolver.INSTANCE.getConfig(servletContext);
        DefaultIdSiteOrganizationResolver resolver = new DefaultIdSiteOrganizationResolver();
        DefaultOrganizationNameKeyResolver organizationNameKeyResolver = new DefaultOrganizationNameKeyResolver();
        SubdomainResolver subdomainResolver = new SubdomainResolver();
        subdomainResolver.setBaseDomainName(this.getConfig().getWebApplicationDomain());
        organizationNameKeyResolver.setSubdomainResolver(subdomainResolver);
        resolver.setOrganizationNameKeyResolver(organizationNameKeyResolver);
        String useSubdomain = (String)config.get(USE_SUBDOMAIN);
        if (Strings.hasText((String)useSubdomain)) {
            resolver.setUseSubdomain(Boolean.getBoolean(useSubdomain));
        } else {
            resolver.setUseSubdomain(false);
        }
        String showOrganizationField = (String)config.get(SHOW_ORGANIZATION_FIELD);
        if (Strings.hasText((String)useSubdomain)) {
            resolver.setShowOrganizationField(Boolean.getBoolean(showOrganizationField));
        } else {
            resolver.setShowOrganizationField(false);
        }
        return resolver;
    }
}

