/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.mvc;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.filter.HttpFilter;
import com.stormpath.sdk.servlet.http.MediaType;
import com.stormpath.sdk.servlet.mvc.Controller;
import com.stormpath.sdk.servlet.mvc.DefaultViewResolver;
import com.stormpath.sdk.servlet.mvc.InternalResourceViewResolver;
import com.stormpath.sdk.servlet.mvc.JacksonView;
import com.stormpath.sdk.servlet.mvc.View;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import com.stormpath.sdk.servlet.mvc.ViewResolver;
import com.stormpath.sdk.servlet.util.ServletUtils;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerFilter
extends HttpFilter {
    private static final Logger log = LoggerFactory.getLogger(ControllerFilter.class);
    private Controller controller;
    private String prefix = "/WEB-INF/jsp/stormpath/";
    private String suffix = ".jsp";
    private List<MediaType> producedMediaTypes;
    private ViewResolver viewResolver;

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public List<MediaType> getProducedMediaTypes() {
        return this.producedMediaTypes;
    }

    public void setProducedMediaTypes(List<MediaType> producedMediaTypes) {
        this.producedMediaTypes = producedMediaTypes;
    }

    public void setViewResolver(ViewResolver viewResolver) {
        this.viewResolver = viewResolver;
    }

    @Override
    protected void onInit() throws Exception {
        Assert.notNull((Object)this.controller, (String)"Controller instance must be configured.");
        Assert.notEmpty(this.producedMediaTypes, (String)"producedMediaTypes property cannot be null or empty.");
        if (this.viewResolver == null) {
            InternalResourceViewResolver irvr = new InternalResourceViewResolver();
            irvr.setPrefix(this.getPrefix());
            irvr.setSuffix(this.getSuffix());
            this.viewResolver = new DefaultViewResolver(irvr, new JacksonView(), this.producedMediaTypes);
        }
    }

    @Override
    protected void filter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws Exception {
        ViewModel vm;
        try {
            vm = this.controller.handleRequest(request, response);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to invoke Stormpath controller: " + e.getMessage(), e);
        }
        if (vm == null) {
            return;
        }
        View view = this.viewResolver.getView(vm, request);
        if (view == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String viewName = vm.getViewName();
        Assert.hasText((String)viewName, (String)"ViewModel must contain a viewName.");
        boolean redirect = vm.isRedirect();
        if (redirect) {
            this.redirect(request, response, vm);
        } else {
            this.render(request, response, vm);
        }
    }

    protected void redirect(HttpServletRequest request, HttpServletResponse response, ViewModel vm) throws IOException {
        String redirectUri = vm.getViewName();
        log.debug("Redirecting to '{}' for request URI [{}]", (Object)redirectUri, (Object)request.getRequestURI());
        ServletUtils.issueRedirect(request, response, redirectUri, null, true, true);
    }

    protected void render(HttpServletRequest request, HttpServletResponse response, ViewModel vm) throws Exception {
        log.debug("Rendering view '{}' for request URI [{}]", (Object)vm.getViewName(), (Object)request.getRequestURI());
        View view = this.viewResolver.getView(vm, request);
        view.render(request, response, vm);
    }
}

