/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.filter.oauth;

import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.oauth.OAuthPasswordGrantRequestAuthentication;
import com.stormpath.sdk.oauth.OAuthPasswordGrantRequestAuthenticationBuilder;
import com.stormpath.sdk.oauth.OAuthRequests;
import com.stormpath.sdk.servlet.filter.oauth.AccessTokenAuthenticationRequestFactory;
import com.stormpath.sdk.servlet.filter.oauth.OAuthErrorCode;
import com.stormpath.sdk.servlet.filter.oauth.OAuthException;
import com.stormpath.sdk.servlet.http.authc.AccountStoreResolver;
import javax.servlet.http.HttpServletRequest;

public class DefaultAccessTokenAuthenticationRequestFactory
implements AccessTokenAuthenticationRequestFactory {
    protected static final String USERNAME_PARAM_NAME = "username";
    protected static final String PASSWORD_PARAM_NAME = "password";
    private AccountStoreResolver accountStoreResolver;

    public DefaultAccessTokenAuthenticationRequestFactory(AccountStoreResolver accountStoreResolver) {
        Assert.notNull((Object)accountStoreResolver, (String)"AccountStoreResolver cannot be null.");
        this.accountStoreResolver = accountStoreResolver;
    }

    @Override
    public OAuthPasswordGrantRequestAuthentication createAccessTokenAuthenticationRequest(HttpServletRequest request) throws OAuthException {
        try {
            String username = Strings.clean((String)request.getParameter(USERNAME_PARAM_NAME));
            Assert.hasText((String)username, (String)"username must not be null or empty.");
            String password = Strings.clean((String)request.getParameter(PASSWORD_PARAM_NAME));
            Assert.hasText((String)password, (String)"password must not be null or empty.");
            AccountStore accountStore = this.accountStoreResolver.getAccountStore(request, null);
            OAuthPasswordGrantRequestAuthenticationBuilder requestBuilder = ((OAuthPasswordGrantRequestAuthenticationBuilder)OAuthRequests.OAUTH_PASSWORD_GRANT_REQUEST.builder()).setPassword(password).setLogin(username);
            if (accountStore != null) {
                requestBuilder.setAccountStore(accountStore);
            }
            return (OAuthPasswordGrantRequestAuthentication)requestBuilder.build();
        }
        catch (Exception e) {
            throw new OAuthException(OAuthErrorCode.INVALID_REQUEST);
        }
    }
}

